/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.tree.AbstractBoundingBox;
import com.amazon.randomcutforest.tree.IBoxCache;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Random;

public abstract class BoxCache<Point>
implements IBoxCache<Point> {
    protected double cacheFraction;
    protected Random random;
    protected long randomSeed;
    protected AbstractBoundingBox<Point>[] cachedBoxes;
    protected HashMap<Integer, Integer> cacheMap;
    protected BitSet bitSet;
    protected int maxSize;

    protected BoxCache(long seed, double cacheFraction, int maxSize) {
        this.randomSeed = seed;
        this.cacheFraction = cacheFraction;
        this.maxSize = maxSize;
        this.initialize();
    }

    abstract void initialize();

    @Override
    public void setCacheFraction(double cacheFraction) {
        this.cacheFraction = cacheFraction;
        this.initialize();
    }

    boolean isDirectMap() {
        return this.cacheFraction >= 0.3;
    }

    @Override
    public boolean containsKey(int index) {
        if (this.cacheFraction == 0.0) {
            return false;
        }
        if (this.cacheFraction == 1.0) {
            return true;
        }
        if (this.isDirectMap()) {
            return !this.bitSet.get(index);
        }
        return this.cacheMap.containsKey(index);
    }

    @Override
    public void setBox(int index, AbstractBoundingBox<Point> box) {
        if (!this.containsKey(index)) {
            return;
        }
        if (this.isDirectMap()) {
            this.cachedBoxes[index] = box;
        } else {
            this.cachedBoxes[this.cacheMap.get((Object)Integer.valueOf((int)index)).intValue()] = box;
        }
    }

    @Override
    public AbstractBoundingBox<Point> getBox(int index) {
        if (!this.containsKey(index)) {
            return null;
        }
        if (this.isDirectMap()) {
            return this.cachedBoxes[index];
        }
        return this.cachedBoxes[this.cacheMap.get(index)];
    }

    abstract void remap(int[] var1);

    @Override
    public void swapCaches(int[] map) {
        if (this.cacheMap != null) {
            HashMap<Integer, Integer> newMap = new HashMap<Integer, Integer>();
            for (int i = 0; i < map.length; ++i) {
                if (!this.cacheMap.containsKey(i)) continue;
                newMap.put(map[i], this.cacheMap.get(i));
            }
            this.cacheMap = newMap;
        } else if (this.bitSet != null) {
            BitSet newBitSet = new BitSet(this.maxSize);
            for (int i = 0; i < map.length; ++i) {
                if (!this.bitSet.get(i)) continue;
                newBitSet.set(map[i]);
            }
            this.bitSet = newBitSet;
        } else if (this.cachedBoxes != null) {
            this.remap(map);
        }
    }

    @Override
    public void addToBox(int index, Point point) {
        if (!this.containsKey(index)) {
            return;
        }
        if (this.isDirectMap()) {
            if (this.cachedBoxes[index] == null) {
                return;
            }
            this.cachedBoxes[index].addPoint(point);
        } else {
            if (this.cachedBoxes[this.cacheMap.get(index)] == null) {
                return;
            }
            this.cachedBoxes[this.cacheMap.get(index)].addPoint(point);
        }
    }
}

