/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.tree.AbstractBoundingBox;
import com.amazon.randomcutforest.tree.IBoundingBoxView;
import java.util.Arrays;

public class BoundingBoxFloat
extends AbstractBoundingBox<float[]> {
    public BoundingBoxFloat(float[] point) {
        super(point);
    }

    public BoundingBoxFloat(float[] minValues, float[] maxValues, double sum) {
        super(minValues, maxValues, sum);
    }

    public BoundingBoxFloat(float[] first, float[] second) {
        super(new float[first.length], new float[second.length], 0.0);
        for (int i = 0; i < ((float[])this.minValues).length; ++i) {
            ((float[])this.minValues)[i] = Math.min(first[i], second[i]);
            ((float[])this.maxValues)[i] = Math.max(first[i], second[i]);
            this.rangeSum += (double)(((float[])this.maxValues)[i] - ((float[])this.minValues)[i]);
        }
    }

    @Override
    public AbstractBoundingBox<float[]> copy() {
        return new BoundingBoxFloat(Arrays.copyOf((float[])this.minValues, ((float[])this.minValues).length), Arrays.copyOf((float[])this.maxValues, ((float[])this.maxValues).length), this.rangeSum);
    }

    @Override
    public IBoundingBoxView getMergedBox(double[] point) {
        return this.getMergedBox(CommonUtils.toFloatArray(point));
    }

    @Override
    public IBoundingBoxView getMergedBox(IBoundingBoxView otherBox) {
        float[] minValuesMerged = new float[((float[])this.minValues).length];
        float[] maxValuesMerged = new float[((float[])this.minValues).length];
        double sum = 0.0;
        for (int i = 0; i < ((float[])this.minValues).length; ++i) {
            minValuesMerged[i] = Math.min(((float[])this.minValues)[i], (float)otherBox.getMinValue(i));
            maxValuesMerged[i] = Math.max(((float[])this.maxValues)[i], (float)otherBox.getMaxValue(i));
            sum += (double)(maxValuesMerged[i] - minValuesMerged[i]);
        }
        return new BoundingBoxFloat(minValuesMerged, maxValuesMerged, sum);
    }

    public IBoundingBoxView getMergedBox(float[] point) {
        CommonUtils.checkArgument(point.length == ((float[])this.minValues).length, "incorrect length");
        return ((AbstractBoundingBox)this.copy()).addPoint(point);
    }

    public BoundingBoxFloat addPoint(float[] point) {
        CommonUtils.checkArgument(((float[])this.minValues).length == point.length, "incorrect length");
        CommonUtils.checkArgument(this.minValues != this.maxValues, "not a mutable box");
        this.rangeSum = 0.0;
        for (int i = 0; i < point.length; ++i) {
            ((float[])this.minValues)[i] = Math.min(((float[])this.minValues)[i], point[i]);
            ((float[])this.maxValues)[i] = Math.max(((float[])this.maxValues)[i], point[i]);
            this.rangeSum += (double)(((float[])this.maxValues)[i] - ((float[])this.minValues)[i]);
        }
        return this;
    }

    public BoundingBoxFloat addBox(AbstractBoundingBox<float[]> otherBox) {
        CommonUtils.checkState(this.minValues != this.maxValues, "not a mutable box");
        this.rangeSum = 0.0;
        for (int i = 0; i < ((float[])this.minValues).length; ++i) {
            ((float[])this.minValues)[i] = Math.min(((float[])this.minValues)[i], ((float[])otherBox.minValues)[i]);
            ((float[])this.maxValues)[i] = Math.max(((float[])this.maxValues)[i], ((float[])otherBox.maxValues)[i]);
            this.rangeSum += (double)(((float[])this.maxValues)[i] - ((float[])this.minValues)[i]);
        }
        return this;
    }

    @Override
    public int getDimensions() {
        return ((float[])this.minValues).length;
    }

    @Override
    public double getRangeSum() {
        return this.rangeSum;
    }

    @Override
    public double getMaxValue(int dimension) {
        return ((float[])this.maxValues)[dimension];
    }

    @Override
    public double getMinValue(int dimension) {
        return ((float[])this.minValues)[dimension];
    }

    @Override
    public boolean contains(float[] point) {
        CommonUtils.checkArgument(point.length == ((float[])this.minValues).length, " incorrect lengths");
        for (int i = 0; i < ((float[])this.minValues).length; ++i) {
            if (!(((float[])this.minValues)[i] > point[i]) && !(((float[])this.maxValues)[i] < point[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public double getRange(int dimension) {
        return ((float[])this.maxValues)[dimension] - ((float[])this.minValues)[dimension];
    }

    @Override
    public String toString() {
        return String.format("BoundingBox(%s, %s)", Arrays.toString((float[])this.minValues), Arrays.toString((float[])this.maxValues));
    }

    public boolean equals(Object other) {
        if (!(other instanceof BoundingBoxFloat)) {
            return false;
        }
        BoundingBoxFloat otherBox = (BoundingBoxFloat)other;
        return Arrays.equals((float[])this.minValues, (float[])otherBox.minValues) && Arrays.equals((float[])this.maxValues, (float[])otherBox.maxValues);
    }
}

