/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.tree.AbstractBoundingBox;
import com.amazon.randomcutforest.tree.IBoundingBoxView;
import java.util.Arrays;

public class BoundingBox
extends AbstractBoundingBox<double[]> {
    public BoundingBox(double[] point) {
        super(point);
    }

    BoundingBox(double[] minValues, double[] maxValues, double sum) {
        super(minValues, maxValues, sum);
    }

    public BoundingBox(double[] first, double[] second) {
        super(new double[first.length], new double[second.length], 0.0);
        for (int i = 0; i < ((double[])this.minValues).length; ++i) {
            ((double[])this.minValues)[i] = Math.min(first[i], second[i]);
            ((double[])this.maxValues)[i] = Math.max(first[i], second[i]);
            this.rangeSum += ((double[])this.maxValues)[i] - ((double[])this.minValues)[i];
        }
    }

    @Override
    public BoundingBox copy() {
        return new BoundingBox(Arrays.copyOf((double[])this.minValues, ((double[])this.minValues).length), Arrays.copyOf((double[])this.maxValues, ((double[])this.maxValues).length), this.rangeSum);
    }

    @Override
    public BoundingBox getMergedBox(double[] point) {
        CommonUtils.checkArgument(point.length == ((double[])this.minValues).length, "incorrect length");
        return this.copy().addPoint(point);
    }

    @Override
    public BoundingBox getMergedBox(IBoundingBoxView otherBox) {
        double[] minValuesMerged = new double[((double[])this.minValues).length];
        double[] maxValuesMerged = new double[((double[])this.minValues).length];
        double sum = 0.0;
        for (int i = 0; i < ((double[])this.minValues).length; ++i) {
            minValuesMerged[i] = Math.min(((double[])this.minValues)[i], otherBox.getMinValue(i));
            maxValuesMerged[i] = Math.max(((double[])this.maxValues)[i], otherBox.getMaxValue(i));
            sum += maxValuesMerged[i] - minValuesMerged[i];
        }
        return new BoundingBox(minValuesMerged, maxValuesMerged, sum);
    }

    public BoundingBox addPoint(double[] point) {
        CommonUtils.checkArgument(((double[])this.minValues).length == point.length, "incorrect length");
        CommonUtils.checkArgument(this.minValues != this.maxValues, "not a mutable box");
        this.rangeSum = 0.0;
        for (int i = 0; i < point.length; ++i) {
            ((double[])this.minValues)[i] = Math.min(((double[])this.minValues)[i], point[i]);
            ((double[])this.maxValues)[i] = Math.max(((double[])this.maxValues)[i], point[i]);
            this.rangeSum += ((double[])this.maxValues)[i] - ((double[])this.minValues)[i];
        }
        return this;
    }

    public BoundingBox addBox(AbstractBoundingBox<double[]> otherBox) {
        CommonUtils.checkState(this.minValues != this.maxValues, "not a mutable box");
        this.rangeSum = 0.0;
        for (int i = 0; i < ((double[])this.minValues).length; ++i) {
            ((double[])this.minValues)[i] = Math.min(((double[])this.minValues)[i], ((double[])otherBox.minValues)[i]);
            ((double[])this.maxValues)[i] = Math.max(((double[])this.maxValues)[i], ((double[])otherBox.maxValues)[i]);
            this.rangeSum += ((double[])this.maxValues)[i] - ((double[])this.minValues)[i];
        }
        return this;
    }

    @Override
    public int getDimensions() {
        return ((double[])this.minValues).length;
    }

    @Override
    public double getMaxValue(int dimension) {
        return ((double[])this.maxValues)[dimension];
    }

    @Override
    public double getMinValue(int dimension) {
        return ((double[])this.minValues)[dimension];
    }

    @Override
    public double getRange(int dimension) {
        return ((double[])this.maxValues)[dimension] - ((double[])this.minValues)[dimension];
    }

    @Override
    public String toString() {
        return String.format("BoundingBox(%s, %s)", Arrays.toString((double[])this.minValues), Arrays.toString((double[])this.maxValues));
    }

    @Override
    public boolean contains(double[] point) {
        CommonUtils.checkArgument(point.length == this.getDimensions(), " incorrect lengths");
        for (int i = 0; i < point.length; ++i) {
            if (!(((double[])this.minValues)[i] > point[i]) && !(((double[])this.maxValues)[i] < point[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (!(other instanceof BoundingBox)) {
            return false;
        }
        BoundingBox otherBox = (BoundingBox)other;
        return Arrays.equals((double[])this.minValues, (double[])otherBox.minValues) && Arrays.equals((double[])this.maxValues, (double[])otherBox.maxValues);
    }
}

