/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.IMultiVisitorFactory;
import com.amazon.randomcutforest.IVisitorFactory;
import com.amazon.randomcutforest.MultiVisitor;
import com.amazon.randomcutforest.Visitor;
import com.amazon.randomcutforest.tree.AbstractBoundingBox;
import com.amazon.randomcutforest.tree.Cut;
import com.amazon.randomcutforest.tree.INode;
import com.amazon.randomcutforest.tree.ITree;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;

public abstract class AbstractRandomCutTree<Point, NodeReference, PointReference>
implements ITree<PointReference, Point> {
    private Random testRandom;
    private long randomSeed;
    protected NodeReference root;
    public final boolean centerOfMassEnabled;
    public final boolean storeSequenceIndexesEnabled;
    protected double boundingBoxCacheFraction = 1.0;
    Random cacheRandom = new Random(0L);
    protected int outputAfter;

    protected AbstractRandomCutTree(Builder<?> builder) {
        if (builder.random != null) {
            this.testRandom = builder.random;
        } else {
            this.randomSeed = builder.randomSeed;
        }
        this.centerOfMassEnabled = builder.centerOfMassEnabled;
        this.storeSequenceIndexesEnabled = builder.storeSequenceIndexesEnabled;
        this.boundingBoxCacheFraction = builder.boundingBoxCacheFraction;
        this.outputAfter = Integer.MAX_VALUE;
    }

    @Override
    public <T> void setConfig(String name, T value, Class<T> clazz) {
        if (!"bounding_box_cache_fraction".equals(name)) {
            throw new IllegalArgumentException("Unsupported configuration setting: " + name);
        }
        CommonUtils.checkArgument(Double.class.isAssignableFrom(clazz), String.format("Setting '%s' must be a double value", name));
        this.setBoundingBoxCacheFraction((Double)value);
    }

    @Override
    public <T> T getConfig(String name, Class<T> clazz) {
        CommonUtils.checkNotNull(clazz, "clazz must not be null");
        if ("bounding_box_cache_fraction".equals(name)) {
            CommonUtils.checkArgument(clazz.isAssignableFrom(Double.class), String.format("Setting '%s' must be a double value", name));
            return clazz.cast(this.boundingBoxCacheFraction);
        }
        throw new IllegalArgumentException("Unsupported configuration setting: " + name);
    }

    public void setBoundingBoxCacheFraction(double fraction) {
        CommonUtils.checkArgument(0.0 <= fraction && fraction <= 1.0, "incorrect parameter");
        this.boundingBoxCacheFraction = fraction;
    }

    protected Cut randomCut(Random random, AbstractBoundingBox<?> box) {
        double rangeSum = box.getRangeSum();
        CommonUtils.checkArgument(rangeSum > 0.0, "box.getRangeSum() must be greater than 0");
        double breakPoint = random.nextDouble() * rangeSum;
        for (int i = 0; i < box.getDimensions(); ++i) {
            double range = box.getRange(i);
            if (breakPoint <= range) {
                double cutValue = box.getMinValue(i) + breakPoint;
                if (cutValue >= box.getMaxValue(i) && box.getMinValue(i) < box.getMaxValue(i)) {
                    cutValue = Math.nextAfter(box.getMaxValue(i), box.getMinValue(i));
                }
                return new Cut(i, cutValue);
            }
            breakPoint -= range;
        }
        throw new IllegalStateException("The break point did not lie inside the expected range");
    }

    protected abstract boolean leftOf(Point var1, int var2, double var3);

    protected abstract boolean equals(Point var1, Point var2);

    protected abstract boolean referenceEquals(PointReference var1, PointReference var2);

    protected abstract String toString(Point var1);

    protected abstract AbstractBoundingBox<Point> getInternalTwoPointBox(PointReference var1, PointReference var2);

    protected AbstractBoundingBox<Point> getBoundingBox(NodeReference nodeReference) {
        if (this.isLeaf(nodeReference)) {
            return this.getLeafBoxFromLeafNode(nodeReference);
        }
        return this.constructBoxInPlace(nodeReference);
    }

    protected abstract AbstractBoundingBox<Point> getLeafBoxFromLeafNode(NodeReference var1);

    protected abstract AbstractBoundingBox<Point> getMutableLeafBoxFromLeafNode(NodeReference var1);

    protected abstract AbstractBoundingBox<Point> constructBoxInPlace(NodeReference var1);

    abstract Point getPointFromPointReference(PointReference var1);

    abstract PointReference getPointReference(NodeReference var1);

    Point getPointFromLeafNode(NodeReference node) {
        return this.getPointFromPointReference(this.getPointReference(node));
    }

    protected abstract boolean isLeaf(NodeReference var1);

    protected abstract int decrementMass(NodeReference var1);

    protected abstract int incrementMass(NodeReference var1);

    protected abstract NodeReference getSibling(NodeReference var1);

    protected abstract NodeReference getParent(NodeReference var1);

    protected abstract void setParent(NodeReference var1, NodeReference var2);

    protected abstract void delete(NodeReference var1);

    protected abstract int getCutDimension(NodeReference var1);

    protected abstract double getCutValue(NodeReference var1);

    protected abstract NodeReference getLeftChild(NodeReference var1);

    protected abstract NodeReference getRightChild(NodeReference var1);

    abstract void replaceChild(NodeReference var1, NodeReference var2, NodeReference var3);

    protected abstract void replaceNodeBySibling(NodeReference var1, NodeReference var2, NodeReference var3);

    protected abstract NodeReference addLeaf(PointReference var1);

    protected abstract NodeReference addNode(NodeReference var1, NodeReference var2, int var3, double var4, int var6);

    protected abstract void increaseMassOfAncestors(NodeReference var1);

    protected abstract void decreaseMassOfAncestors(NodeReference var1);

    protected abstract int getMass(NodeReference var1);

    protected abstract void addSequenceIndex(NodeReference var1, long var2);

    protected abstract void deleteSequenceIndex(NodeReference var1, long var2);

    abstract void recomputePointSum(NodeReference var1);

    void updateAncestorPointSum(NodeReference node) {
        if (this.centerOfMassEnabled) {
            NodeReference tempNode = node;
            while (tempNode != null) {
                this.recomputePointSum(tempNode);
                tempNode = this.getParent(tempNode);
            }
        }
    }

    abstract AbstractBoundingBox<Point> recomputeBox(NodeReference var1);

    void updateAncestorNodesAfterDelete(NodeReference nodeReference, PointReference pointReference) {
        boolean boxNeedsUpdate;
        Point point = this.getPointFromPointReference(pointReference);
        NodeReference tempNode = nodeReference;
        boolean bl = boxNeedsUpdate = this.boundingBoxCacheFraction > 0.0;
        while (boxNeedsUpdate && tempNode != null) {
            AbstractBoundingBox<Point> box = this.recomputeBox(tempNode);
            boxNeedsUpdate = box == null || !box.contains(point);
            tempNode = this.getParent(tempNode);
        }
        this.updateAncestorPointSum(nodeReference);
    }

    NodeReference findLeaf(Point point) {
        if (this.root == null) {
            return null;
        }
        NodeReference nodeReference = this.root;
        while (!this.isLeaf(nodeReference)) {
            nodeReference = this.leftOf(point, this.getCutDimension(nodeReference), this.getCutValue(nodeReference)) ? this.getLeftChild(nodeReference) : this.getRightChild(nodeReference);
        }
        return nodeReference;
    }

    NodeReference findLeafAndVerify(PointReference pointReference) {
        Point point = this.getPointFromPointReference(pointReference);
        NodeReference nodeReference = this.findLeaf(point);
        if (this.referenceEquals(pointReference, this.getPointReference(nodeReference))) {
            return nodeReference;
        }
        Point oldPoint = this.getPointFromLeafNode(nodeReference);
        if (!this.equals(oldPoint, point)) {
            throw new IllegalStateException(this.toString(point) + " " + this.toString(this.getPointFromLeafNode(nodeReference)) + " " + nodeReference + " node " + false + " Inconsistency in trees.");
        }
        return nodeReference;
    }

    abstract void setLeafPointReference(NodeReference var1, PointReference var2);

    protected void switchLeafReference(PointReference newRef) {
        CommonUtils.checkNotNull(newRef, " cannot be null ");
        NodeReference nodeReference = this.findLeafAndVerify(newRef);
        this.setLeafPointReference(nodeReference, newRef);
    }

    protected PointReference getEquivalentReference(PointReference newReference) {
        Point point = this.getPointFromPointReference(newReference);
        NodeReference nodeReference = this.findLeaf(point);
        if (nodeReference != null) {
            PointReference reference = this.getPointReference(nodeReference);
            if (!this.equals(point, this.getPointFromPointReference(reference))) {
                return null;
            }
            return reference;
        }
        return null;
    }

    protected int getCopiesOfReference(PointReference reference) {
        CommonUtils.checkNotNull(reference, " reference cannot be null ");
        NodeReference nodeReference = this.findLeafAndVerify(reference);
        return reference == this.getPointReference(nodeReference) ? this.getMass(nodeReference) : 0;
    }

    @Override
    public PointReference deletePoint(PointReference pointReference, long sequenceNumber) {
        CommonUtils.checkState(this.root != null, "root must not be null");
        NodeReference nodeReference = this.findLeafAndVerify(pointReference);
        if (this.storeSequenceIndexesEnabled) {
            this.deleteSequenceIndex(nodeReference, sequenceNumber);
        }
        PointReference returnVal = this.getPointReference(nodeReference);
        this.decreaseMassOfAncestors(nodeReference);
        if (this.decrementMass(nodeReference) > 0) {
            this.updateAncestorPointSum(this.getParent(nodeReference));
            return returnVal;
        }
        NodeReference parent = this.getParent(nodeReference);
        if (parent == null) {
            this.root = null;
            this.delete(nodeReference);
            return returnVal;
        }
        NodeReference grandParent = this.getParent(parent);
        if (grandParent == null) {
            this.root = this.getSibling(nodeReference);
            this.setParent(this.root, null);
        } else {
            this.replaceNodeBySibling(grandParent, parent, nodeReference);
            this.updateAncestorNodesAfterDelete(grandParent, pointReference);
        }
        this.delete(nodeReference);
        this.delete(parent);
        return returnVal;
    }

    abstract void setCachedBox(NodeReference var1, AbstractBoundingBox<Point> var2);

    abstract void addToBox(NodeReference var1, Point var2);

    void updateAncestorNodesAfterAdd(AbstractBoundingBox<Point> savedBox, NodeReference mergedNode, Point point, NodeReference parentIndex) {
        this.increaseMassOfAncestors(mergedNode);
        if (this.boundingBoxCacheFraction > 0.0) {
            this.setCachedBox(mergedNode, savedBox);
            NodeReference tempNode = this.getParent(mergedNode);
            while (tempNode != null && !tempNode.equals(parentIndex)) {
                this.addToBox(tempNode, point);
                tempNode = this.getParent(tempNode);
            }
        }
        if (this.centerOfMassEnabled) {
            this.updateAncestorPointSum(mergedNode);
        }
    }

    @Override
    public PointReference addPoint(PointReference pointReference, long sequenceNumber) {
        NodeReference leafNodeForAdd;
        if (this.root == null) {
            this.root = this.addLeaf(pointReference);
            leafNodeForAdd = this.root;
        } else {
            Point oldPoint;
            Point point = this.getPointFromPointReference(pointReference);
            NodeReference followReference = this.findLeaf(point);
            PointReference leafPointReference = this.getPointReference(followReference);
            Point Point = oldPoint = leafPointReference == null ? null : (Point)this.getPointFromPointReference(leafPointReference);
            if (leafPointReference == null || this.equals(oldPoint, point)) {
                if (leafPointReference == null) {
                    this.setLeafPointReference(followReference, pointReference);
                }
                this.incrementMass(followReference);
                this.increaseMassOfAncestors(followReference);
                if (this.storeSequenceIndexesEnabled) {
                    this.addSequenceIndex(followReference, sequenceNumber);
                }
                this.updateAncestorPointSum(this.getParent(followReference));
                return this.getPointReference(followReference);
            }
            Random random = this.testRandom != null ? this.testRandom : new Random(this.randomSeed);
            this.randomSeed = this.testRandom != null ? this.randomSeed : random.nextLong();
            AbstractBoundingBox<Point> savedBox = this.getInternalTwoPointBox(pointReference, leafPointReference);
            Cut savedCut = this.randomCut(random, savedBox);
            AbstractBoundingBox<Point> currentUnmergedBox = this.getMutableLeafBoxFromLeafNode(followReference);
            NodeReference savedSiblingNode = followReference;
            assert (currentUnmergedBox != null) : "incorrect state";
            followReference = this.getParent(followReference);
            boolean resolved = false;
            while (!resolved && followReference != null) {
                AbstractBoundingBox<Point> existingBox;
                if (this.boundingBoxCacheFraction > 0.0) {
                    existingBox = this.getBoundingBox(followReference);
                } else {
                    NodeReference sibling = this.leftOf(point, this.getCutDimension(followReference), this.getCutValue(followReference)) ? this.getRightChild(followReference) : this.getLeftChild(followReference);
                    existingBox = currentUnmergedBox.addBox(this.getBoundingBox(sibling));
                }
                if (existingBox.contains(point)) {
                    resolved = true;
                    continue;
                }
                AbstractBoundingBox<Point> mergedBox = ((AbstractBoundingBox)existingBox.copy()).addPoint(point);
                Cut cut = this.randomCut(random, mergedBox);
                int splitDimension = cut.getDimension();
                double splitValue = cut.getValue();
                double minValue = existingBox.getMinValue(splitDimension);
                double maxValue = existingBox.getMaxValue(splitDimension);
                if (minValue > splitValue || maxValue <= splitValue) {
                    savedSiblingNode = followReference;
                    savedCut = cut;
                    savedBox = mergedBox;
                }
                currentUnmergedBox = existingBox;
                followReference = this.getParent(followReference);
            }
            NodeReference newParent = followReference;
            int cutDimension = savedCut.getDimension();
            double cutValue = savedCut.getValue();
            int oldMass = this.getMass(savedSiblingNode);
            leafNodeForAdd = this.addLeaf(pointReference);
            NodeReference mergedNode = this.leftOf(point, cutDimension, cutValue) ? this.addNode(leafNodeForAdd, savedSiblingNode, cutDimension, cutValue, oldMass + 1) : this.addNode(savedSiblingNode, leafNodeForAdd, cutDimension, cutValue, oldMass + 1);
            NodeReference oldParent = this.getParent(savedSiblingNode);
            if (oldParent == null) {
                this.root = mergedNode;
            } else {
                this.replaceChild(oldParent, savedSiblingNode, mergedNode);
            }
            this.setParent(leafNodeForAdd, mergedNode);
            this.setParent(savedSiblingNode, mergedNode);
            this.updateAncestorNodesAfterAdd(savedBox, mergedNode, point, newParent);
        }
        if (this.storeSequenceIndexesEnabled) {
            this.addSequenceIndex(leafNodeForAdd, sequenceNumber);
        }
        return pointReference;
    }

    protected abstract double[] getPoint(NodeReference var1);

    protected boolean leftOf(double[] point, NodeReference nodeReference) {
        return point[this.getCutDimension(nodeReference)] <= this.getCutValue(nodeReference);
    }

    protected abstract INode<NodeReference> getNode(NodeReference var1);

    @Override
    public <R> R traverse(double[] point, IVisitorFactory<R> visitorFactory) {
        CommonUtils.checkState(this.root != null, "this tree doesn't contain any nodes");
        Visitor<R> visitor = visitorFactory.newVisitor(this, point);
        this.traversePathToLeafAndVisitNodes(this.projectToTree(point), visitor, this.root, 0);
        return visitorFactory.liftResult(this, visitor.getResult());
    }

    private <R> void traversePathToLeafAndVisitNodes(double[] point, Visitor<R> visitor, NodeReference node, int depthOfNode) {
        if (this.isLeaf(node)) {
            visitor.acceptLeaf(this.getNode(node), depthOfNode);
        } else {
            NodeReference nextNode = this.leftOf(point, node) ? this.getLeftChild(node) : this.getRightChild(node);
            this.traversePathToLeafAndVisitNodes(point, visitor, nextNode, depthOfNode + 1);
            visitor.accept(this.getNode(node), depthOfNode);
        }
    }

    @Override
    public <R> R traverseMulti(double[] point, IMultiVisitorFactory<R> visitorFactory) {
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkNotNull(visitorFactory, "visitor must not be null");
        CommonUtils.checkState(this.root != null, "this tree doesn't contain any nodes");
        MultiVisitor<R> visitor = visitorFactory.newVisitor(this, point);
        this.traverseTreeMulti(this.projectToTree(point), visitor, this.root, 0);
        return visitorFactory.liftResult(this, visitor.getResult());
    }

    private <R> void traverseTreeMulti(double[] point, MultiVisitor<R> visitor, NodeReference node, int depthOfNode) {
        if (this.isLeaf(node)) {
            visitor.acceptLeaf(this.getNode(node), depthOfNode);
        } else {
            if (visitor.trigger(this.getNode(node))) {
                this.traverseTreeMulti(point, visitor, this.getLeftChild(node), depthOfNode + 1);
                MultiVisitor<R> newVisitor = visitor.newCopy();
                this.traverseTreeMulti(point, newVisitor, this.getRightChild(node), depthOfNode + 1);
                visitor.combine(newVisitor);
            } else {
                NodeReference nextNode = this.leftOf(point, node) ? this.getLeftChild(node) : this.getRightChild(node);
                this.traverseTreeMulti(point, visitor, nextNode, depthOfNode + 1);
            }
            visitor.accept(this.getNode(node), depthOfNode);
        }
    }

    @Override
    public int getMass() {
        return this.root == null ? 0 : this.getMass(this.root);
    }

    public NodeReference getRoot() {
        return this.root;
    }

    public int getOutputAfter() {
        return this.outputAfter;
    }

    @Override
    public boolean isOutputReady() {
        return this.getMass() >= this.outputAfter;
    }

    @Override
    public double[] projectToTree(double[] point) {
        return Arrays.copyOf(point, point.length);
    }

    @Override
    public double[] liftFromTree(double[] result) {
        return Arrays.copyOf(result, result.length);
    }

    @Override
    public int[] projectMissingIndices(int[] list) {
        return Arrays.copyOf(list, list.length);
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public static class Builder<T> {
        protected boolean storeSequenceIndexesEnabled = false;
        protected boolean centerOfMassEnabled = false;
        protected double boundingBoxCacheFraction = 1.0;
        protected long randomSeed = new Random().nextLong();
        protected Random random = null;
        protected Optional<Integer> outputAfter = Optional.empty();
        protected int inputDimension;
        protected int dimension;

        public T storeSequenceIndexesEnabled(boolean storeSequenceIndexesEnabled) {
            this.storeSequenceIndexesEnabled = storeSequenceIndexesEnabled;
            return (T)this;
        }

        public T centerOfMassEnabled(boolean centerOfMassEnabled) {
            this.centerOfMassEnabled = centerOfMassEnabled;
            return (T)this;
        }

        public T boundingBoxCacheFraction(double boundingBoxCacheFraction) {
            this.boundingBoxCacheFraction = boundingBoxCacheFraction;
            return (T)this;
        }

        public T randomSeed(long randomSeed) {
            this.randomSeed = randomSeed;
            return (T)this;
        }

        public T random(Random random) {
            this.random = random;
            return (T)this;
        }

        public T outputAfter(int outputAfter) {
            this.outputAfter = Optional.of(outputAfter);
            return (T)this;
        }

        public T inputDimension(int inputDimension) {
            this.inputDimension = inputDimension;
            return (T)this;
        }

        public T dimension(int dimension) {
            this.dimension = dimension;
            return (T)this;
        }
    }
}

