/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.store.INodeStore;
import com.amazon.randomcutforest.store.IPointStoreView;
import com.amazon.randomcutforest.store.NodeStore;
import com.amazon.randomcutforest.store.SmallNodeStore;
import com.amazon.randomcutforest.tree.AbstractBoundingBox;
import com.amazon.randomcutforest.tree.AbstractRandomCutTree;
import com.amazon.randomcutforest.tree.CompactNodeView;
import com.amazon.randomcutforest.tree.IBoxCache;
import com.amazon.randomcutforest.tree.INode;
import com.amazon.randomcutforest.tree.ITree;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;

public abstract class AbstractCompactRandomCutTree<Point>
extends AbstractRandomCutTree<Point, Integer, Integer>
implements ITree<Integer, Point> {
    public static final int NULL = -1;
    protected int maxSize;
    protected INodeStore nodeStore;
    protected IPointStoreView<Point> pointStore;
    protected IBoxCache<Point> boxCache;
    protected Point[] pointSum;
    protected HashMap<Long, Integer>[] sequenceIndexes;
    protected Precision precision;
    protected int dimension;

    public AbstractCompactRandomCutTree(Builder<?> builder) {
        super(builder);
        CommonUtils.checkArgument(((Builder)builder).maxSize > 0, "maxSize must be greater than 0");
        this.precision = builder.precision;
        this.dimension = builder.dimension;
        this.maxSize = ((Builder)builder).maxSize;
        this.outputAfter = builder.outputAfter.isPresent() ? (Integer)builder.outputAfter.get() : this.maxSize / 4;
        if (((Builder)builder).root == -1) {
            this.nodeStore = this.isSmallNodeStoreInUse() ? new SmallNodeStore(this.maxSize - 1) : new NodeStore(this.maxSize - 1);
            this.root = null;
        } else {
            CommonUtils.checkNotNull(((Builder)builder).nodeStore, "nodeStore must not be null");
            this.nodeStore = ((Builder)builder).nodeStore;
            this.root = ((Builder)builder).root;
        }
        if (this.storeSequenceIndexesEnabled) {
            this.sequenceIndexes = new HashMap[this.maxSize];
        }
    }

    public static boolean canUseSmallNodeStore(Precision precision, int capacity, int dimensions) {
        return precision == Precision.FLOAT_32 && capacity < SmallNodeStore.MAX_SMALLNODESTORE_CAPACITY && dimensions < Short.MAX_VALUE;
    }

    public boolean isSmallNodeStoreInUse() {
        return AbstractCompactRandomCutTree.canUseSmallNodeStore(this.precision, this.maxSize, this.dimension);
    }

    public INodeStore getNodeStore() {
        return this.nodeStore;
    }

    @Override
    protected INode<Integer> getNode(Integer node) {
        return new CompactNodeView(this, node);
    }

    @Override
    protected void addSequenceIndex(Integer nodeRef, long sequenceIndex) {
        int leafRef = this.nodeStore.computeLeafIndex(nodeRef);
        if (this.sequenceIndexes[leafRef] == null) {
            this.sequenceIndexes[leafRef] = new HashMap();
        }
        int num = 0;
        if (this.sequenceIndexes[leafRef].containsKey(sequenceIndex)) {
            num = this.sequenceIndexes[leafRef].get(sequenceIndex);
        }
        this.sequenceIndexes[leafRef].put(sequenceIndex, num + 1);
    }

    public double getBoundingBoxCacheFraction() {
        return this.boundingBoxCacheFraction;
    }

    public void reorderNodesInBreadthFirstOrder() {
        INodeStore result;
        INodeStore iNodeStore = result = this.isSmallNodeStoreInUse() ? new SmallNodeStore(this.maxSize - 1) : new NodeStore(this.maxSize - 1);
        if (this.root != null) {
            if (!this.isLeaf((Integer)this.root)) {
                int nodeCounter = 0;
                int currentNode = 0;
                int leafcounter = this.maxSize - 1;
                int[] map = new int[2 * this.maxSize - 1];
                Arrays.fill(map, -1);
                ArrayBlockingQueue<Integer> nodeQueue = new ArrayBlockingQueue<Integer>(this.maxSize - 1);
                nodeQueue.add((Integer)this.root);
                while (!nodeQueue.isEmpty()) {
                    int newRight;
                    int newLeft;
                    int head = (Integer)nodeQueue.poll();
                    int leftChild = this.getLeftChild(head);
                    if (this.isLeaf(leftChild)) {
                        map[leftChild] = result.addLeaf(currentNode, this.getPointReference(leftChild), this.getMass(leftChild));
                        assert (map[leftChild] == leafcounter) : "incorrect state";
                        newLeft = leafcounter++;
                    } else {
                        newLeft = ++nodeCounter;
                        nodeQueue.add(leftChild);
                    }
                    int rightChild = this.getRightChild(head);
                    if (this.isLeaf(rightChild)) {
                        map[rightChild] = result.addLeaf(currentNode, this.getPointReference(rightChild), this.getMass(rightChild));
                        assert (map[rightChild] == leafcounter) : "incorrect state";
                        newRight = leafcounter++;
                    } else {
                        newRight = ++nodeCounter;
                        nodeQueue.add(rightChild);
                    }
                    int parent = head == (Integer)this.root ? -1 : map[this.getParent(head)];
                    map[head] = result.addNode(parent, newLeft, newRight, this.getCutDimension(head), this.getCutValue(head), this.getMass(head));
                    assert (map[head] == currentNode) : "incorrect state";
                    ++currentNode;
                }
                assert (currentNode == this.nodeStore.size()) : "incorrect state";
                this.boxCache.swapCaches(map);
                if (this.storeSequenceIndexesEnabled) {
                    HashMap[] newSequence = new HashMap[this.maxSize];
                    for (int i = 0; i < this.maxSize; ++i) {
                        if (map[i + this.maxSize - 1] == -1) continue;
                        assert (this.isLeaf(map[i + this.maxSize - 1])) : "error in map";
                        newSequence[map[i + this.maxSize - 1] - this.maxSize + 1] = this.sequenceIndexes[i];
                    }
                    this.sequenceIndexes = newSequence;
                }
                this.root = 0;
            } else {
                this.root = result.addLeaf(-1, this.getPointReference((Integer)this.root), this.getMass((Integer)this.root));
            }
        }
        this.nodeStore = result;
        if (this.centerOfMassEnabled && !this.isLeaf((Integer)this.root)) {
            this.recomputePointSum((Integer)this.root);
        }
    }

    @Override
    protected void deleteSequenceIndex(Integer nodeRef, long sequenceIndex) {
        int leafRef = this.nodeStore.computeLeafIndex(nodeRef);
        if (this.sequenceIndexes[leafRef] == null || !this.sequenceIndexes[leafRef].containsKey(sequenceIndex)) {
            throw new IllegalStateException("Error in sequence index. Inconsistency in trees in delete step.");
        }
        int num = this.sequenceIndexes[leafRef].get(sequenceIndex);
        if (num == 1) {
            this.sequenceIndexes[leafRef].remove(sequenceIndex);
        } else {
            this.sequenceIndexes[leafRef].put(sequenceIndex, num - 1);
        }
    }

    @Override
    protected AbstractBoundingBox<Point> constructBoxInPlace(Integer nodeReference) {
        if (this.isLeaf(nodeReference)) {
            return this.getMutableLeafBoxFromLeafNode(nodeReference);
        }
        if (this.isBoundingBoxCacheEnabled()) {
            return this.constructBoxInPlace(this.constructBoxInPlace(this.getLeftChild(nodeReference)), this.getRightChild(nodeReference));
        }
        AbstractBoundingBox<Point> oldBox = this.boxCache.getBox(nodeReference);
        if (oldBox != null) {
            return oldBox.copy();
        }
        AbstractBoundingBox<Point> currentBox = this.constructBoxInPlace(this.constructBoxInPlace(this.getLeftChild(nodeReference)), this.getRightChild(nodeReference));
        this.boxCache.setBox(nodeReference, (AbstractBoundingBox<Point>)currentBox.copy());
        return currentBox;
    }

    AbstractBoundingBox<Point> constructBoxInPlace(AbstractBoundingBox<Point> currentBox, Integer nodeReference) {
        if (this.isLeaf(nodeReference)) {
            return currentBox.addPoint(this.getPointFromLeafNode(nodeReference));
        }
        if (this.isBoundingBoxCacheEnabled()) {
            AbstractBoundingBox<Point> oldBox = this.boxCache.getBox(nodeReference);
            if (oldBox != null) {
                return currentBox.addBox(oldBox);
            }
            AbstractBoundingBox<Point> newBox = this.constructBoxInPlace(nodeReference);
            this.boxCache.setBox(nodeReference, newBox);
            return currentBox.addBox(newBox);
        }
        return this.constructBoxInPlace(this.constructBoxInPlace(currentBox, this.getLeftChild(nodeReference)), this.getRightChild(nodeReference));
    }

    @Override
    AbstractBoundingBox<Point> recomputeBox(Integer node) {
        if (this.boxCache.getBox(node) != null) {
            AbstractBoundingBox<Point> newBox = this.constructBoxInPlace(this.constructBoxInPlace(this.getLeftChild(node)), this.getRightChild(node));
            this.boxCache.setBox(node, newBox);
            return newBox;
        }
        return null;
    }

    @Override
    void setCachedBox(Integer mergedNode, AbstractBoundingBox<Point> savedBox) {
        this.boxCache.setBox(mergedNode, savedBox);
    }

    @Override
    void addToBox(Integer node, Point point) {
        this.boxCache.addToBox(node, point);
    }

    @Override
    Point getPointFromPointReference(Integer pointIndex) {
        CommonUtils.checkArgument(pointIndex != null, "incorrect request");
        return pointIndex == -1 ? null : (Point)this.pointStore.get(pointIndex);
    }

    @Override
    Integer getPointReference(Integer node) {
        int val = this.getPointReference(AbstractCompactRandomCutTree.intValue(node));
        return val == -1 ? null : Integer.valueOf(val);
    }

    @Override
    int getPointReference(int index) {
        CommonUtils.checkArgument(this.isLeaf(index), "index is not a valid leaf node index");
        return this.nodeStore.getPointIndex(index);
    }

    @Override
    void setLeafPointReference(Integer leafNode, Integer pointIndex) {
        this.nodeStore.setPointIndex(leafNode, pointIndex);
    }

    @Override
    protected boolean isLeaf(Integer node) {
        return this.nodeStore.isLeaf(AbstractCompactRandomCutTree.intValue(node));
    }

    @Override
    protected int decrementMass(Integer node) {
        return this.nodeStore.decrementMass(AbstractCompactRandomCutTree.intValue(node));
    }

    @Override
    protected int incrementMass(Integer node) {
        return this.nodeStore.incrementMass(AbstractCompactRandomCutTree.intValue(node));
    }

    @Override
    protected Integer getSibling(Integer node) {
        return this.getSibling(AbstractCompactRandomCutTree.intValue(node));
    }

    @Override
    protected int getSibling(int node) {
        int parent = this.getParent(node);
        CommonUtils.checkArgument(parent != -1, "node does not have a parent or a sibling");
        return this.nodeStore.getSibling(parent, node);
    }

    @Override
    protected Integer getParent(Integer node) {
        int parent = this.getParent(AbstractCompactRandomCutTree.intValue(node));
        return parent != -1 ? Integer.valueOf(parent) : null;
    }

    @Override
    protected int getParent(int node) {
        return this.nodeStore.getParentIndex(node);
    }

    @Override
    protected void setParent(Integer child, Integer parent) {
        this.nodeStore.setParentIndex(AbstractCompactRandomCutTree.intValue(child), AbstractCompactRandomCutTree.intValue(parent));
    }

    @Override
    protected void delete(Integer node) {
        this.nodeStore.delete(AbstractCompactRandomCutTree.intValue(node));
    }

    @Override
    protected int getCutDimension(Integer node) {
        return this.nodeStore.getCutDimension(node);
    }

    @Override
    protected double getCutValue(Integer node) {
        return this.nodeStore.getCutValue(node);
    }

    @Override
    protected Integer getLeftChild(Integer node) {
        return this.nodeStore.getLeftIndex(node);
    }

    @Override
    protected Integer getRightChild(Integer node) {
        return this.nodeStore.getRightIndex(node);
    }

    @Override
    void replaceChild(Integer parent, Integer child, Integer otherNode) {
        this.replaceChild(AbstractCompactRandomCutTree.intValue(parent), AbstractCompactRandomCutTree.intValue(child), AbstractCompactRandomCutTree.intValue(otherNode));
    }

    @Override
    protected void replaceChild(int parent, int child, int otherNode) {
        this.nodeStore.replaceChild(parent, child, otherNode);
        this.setParent(otherNode, parent);
    }

    @Override
    protected void replaceNodeBySibling(Integer grandParent, Integer parent, Integer node) {
        this.replaceNodeBySibling(AbstractCompactRandomCutTree.intValue(grandParent), AbstractCompactRandomCutTree.intValue(parent), AbstractCompactRandomCutTree.intValue(node));
    }

    @Override
    protected void replaceNodeBySibling(int grandParent, int parent, int node) {
        int sibling = this.nodeStore.getSibling(parent, node);
        this.nodeStore.replaceChild(grandParent, parent, sibling);
        this.setParent(sibling, grandParent);
    }

    @Override
    protected Integer addLeaf(Integer pointIndex) {
        return this.nodeStore.addLeaf(-1, pointIndex, 1);
    }

    @Override
    protected Integer addNode(Integer leftChild, Integer rightChild, int cutDimension, double cutValue, int mass) {
        return this.addNode(AbstractCompactRandomCutTree.intValue(leftChild), AbstractCompactRandomCutTree.intValue(rightChild), cutDimension, cutValue, mass);
    }

    @Override
    protected int addNode(int leftChild, int rightChild, int cutDimension, double cutValue, int mass) {
        return this.nodeStore.addNode(-1, leftChild, rightChild, cutDimension, cutValue, mass);
    }

    @Override
    protected void increaseMassOfAncestors(Integer mergedNode) {
        this.nodeStore.increaseMassOfSelfAndAncestors(this.getParent((int)mergedNode));
    }

    @Override
    protected void decreaseMassOfAncestors(Integer mergedNode) {
        this.nodeStore.decreaseMassOfSelfAndAncestors(this.getParent((int)mergedNode));
    }

    @Override
    protected int getMass(Integer node) {
        return this.nodeStore.getMass(AbstractCompactRandomCutTree.intValue(node));
    }

    protected static int intValue(Integer i) {
        return i == null ? -1 : i;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public Point getPointSum() {
        return (Integer)this.root == -1 ? null : (Point)this.getPointSum((Integer)this.root);
    }

    public int getRootIndex() {
        return AbstractCompactRandomCutTree.intValue((Integer)this.root);
    }

    @Override
    protected boolean referenceEquals(Integer oldPointRef, Integer pointRef) {
        return oldPointRef.equals(pointRef);
    }

    public Point getPointSum(int ref) {
        if (this.isLeaf(ref)) {
            return this.pointStore.getScaledPoint(this.getPointReference(ref), this.getMass(ref));
        }
        if (this.pointSum[ref] == null) {
            this.recomputePointSum(ref);
        }
        return this.pointSum[ref];
    }

    public boolean isBoundingBoxCacheEnabled() {
        return this.boundingBoxCacheFraction > 0.0;
    }

    @Override
    public void setBoundingBoxCacheFraction(double fraction) {
        this.boxCache.setCacheFraction(fraction);
        super.setBoundingBoxCacheFraction(fraction);
    }

    public static class Builder<T extends Builder<T>>
    extends AbstractRandomCutTree.Builder<T> {
        private INodeStore nodeStore = null;
        private int root = -1;
        private int maxSize = 256;
        protected Precision precision = RandomCutForest.DEFAULT_PRECISION;

        public T nodeStore(INodeStore nodeStore) {
            this.nodeStore = nodeStore;
            return (T)this;
        }

        public T root(int root) {
            this.root = root;
            return (T)this;
        }

        public T maxSize(int maxSize) {
            this.maxSize = maxSize;
            return (T)this;
        }
    }
}

