/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.tree.IBoundingBoxView;

public abstract class AbstractBoundingBox<Point>
implements IBoundingBoxView {
    protected final Point minValues;
    protected final Point maxValues;
    protected double rangeSum;

    public AbstractBoundingBox(Point point) {
        this.maxValues = point;
        this.minValues = this.maxValues;
        this.rangeSum = 0.0;
    }

    protected AbstractBoundingBox(Point minValues, Point maxValues, double sum) {
        this.minValues = minValues;
        this.maxValues = maxValues;
        this.rangeSum = sum;
    }

    @Override
    public abstract AbstractBoundingBox<Point> copy();

    @Override
    public abstract IBoundingBoxView getMergedBox(IBoundingBoxView var1);

    public abstract AbstractBoundingBox<Point> addPoint(Point var1);

    public abstract AbstractBoundingBox<Point> addBox(AbstractBoundingBox<Point> var1);

    @Override
    public abstract int getDimensions();

    @Override
    public double getRangeSum() {
        return this.rangeSum;
    }

    @Override
    public abstract double getMaxValue(int var1);

    @Override
    public abstract double getMinValue(int var1);

    public abstract boolean contains(Point var1);

    public boolean contains(AbstractBoundingBox<?> other) {
        CommonUtils.checkArgument(this.getDimensions() == other.getDimensions(), "incorrect dimensions");
        for (int i = 0; i < this.getDimensions(); ++i) {
            if (this.contains(i, other.getMinValue(i)) && this.contains(i, other.getMaxValue(i))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(int dimension, double value) {
        return this.getMaxValue(dimension) >= value && value >= this.getMinValue(dimension);
    }

    @Override
    public abstract double getRange(int var1);

    public abstract String toString();
}

