/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.store;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.store.INodeStore;
import com.amazon.randomcutforest.store.IndexManager;
import com.amazon.randomcutforest.store.PointStore;
import java.util.Arrays;

public class SmallNodeStore
implements INodeStore {
    public static int MAX_SMALLNODESTORE_CAPACITY = 16383;
    private final int capacity;
    private final short[] parentIndex;
    private final short[] leftIndex;
    private final short[] rightIndex;
    private final short[] cutDimension;
    private final float[] cutValue;
    private final short[] mass;
    private final int[] leafPointIndex;
    protected IndexManager freeNodeManager;
    protected IndexManager freeLeafManager;

    public SmallNodeStore(int capacity) {
        this.capacity = capacity;
        this.freeNodeManager = new IndexManager(capacity);
        this.freeLeafManager = new IndexManager(capacity + 1);
        this.parentIndex = new short[2 * capacity + 1];
        this.mass = new short[2 * capacity + 1];
        this.leftIndex = new short[capacity];
        this.rightIndex = new short[capacity];
        this.cutDimension = new short[capacity];
        this.cutValue = new float[capacity];
        this.leafPointIndex = new int[capacity + 1];
        Arrays.fill(this.parentIndex, (short)-1);
        Arrays.fill(this.leftIndex, (short)-1);
        Arrays.fill(this.rightIndex, (short)-1);
        Arrays.fill(this.leafPointIndex, PointStore.INFEASIBLE_POINTSTORE_INDEX);
    }

    public SmallNodeStore(int capacity, int[] leftIndex, int[] rightIndex, short[] cutDimension, float[] cutValue, int[] leafMass, int[] leafPointIndex, int[] freeNodeIndexes, int freeNodeIndexPointer, int[] freeLeafIndexes, int freeLeafIndexPointer) {
        this.capacity = capacity;
        this.freeNodeManager = new IndexManager(capacity, freeNodeIndexes, freeNodeIndexPointer);
        this.freeLeafManager = new IndexManager(capacity + 1, freeLeafIndexes, freeLeafIndexPointer);
        this.leftIndex = this.convertToShort(leftIndex);
        this.rightIndex = this.convertToShort(rightIndex);
        this.parentIndex = this.deriveParentIndex(this.leftIndex, this.rightIndex);
        this.cutDimension = cutDimension;
        this.cutValue = cutValue;
        if (leafMass != null) {
            CommonUtils.validateInternalState(leafPointIndex != null, " incorrect state for needing samplers");
            this.mass = this.convertToShort(leafMass);
            this.leafPointIndex = leafPointIndex;
        } else {
            this.mass = new short[2 * capacity + 1];
            this.leafPointIndex = new int[capacity + 1];
            Arrays.fill(this.leafPointIndex, PointStore.INFEASIBLE_POINTSTORE_INDEX);
        }
        if (leafMass != null) {
            for (int i = 0; i < capacity; ++i) {
                if (this.parentIndex[i] != -1) continue;
                this.rebuildMass(i);
            }
        }
    }

    void rebuildMass(int node) {
        if (!this.isLeaf(node) && this.leftIndex[node] != -1 && this.rightIndex[node] != -1) {
            this.rebuildMass(this.leftIndex[node]);
            this.rebuildMass(this.rightIndex[node]);
            this.mass[node] = (short)(this.mass[this.leftIndex[node]] + this.mass[this.rightIndex[node]]);
        }
    }

    @Override
    public int addNode(int parentIndex, int leftIndex, int rightIndex, int cutDimension, double cutValue, int mass) {
        int index = this.freeNodeManager.takeIndex();
        this.cutValue[index] = (float)cutValue;
        this.cutDimension[index] = (short)cutDimension;
        this.leftIndex[index] = (short)leftIndex;
        this.rightIndex[index] = (short)rightIndex;
        this.parentIndex[index] = (short)parentIndex;
        this.mass[index] = (short)mass;
        return index;
    }

    @Override
    public int addLeaf(int parentIndex, int pointIndex, int mass) {
        int index = this.freeLeafManager.takeIndex();
        this.parentIndex[index + this.capacity] = (short)parentIndex;
        this.mass[index + this.capacity] = (short)mass;
        this.leafPointIndex[index] = pointIndex;
        return index + this.capacity;
    }

    @Override
    public void setParentIndex(int index, int parent) {
        this.parentIndex[index] = (short)parent;
    }

    @Override
    public int getParentIndex(int index) {
        return this.parentIndex[index];
    }

    @Override
    public void delete(int index) {
        if (this.isLeaf(index)) {
            this.parentIndex[index] = -1;
            this.leafPointIndex[this.computeLeafIndex((int)index)] = PointStore.INFEASIBLE_POINTSTORE_INDEX;
            this.mass[index] = 0;
            this.freeLeafManager.releaseIndex(this.computeLeafIndex(index));
        } else {
            this.mass[index] = 0;
            this.leftIndex[index] = -1;
            this.rightIndex[index] = -1;
            this.parentIndex[index] = -1;
            this.freeNodeManager.releaseIndex(index);
        }
    }

    @Override
    public void replaceChild(int parent, int oldIndex, int newIndex) {
        if (this.leftIndex[parent] == oldIndex) {
            this.leftIndex[parent] = (short)newIndex;
        } else {
            this.rightIndex[parent] = (short)newIndex;
        }
    }

    @Override
    public int getRightIndex(int index) {
        return this.rightIndex[index];
    }

    public int[] getRightIndex() {
        return this.convertToInt(this.rightIndex);
    }

    @Override
    public void setRightIndex(int index, int child) {
        this.rightIndex[index] = (short)child;
    }

    @Override
    public int getLeftIndex(int index) {
        return this.leftIndex[index];
    }

    public int[] getLeftIndex() {
        return this.convertToInt(this.leftIndex);
    }

    @Override
    public void setLeftIndex(int index, int child) {
        this.leftIndex[index] = (short)child;
    }

    @Override
    public int incrementMass(int index) {
        int n = index;
        short s = (short)(this.mass[n] + 1);
        this.mass[n] = s;
        return s;
    }

    @Override
    public int decrementMass(int index) {
        int n = index;
        short s = (short)(this.mass[n] - 1);
        this.mass[n] = s;
        return s;
    }

    @Override
    public int getCutDimension(int index) {
        return this.cutDimension[index];
    }

    public int[] getCutDimension() {
        return this.convertToInt(this.cutDimension);
    }

    @Override
    public double getCutValue(int index) {
        return this.cutValue[index];
    }

    public double[] getCutValue() {
        return CommonUtils.toDoubleArray(this.cutValue);
    }

    @Override
    public int getMass(int index) {
        return this.mass[index];
    }

    @Override
    public void setMass(int index, int newMass) {
        this.mass[index] = (short)newMass;
    }

    @Override
    public void increaseMassOfSelfAndAncestors(int index) {
        while (index != -1) {
            int n = index;
            this.mass[n] = (short)(this.mass[n] + 1);
            index = this.parentIndex[index];
        }
    }

    @Override
    public void decreaseMassOfSelfAndAncestors(int index) {
        while (index != -1) {
            int n = index;
            this.mass[n] = (short)(this.mass[n] - 1);
            index = this.parentIndex[index];
        }
    }

    @Override
    public int getSibling(int parent, int node) {
        return this.leftIndex[parent] == node ? this.rightIndex[parent] : this.leftIndex[parent];
    }

    short[] deriveParentIndex(short[] leftIndex, short[] rightIndex) {
        int capacity = leftIndex.length;
        CommonUtils.checkState(rightIndex.length == capacity, "incorrect function call, arrays should be equal");
        short[] parentIndex = new short[2 * capacity + 1];
        Arrays.fill(parentIndex, (short)-1);
        for (int i = 0; i < capacity; i = (int)((short)(i + 1))) {
            if (leftIndex[i] != -1) {
                CommonUtils.checkState(parentIndex[leftIndex[i]] == -1, "incorrect state, conflicting parent");
                parentIndex[leftIndex[i]] = i;
            }
            if (rightIndex[i] == -1) continue;
            CommonUtils.checkState(parentIndex[rightIndex[i]] == -1, "incorrect state, conflicting parent");
            parentIndex[rightIndex[i]] = i;
        }
        return parentIndex;
    }

    @Override
    public boolean isLeaf(int index) {
        CommonUtils.checkArgument(index >= 0, "index has to be non-negative");
        return this.computeLeafIndex(index) >= 0;
    }

    @Override
    public int computeLeafIndex(int index) {
        return index - this.capacity;
    }

    @Override
    public int getPointIndex(int index) {
        return this.leafPointIndex[this.computeLeafIndex(index)];
    }

    @Override
    public int setPointIndex(int index, int pointIndex) {
        int newIndex = this.computeLeafIndex(index);
        int savedPointIndex = this.leafPointIndex[newIndex];
        this.leafPointIndex[newIndex] = pointIndex;
        return savedPointIndex;
    }

    public int[] getLeafFreeIndexes() {
        return this.freeLeafManager.getFreeIndexes();
    }

    public int[] getNodeFreeIndexes() {
        return this.freeNodeManager.getFreeIndexes();
    }

    public int[] getLeafPointIndex() {
        return this.leafPointIndex;
    }

    public int[] getLeafMass() {
        return this.convertToInt(this.mass);
    }

    public int getLeafFreeIndexPointer() {
        return this.freeLeafManager.getFreeIndexPointer();
    }

    public int getNodeFreeIndexPointer() {
        return this.freeNodeManager.getFreeIndexPointer();
    }

    @Override
    public int getCapacity() {
        return this.freeNodeManager.getCapacity();
    }

    @Override
    public int size() {
        return this.freeNodeManager.size();
    }

    @Override
    public boolean isCanonicalAndNotALeaf() {
        boolean check = this.leftIndex.length == this.rightIndex.length;
        int leafCounter = this.leftIndex.length;
        int nodeCounter = 1;
        check = check && this.parentIndex[0] == -1 && this.freeNodeManager.occupied.get(0);
        for (int i = 0; i < this.size() && check; ++i) {
            if (this.leftIndex[i] != -1) {
                if (this.leftIndex[i] < this.leftIndex.length) {
                    check = nodeCounter == this.leftIndex[i];
                    ++nodeCounter;
                } else {
                    check = this.leftIndex[i] == leafCounter;
                    ++leafCounter;
                }
                boolean bl = check = check && this.rightIndex[i] != -1;
                if (this.rightIndex[i] < this.rightIndex.length) {
                    check = check && nodeCounter == this.rightIndex[i];
                    ++nodeCounter;
                    continue;
                }
                check = check && this.rightIndex[i] == leafCounter;
                ++leafCounter;
                continue;
            }
            check = check && this.rightIndex[i] == -1;
        }
        return check;
    }

    short[] convertToShort(int[] original) {
        short[] newArray = new short[original.length];
        for (int i = 0; i < original.length; ++i) {
            newArray[i] = (short)original[i];
        }
        return newArray;
    }

    int[] convertToInt(short[] original) {
        int[] newArray = new int[original.length];
        for (int i = 0; i < original.length; ++i) {
            newArray[i] = original[i];
        }
        return newArray;
    }
}

