/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.store;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.store.PointStore;
import java.util.Arrays;

public class PointStoreFloat
extends PointStore<float[], float[]> {
    public PointStoreFloat(Builder builder) {
        super(builder);
        CommonUtils.checkArgument(builder.store == null || builder.store.length == this.currentStoreCapacity * this.dimensions, " incorrect store length");
        this.store = builder.store == null ? new float[this.currentStoreCapacity * this.dimensions] : builder.store;
    }

    public PointStoreFloat(int dimensions, int capacity) {
        this((Builder)((Builder)((Builder)((Builder)new Builder().dimensions(dimensions)).shingleSize(1)).capacity(capacity)).initialSize(capacity));
    }

    @Override
    void resizeStore() {
        int maxCapacity = this.rotationEnabled ? 2 * this.capacity : this.capacity;
        int newCapacity = Math.min(2 * this.currentStoreCapacity, maxCapacity);
        if (newCapacity > this.currentStoreCapacity) {
            float[] newStore = new float[newCapacity * this.dimensions];
            System.arraycopy(this.store, 0, newStore, 0, this.currentStoreCapacity * this.dimensions);
            this.currentStoreCapacity = newCapacity;
            this.store = newStore;
        }
    }

    @Override
    boolean checkShingleAlignment(int location, double[] point) {
        boolean test = location - this.dimensions + this.baseDimension >= 0;
        for (int i = 0; i < this.dimensions - this.baseDimension && test; ++i) {
            test = (float)point[i] == ((float[])this.store)[location - this.dimensions + this.baseDimension + i];
        }
        return test;
    }

    @Override
    void copyPoint(double[] point, int src, int location, int length) {
        for (int i = 0; i < length; ++i) {
            ((float[])this.store)[location + i] = (float)point[src + i];
        }
    }

    @Override
    public boolean pointEquals(int index, float[] point) {
        int address;
        this.indexManager.checkValidIndex(index);
        CommonUtils.checkArgument(point.length == this.dimensions, "point.length must be equal to dimensions");
        int n = address = this.directLocationMap ? index * this.dimensions : this.locationList[index];
        if (!this.rotationEnabled) {
            for (int j = 0; j < this.dimensions; ++j) {
                if (point[j] == ((float[])this.store)[j + address]) continue;
                return false;
            }
        } else {
            for (int j = 0; j < this.dimensions; ++j) {
                if (point[(j + address) % this.dimensions] == ((float[])this.store)[j + address]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public float[] get(int index) {
        this.indexManager.checkValidIndex(index);
        int address = this.locationList[index];
        if (!this.rotationEnabled) {
            return Arrays.copyOfRange((float[])this.store, address, address + this.dimensions);
        }
        float[] answer = new float[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            answer[(address + i) % this.dimensions] = ((float[])this.store)[address + i];
        }
        return answer;
    }

    @Override
    public float[] getScaledPoint(int index, double factor) {
        float[] answer = this.get(index);
        int i = 0;
        while (i < this.dimensions) {
            int n = i++;
            answer[n] = (float)((double)answer[n] * factor);
        }
        return answer;
    }

    @Override
    public String toString(int index) {
        return Arrays.toString(this.get(index));
    }

    @Override
    void copyTo(int dest, int source, int length) {
        for (int i = 0; i < length; ++i) {
            ((float[])this.store)[dest + i] = ((float[])this.store)[source + i];
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends PointStore.Builder<Builder> {
        private float[] store = null;

        public Builder store(float[] store) {
            this.store = store;
            return this;
        }

        public PointStoreFloat build() {
            return new PointStoreFloat(this);
        }
    }
}

