/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.store;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.store.PointStore;
import java.util.Arrays;

public class PointStoreDouble
extends PointStore<double[], double[]> {
    public PointStoreDouble(Builder builder) {
        super(builder);
        CommonUtils.checkArgument(builder.store == null || builder.store.length == this.currentStoreCapacity * this.dimensions, " incorrect store length");
        this.store = builder.store == null ? new double[this.currentStoreCapacity * this.dimensions] : builder.store;
    }

    public PointStoreDouble(int dimensions, int capacity) {
        this((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().dimensions(dimensions)).shingleSize(1)).capacity(capacity)).indexCapacity(capacity)).currentStoreCapacity(capacity));
    }

    @Override
    void resizeStore() {
        int maxCapacity = this.rotationEnabled ? 2 * this.capacity : this.capacity;
        int newCapacity = Math.min(2 * this.currentStoreCapacity, maxCapacity);
        if (newCapacity > this.currentStoreCapacity) {
            double[] newStore = new double[newCapacity * this.dimensions];
            System.arraycopy(this.store, 0, newStore, 0, this.currentStoreCapacity * this.dimensions);
            this.currentStoreCapacity = newCapacity;
            this.store = newStore;
        }
    }

    @Override
    boolean checkShingleAlignment(int location, double[] point) {
        boolean test = location - this.dimensions + this.baseDimension >= 0;
        for (int i = 0; i < this.dimensions - this.baseDimension && test; ++i) {
            test = point[i] == ((double[])this.store)[location - this.dimensions + this.baseDimension + i];
        }
        return test;
    }

    @Override
    void copyPoint(double[] point, int src, int location, int length) {
        System.arraycopy(point, src, this.store, location, length);
    }

    @Override
    public boolean pointEquals(int index, double[] point) {
        this.indexManager.checkValidIndex(index);
        CommonUtils.checkArgument(point.length == this.dimensions, "point.length must be equal to dimensions");
        int address = this.locationList[index];
        if (!this.rotationEnabled) {
            for (int j = 0; j < this.dimensions; ++j) {
                if (point[j] == ((double[])this.store)[j + address]) continue;
                return false;
            }
        } else {
            for (int j = 0; j < this.dimensions; ++j) {
                if (point[(j + address) % this.dimensions] == ((double[])this.store)[j + address]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public double[] get(int index) {
        this.indexManager.checkValidIndex(index);
        int address = this.locationList[index];
        if (!this.rotationEnabled) {
            return Arrays.copyOfRange((double[])this.store, address, address + this.dimensions);
        }
        double[] answer = new double[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            answer[(address + i) % this.dimensions] = ((double[])this.store)[address + i];
        }
        return answer;
    }

    @Override
    public double[] getScaledPoint(int index, double factor) {
        double[] answer = this.get(index);
        int i = 0;
        while (i < this.dimensions) {
            int n = i++;
            answer[n] = answer[n] * factor;
        }
        return answer;
    }

    @Override
    public String toString(int index) {
        return Arrays.toString(this.get(index));
    }

    @Override
    void copyTo(int dest, int source, int length) {
        if (dest < source) {
            for (int i = 0; i < length; ++i) {
                ((double[])this.store)[dest + i] = ((double[])this.store)[source + i];
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends PointStore.Builder<Builder> {
        private double[] store = null;

        public Builder store(double[] store) {
            this.store = store;
            return this;
        }

        public PointStoreDouble build() {
            return new PointStoreDouble(this);
        }
    }
}

