/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.store;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.store.IPointStore;
import com.amazon.randomcutforest.store.IndexManager;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Optional;

public abstract class PointStore<Store, Point>
implements IPointStore<Point> {
    public static int INFEASIBLE_POINTSTORE_LOCATION = -2;
    public static int INFEASIBLE_POINTSTORE_INDEX = -1;
    protected IndexManager indexManager;
    protected Store store;
    protected double[] internalShingle;
    protected long nextSequenceIndex;
    protected int[] locationList;
    protected int[] refCount;
    int startOfFreeSegment;
    int dimensions;
    int shingleSize;
    int baseDimension;
    boolean directLocationMap;
    int capacity;
    int currentStoreCapacity;
    boolean dynamicResizingEnabled;
    boolean internalShinglingEnabled;
    boolean rotationEnabled;

    @Override
    public int decrementRefCount(int index) {
        this.indexManager.checkValidIndex(index);
        if (this.refCount[index] == 1) {
            this.indexManager.releaseIndex(index);
            if (!this.directLocationMap) {
                this.locationList[index] = INFEASIBLE_POINTSTORE_LOCATION;
            }
        }
        int n = index;
        int n2 = this.refCount[n] - 1;
        this.refCount[n] = n2;
        return n2;
    }

    abstract boolean checkShingleAlignment(int var1, double[] var2);

    abstract void copyPoint(double[] var1, int var2, int var3, int var4);

    int takeIndex() {
        if (this.indexManager.isFull()) {
            if (this.indexManager.getCapacity() < this.capacity) {
                int oldCapacity = this.indexManager.getCapacity();
                int newCapacity = Math.min(this.capacity, 2 * oldCapacity);
                this.indexManager = new IndexManager(this.indexManager, newCapacity);
                this.refCount = Arrays.copyOf(this.refCount, newCapacity);
                this.locationList = Arrays.copyOf(this.locationList, newCapacity);
                for (int i = oldCapacity; i < newCapacity; ++i) {
                    this.locationList[i] = INFEASIBLE_POINTSTORE_LOCATION;
                }
            } else {
                throw new IllegalStateException(" index manager in point store is full ");
            }
        }
        int location = this.indexManager.takeIndex();
        return location;
    }

    @Override
    public int add(double[] point, long sequenceNum) {
        int nextIndex;
        CommonUtils.checkArgument(this.internalShinglingEnabled || point.length == this.dimensions, "point.length must be equal to dimensions");
        CommonUtils.checkArgument(!this.internalShinglingEnabled || point.length == this.baseDimension, "point.length must be equal to dimensions");
        double[] tempPoint = point;
        ++this.nextSequenceIndex;
        if (this.internalShinglingEnabled) {
            tempPoint = this.constructShingleInPlace(this.internalShingle, point, false);
            if (this.nextSequenceIndex < (long)this.shingleSize) {
                return INFEASIBLE_POINTSTORE_INDEX;
            }
        }
        if (!this.directLocationMap) {
            int amountToWrite;
            int n = amountToWrite = this.checkShingleAlignment(this.startOfFreeSegment, tempPoint) ? this.baseDimension : this.dimensions;
            if (this.startOfFreeSegment > this.currentStoreCapacity * this.dimensions - amountToWrite) {
                this.compact();
                int n2 = amountToWrite = this.checkShingleAlignment(this.startOfFreeSegment, tempPoint) ? this.baseDimension : this.dimensions;
                if (this.startOfFreeSegment > this.currentStoreCapacity * this.dimensions - amountToWrite) {
                    CommonUtils.checkState(this.dynamicResizingEnabled, " out of store, enable dynamic resizing ");
                    this.resizeStore();
                    CommonUtils.checkState(this.startOfFreeSegment + amountToWrite <= this.currentStoreCapacity * this.dimensions, "out of space");
                }
            }
            nextIndex = this.takeIndex();
            this.locationList[nextIndex] = this.startOfFreeSegment - this.dimensions + amountToWrite;
            this.copyPoint(tempPoint, this.dimensions - amountToWrite, this.startOfFreeSegment, amountToWrite);
            this.startOfFreeSegment += amountToWrite;
        } else {
            nextIndex = this.takeIndex();
            int address = this.locationList[nextIndex];
            if (address == INFEASIBLE_POINTSTORE_LOCATION) {
                if (this.startOfFreeSegment + this.dimensions > this.currentStoreCapacity * this.dimensions) {
                    CommonUtils.checkState(this.dynamicResizingEnabled, " out of store, enable dynamic resizing ");
                    this.resizeStore();
                    if (this.startOfFreeSegment + this.dimensions > this.currentStoreCapacity * this.dimensions) {
                        this.indexManager.releaseIndex(nextIndex);
                        this.compact();
                        nextIndex = this.takeIndex();
                    }
                }
                this.locationList[nextIndex] = address = this.startOfFreeSegment;
                this.startOfFreeSegment = Math.max(this.startOfFreeSegment, address + this.dimensions);
            }
            this.copyPoint(tempPoint, 0, address, this.dimensions);
        }
        this.refCount[nextIndex] = 1;
        return nextIndex;
    }

    abstract void resizeStore();

    @Override
    public int incrementRefCount(int index) {
        this.indexManager.checkValidIndex(index);
        int n = index;
        int n2 = this.refCount[n] + 1;
        this.refCount[n] = n2;
        return n2;
    }

    @Override
    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public abstract boolean pointEquals(int var1, Point var2);

    @Override
    public abstract Point get(int var1);

    @Override
    public abstract String toString(int var1);

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public int getIndexCapacity() {
        return this.indexManager.getCapacity();
    }

    @Override
    public int getShingleSize() {
        return this.shingleSize;
    }

    public int getCurrentStoreCapacity() {
        return this.currentStoreCapacity;
    }

    public Store getStore() {
        return this.store;
    }

    public int[] getRefCount() {
        return this.refCount;
    }

    public int getStartOfFreeSegment() {
        return this.startOfFreeSegment;
    }

    public int[] getLocationList() {
        return this.locationList;
    }

    @Override
    public boolean isInternalShinglingEnabled() {
        return this.internalShinglingEnabled;
    }

    @Override
    public boolean isInternalRotationEnabled() {
        return this.rotationEnabled;
    }

    @Override
    public long getNextSequenceIndex() {
        return this.nextSequenceIndex;
    }

    public boolean isDynamicResizingEnabled() {
        return this.dynamicResizingEnabled;
    }

    public boolean isDirectLocationMap() {
        return this.directLocationMap;
    }

    @Override
    public double[] getInternalShingle() {
        CommonUtils.checkState(this.internalShinglingEnabled, "internal shingling is not enabled");
        return this.copyShingle();
    }

    public int size() {
        return this.indexManager.capacity - this.indexManager.freeIndexPointer - 1;
    }

    public int getValidPrefix() {
        return this.indexManager.occupied.previousSetBit(this.capacity) + 1;
    }

    abstract void copyTo(int var1, int var2, int var3);

    BitSet inUse() {
        BitSet result = new BitSet(this.currentStoreCapacity * this.dimensions / this.baseDimension);
        for (int i = 0; i < this.indexManager.capacity; ++i) {
            if (this.indexManager.occupied.get(i)) {
                result.set(this.locationList[i] / this.baseDimension);
                continue;
            }
            this.locationList[i] = INFEASIBLE_POINTSTORE_LOCATION;
        }
        return result;
    }

    public void compact() {
        int runningLocation = 0;
        this.startOfFreeSegment = 0;
        HashMap<Integer, Integer> movedTo = new HashMap<Integer, Integer>();
        BitSet inUse = this.inUse();
        while (runningLocation < this.currentStoreCapacity * this.dimensions) {
            if ((runningLocation = inUse.nextSetBit(runningLocation / this.baseDimension) * this.baseDimension) < 0) {
                runningLocation = this.currentStoreCapacity * this.dimensions;
            }
            if (this.rotationEnabled && runningLocation % this.dimensions != 0) {
                while (runningLocation % this.dimensions != 0) {
                    --runningLocation;
                }
            }
            if (runningLocation >= this.currentStoreCapacity * this.dimensions) continue;
            int saveLocation = runningLocation;
            int shadowLocation = this.startOfFreeSegment;
            for (int remainsToBeCopied = this.dimensions; runningLocation < this.currentStoreCapacity * this.dimensions && (remainsToBeCopied > 0 || this.rotationEnabled && runningLocation % this.dimensions != 0); --remainsToBeCopied) {
                if ((this.baseDimension == 1 || runningLocation % this.baseDimension == 0) && inUse.get(runningLocation / this.baseDimension)) {
                    remainsToBeCopied = this.dimensions;
                    if (shadowLocation < runningLocation) {
                        movedTo.put(runningLocation, shadowLocation);
                    }
                }
                ++runningLocation;
                ++shadowLocation;
            }
            this.copyTo(this.startOfFreeSegment, saveLocation, runningLocation - saveLocation);
            this.startOfFreeSegment += runningLocation - saveLocation;
        }
        if (!movedTo.isEmpty()) {
            for (int i = 0; i < this.indexManager.capacity; ++i) {
                if (!movedTo.containsKey(this.locationList[i])) continue;
                this.locationList[i] = (Integer)movedTo.get(this.locationList[i]);
            }
        }
    }

    public int getRefCount(int i) {
        return this.refCount[i];
    }

    @Override
    public double[] transformToShingledPoint(double[] point) {
        CommonUtils.checkArgument(this.internalShinglingEnabled, " only allowed for internal shingling");
        CommonUtils.checkArgument(point.length == this.baseDimension, " incorrect length");
        return this.constructShingleInPlace(this.copyShingle(), point, this.rotationEnabled);
    }

    private double[] copyShingle() {
        if (!this.rotationEnabled) {
            return Arrays.copyOf(this.internalShingle, this.dimensions);
        }
        double[] answer = new double[this.dimensions];
        int offset = (int)(this.nextSequenceIndex * (long)this.baseDimension);
        for (int i = 0; i < this.dimensions; ++i) {
            answer[(offset + i) % this.dimensions] = this.internalShingle[i];
        }
        return answer;
    }

    private double[] constructShingleInPlace(double[] target, double[] point, boolean rotationEnabled) {
        if (!rotationEnabled) {
            int i;
            for (i = 0; i < this.dimensions - this.baseDimension; ++i) {
                target[i] = target[i + this.baseDimension];
            }
            for (i = 0; i < this.baseDimension; ++i) {
                target[this.dimensions - this.baseDimension + i] = point[i] == 0.0 ? 0.0 : point[i];
            }
        } else {
            int offset = (int)(this.nextSequenceIndex * (long)this.baseDimension) % this.dimensions;
            for (int i = 0; i < this.baseDimension; ++i) {
                target[offset + i] = point[i] == 0.0 ? 0.0 : point[i];
            }
        }
        return target;
    }

    @Override
    public int[] transformIndices(int[] indexList) {
        CommonUtils.checkArgument(this.internalShinglingEnabled, " only allowed for internal shingling");
        CommonUtils.checkArgument(indexList.length <= this.baseDimension, " incorrect length");
        int[] results = Arrays.copyOf(indexList, indexList.length);
        if (!this.rotationEnabled) {
            int i = 0;
            while (i < indexList.length) {
                CommonUtils.checkArgument(results[i] < this.baseDimension, "incorrect index");
                int n = i++;
                results[n] = results[n] + (this.dimensions - this.baseDimension);
            }
        } else {
            int offset = (int)(this.nextSequenceIndex * (long)this.baseDimension) % this.dimensions;
            for (int i = 0; i < indexList.length; ++i) {
                CommonUtils.checkArgument(results[i] < this.baseDimension, "incorrect index");
                results[i] = (results[i] + offset) % this.dimensions;
            }
        }
        return results;
    }

    public PointStore(Builder builder) {
        CommonUtils.checkArgument(builder.dimensions > 0, "dimensions must be greater than 0");
        CommonUtils.checkArgument(builder.capacity > 0, "capacity must be greater than 0");
        CommonUtils.checkArgument(builder.shingleSize == 1 || builder.dimensions == builder.shingleSize || builder.dimensions % builder.shingleSize == 0, "incorrect use of shingle size");
        CommonUtils.checkArgument(!builder.internalRotationEnabled || builder.internalShinglingEnabled, "rotation can be enabled for internal shingling only");
        builder.initialPointStoreSize.ifPresent(n -> CommonUtils.checkState(this.dynamicResizingEnabled || builder.capacity >= (Integer)n, " incorrect initialization, enable dynamic resizing"));
        if (builder.refCount != null || builder.locationList != null || builder.knownShingle != null) {
            CommonUtils.checkArgument(builder.refCount != null, "reference count must be present");
            CommonUtils.checkArgument(builder.locationList != null, "location list must be present");
            CommonUtils.checkArgument(builder.refCount.length == builder.indexCapacity, "incorrect reference count length");
            CommonUtils.checkArgument(builder.locationList.length == builder.indexCapacity, " incorrect length of locations");
            CommonUtils.checkArgument(builder.knownShingle == null || builder.internalShinglingEnabled && builder.knownShingle.length == builder.dimensions, "incorrect shingling information");
        }
        this.shingleSize = builder.shingleSize;
        this.dimensions = builder.dimensions;
        this.directLocationMap = builder.directLocationEnabled;
        this.internalShinglingEnabled = builder.internalShinglingEnabled;
        this.rotationEnabled = builder.internalRotationEnabled;
        this.currentStoreCapacity = builder.currentStoreCapacity;
        this.dynamicResizingEnabled = builder.dynamicResizingEnabled;
        this.baseDimension = this.dimensions / this.shingleSize;
        this.capacity = builder.capacity;
        if (builder.refCount == null) {
            int size;
            this.currentStoreCapacity = size = builder.initialPointStoreSize.orElse(this.dynamicResizingEnabled ? 1 : builder.capacity).intValue();
            this.indexManager = new IndexManager(size);
            this.startOfFreeSegment = 0;
            this.refCount = new int[size];
            if (this.internalShinglingEnabled) {
                this.nextSequenceIndex = 0L;
                this.internalShingle = new double[this.dimensions];
            }
            this.locationList = new int[size];
            Arrays.fill(this.locationList, INFEASIBLE_POINTSTORE_LOCATION);
        } else {
            this.refCount = builder.refCount;
            this.locationList = builder.locationList;
            this.startOfFreeSegment = builder.startOfFreeSegment;
            this.nextSequenceIndex = builder.nextTimeStamp;
            if (this.internalShinglingEnabled) {
                this.internalShingle = Arrays.copyOf(builder.knownShingle, this.dimensions);
            }
            BitSet bits = new BitSet(builder.indexCapacity);
            for (int i = 0; i < builder.indexCapacity; ++i) {
                if (this.refCount[i] <= 0) continue;
                bits.set(i);
            }
            this.indexManager = new IndexManager(builder.indexCapacity, bits);
        }
    }

    public static class Builder<T extends Builder<T>> {
        private int dimensions;
        private int shingleSize = 1;
        private boolean internalShinglingEnabled = false;
        private boolean dynamicResizingEnabled = true;
        private boolean internalRotationEnabled = false;
        private boolean directLocationEnabled = false;
        private int capacity;
        private Optional<Integer> initialPointStoreSize = Optional.empty();
        private int currentStoreCapacity = 0;
        private int indexCapacity = 0;
        private double[] knownShingle = null;
        private int[] locationList = null;
        private int[] refCount = null;
        private long nextTimeStamp = 0L;
        private int startOfFreeSegment = 0;

        public T dimensions(int dimensions) {
            this.dimensions = dimensions;
            return (T)this;
        }

        public T capacity(int capacity) {
            this.capacity = capacity;
            return (T)this;
        }

        public T dynamicResizingEnabled(boolean dynamicResizingEnabled) {
            this.dynamicResizingEnabled = dynamicResizingEnabled;
            return (T)this;
        }

        public T initialSize(int initialPointStoreSize) {
            this.initialPointStoreSize = Optional.of(initialPointStoreSize);
            return (T)this;
        }

        public T shingleSize(int shingleSize) {
            this.shingleSize = shingleSize;
            return (T)this;
        }

        public T directLocationEnabled(boolean directLocationEnabled) {
            this.directLocationEnabled = directLocationEnabled;
            return (T)this;
        }

        public T internalShinglingEnabled(boolean internalShinglingEnabled) {
            this.internalShinglingEnabled = internalShinglingEnabled;
            return (T)this;
        }

        public T internalRotationEnabled(boolean internalRotationEnabled) {
            this.internalRotationEnabled = internalRotationEnabled;
            return (T)this;
        }

        public T currentStoreCapacity(int currentStoreCapacity) {
            this.currentStoreCapacity = currentStoreCapacity;
            return (T)this;
        }

        public T indexCapacity(int indexCapacity) {
            this.indexCapacity = indexCapacity;
            return (T)this;
        }

        public T knownShingle(double[] knownShingle) {
            this.knownShingle = knownShingle;
            return (T)this;
        }

        public T refCount(int[] refCount) {
            this.refCount = refCount;
            return (T)this;
        }

        public T locationList(int[] locationList) {
            this.locationList = locationList;
            return (T)this;
        }

        public T startOfFreeSegment(int startOfFreeSegment) {
            this.startOfFreeSegment = startOfFreeSegment;
            return (T)this;
        }

        public T nextTimeStamp(long nextTimeStamp) {
            this.nextTimeStamp = nextTimeStamp;
            return (T)this;
        }
    }
}

