/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.store;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.store.INodeStore;
import com.amazon.randomcutforest.store.IndexManager;
import com.amazon.randomcutforest.store.PointStore;
import java.util.Arrays;

public class NodeStore
implements INodeStore {
    private final int capacity;
    private final int[] parentIndex;
    private final int[] leftIndex;
    private final int[] rightIndex;
    private final int[] cutDimension;
    private final double[] cutValue;
    private final int[] mass;
    private final int[] leafPointIndex;
    protected IndexManager freeNodeManager;
    protected IndexManager freeLeafManager;

    public NodeStore(int capacity) {
        this.capacity = capacity;
        this.freeNodeManager = new IndexManager(capacity);
        this.freeLeafManager = new IndexManager(capacity + 1);
        this.parentIndex = new int[2 * capacity + 1];
        this.mass = new int[2 * capacity + 1];
        this.leftIndex = new int[capacity];
        this.rightIndex = new int[capacity];
        this.cutDimension = new int[capacity];
        this.cutValue = new double[capacity];
        this.leafPointIndex = new int[capacity + 1];
        Arrays.fill(this.parentIndex, -1);
        Arrays.fill(this.leftIndex, -1);
        Arrays.fill(this.rightIndex, -1);
        Arrays.fill(this.leafPointIndex, PointStore.INFEASIBLE_POINTSTORE_INDEX);
    }

    public NodeStore(int capacity, int[] leftIndex, int[] rightIndex, int[] cutDimension, double[] cutValue, int[] leafMass, int[] leafPointIndex, int[] freeNodeIndexes, int freeNodeIndexPointer, int[] freeLeafIndexes, int freeLeafIndexPointer) {
        this.capacity = capacity;
        this.freeNodeManager = new IndexManager(capacity, freeNodeIndexes, freeNodeIndexPointer);
        this.freeLeafManager = new IndexManager(capacity + 1, freeLeafIndexes, freeLeafIndexPointer);
        this.parentIndex = this.deriveParentIndex(leftIndex, rightIndex);
        this.leftIndex = leftIndex;
        this.rightIndex = rightIndex;
        this.cutDimension = cutDimension;
        this.cutValue = cutValue;
        this.mass = new int[2 * capacity + 1];
        if (leafMass != null) {
            CommonUtils.validateInternalState(leafPointIndex != null, " incorrect state for needing samplers");
            System.arraycopy(leafMass, 0, this.mass, capacity, capacity + 1);
            this.leafPointIndex = leafPointIndex;
        } else {
            this.leafPointIndex = new int[capacity + 1];
            Arrays.fill(this.leafPointIndex, PointStore.INFEASIBLE_POINTSTORE_INDEX);
        }
        if (leafMass != null) {
            for (int i = 0; i < capacity; ++i) {
                if (this.parentIndex[i] != -1) continue;
                this.rebuildMass(i);
            }
        }
    }

    void rebuildMass(int node) {
        if (!this.isLeaf(node) && this.leftIndex[node] != -1 && this.rightIndex[node] != -1) {
            this.rebuildMass(this.leftIndex[node]);
            this.rebuildMass(this.rightIndex[node]);
            this.mass[node] = this.mass[this.leftIndex[node]] + this.mass[this.rightIndex[node]];
        }
    }

    @Override
    public int addNode(int parentIndex, int leftIndex, int rightIndex, int cutDimension, double cutValue, int mass) {
        int index = this.freeNodeManager.takeIndex();
        this.cutValue[index] = cutValue;
        this.cutDimension[index] = cutDimension;
        this.leftIndex[index] = leftIndex;
        this.rightIndex[index] = rightIndex;
        this.parentIndex[index] = parentIndex;
        this.mass[index] = mass;
        return index;
    }

    @Override
    public int addLeaf(int parentIndex, int pointIndex, int mass) {
        int index = this.freeLeafManager.takeIndex();
        this.parentIndex[index + this.capacity] = parentIndex;
        this.mass[index + this.capacity] = mass;
        this.leafPointIndex[index] = pointIndex;
        return index + this.capacity;
    }

    @Override
    public void setParentIndex(int index, int parent) {
        this.parentIndex[index] = parent;
    }

    @Override
    public int getParentIndex(int index) {
        return this.parentIndex[index];
    }

    @Override
    public void delete(int index) {
        if (this.isLeaf(index)) {
            this.parentIndex[index] = -1;
            this.leafPointIndex[this.computeLeafIndex((int)index)] = PointStore.INFEASIBLE_POINTSTORE_INDEX;
            this.mass[index] = 0;
            this.freeLeafManager.releaseIndex(this.computeLeafIndex(index));
        } else {
            this.mass[index] = 0;
            this.leftIndex[index] = -1;
            this.rightIndex[index] = -1;
            this.parentIndex[index] = -1;
            this.freeNodeManager.releaseIndex(index);
        }
    }

    @Override
    public void replaceChild(int parent, int oldIndex, int newIndex) {
        if (this.leftIndex[parent] == oldIndex) {
            this.leftIndex[parent] = newIndex;
        } else {
            this.rightIndex[parent] = newIndex;
        }
    }

    @Override
    public int getRightIndex(int index) {
        return this.rightIndex[index];
    }

    public int[] getRightIndex() {
        return this.rightIndex;
    }

    @Override
    public void setRightIndex(int index, int child) {
        this.rightIndex[index] = child;
    }

    @Override
    public int getLeftIndex(int index) {
        return this.leftIndex[index];
    }

    public int[] getLeftIndex() {
        return this.leftIndex;
    }

    @Override
    public void setLeftIndex(int index, int child) {
        this.leftIndex[index] = child;
    }

    @Override
    public int incrementMass(int index) {
        int n = index;
        int n2 = this.mass[n] + 1;
        this.mass[n] = n2;
        return n2;
    }

    @Override
    public int decrementMass(int index) {
        int n = index;
        int n2 = this.mass[n] - 1;
        this.mass[n] = n2;
        return n2;
    }

    @Override
    public int getCutDimension(int index) {
        return this.cutDimension[index];
    }

    public int[] getCutDimension() {
        return this.cutDimension;
    }

    @Override
    public double getCutValue(int index) {
        return this.cutValue[index];
    }

    public double[] getCutValue() {
        return this.cutValue;
    }

    @Override
    public int getMass(int index) {
        return this.mass[index];
    }

    @Override
    public void setMass(int index, int newMass) {
        this.mass[index] = newMass;
    }

    @Override
    public void increaseMassOfSelfAndAncestors(int index) {
        while (index != -1) {
            int n = index;
            this.mass[n] = this.mass[n] + 1;
            index = this.parentIndex[index];
        }
    }

    @Override
    public void decreaseMassOfSelfAndAncestors(int index) {
        while (index != -1) {
            int n = index;
            this.mass[n] = this.mass[n] - 1;
            index = this.parentIndex[index];
        }
    }

    @Override
    public int getSibling(int parent, int node) {
        return this.leftIndex[parent] == node ? this.rightIndex[parent] : this.leftIndex[parent];
    }

    int[] deriveParentIndex(int[] leftIndex, int[] rightIndex) {
        int capacity = leftIndex.length;
        CommonUtils.checkState(rightIndex.length == capacity, "incorrect function call, arrays should be equal");
        int[] parentIndex = new int[2 * capacity + 1];
        Arrays.fill(parentIndex, -1);
        for (int i = 0; i < capacity; ++i) {
            if (leftIndex[i] != -1) {
                CommonUtils.checkState(parentIndex[leftIndex[i]] == -1, "incorrect state, conflicting parent");
                parentIndex[leftIndex[i]] = i;
            }
            if (rightIndex[i] == -1) continue;
            CommonUtils.checkState(parentIndex[rightIndex[i]] == -1, "incorrect state, conflicting parent");
            parentIndex[rightIndex[i]] = i;
        }
        return parentIndex;
    }

    @Override
    public boolean isLeaf(int index) {
        CommonUtils.checkArgument(index >= 0, "index has to be non-negative");
        return this.computeLeafIndex(index) >= 0;
    }

    @Override
    public int computeLeafIndex(int index) {
        return index - this.capacity;
    }

    @Override
    public int getPointIndex(int index) {
        return this.leafPointIndex[this.computeLeafIndex(index)];
    }

    @Override
    public int setPointIndex(int index, int pointIndex) {
        int newIndex = this.computeLeafIndex(index);
        int savedPointIndex = this.leafPointIndex[newIndex];
        this.leafPointIndex[newIndex] = pointIndex;
        return savedPointIndex;
    }

    public int[] getLeafFreeIndexes() {
        return this.freeLeafManager.getFreeIndexes();
    }

    public int[] getNodeFreeIndexes() {
        return this.freeNodeManager.getFreeIndexes();
    }

    public int[] getLeafPointIndex() {
        return this.leafPointIndex;
    }

    public int[] getLeafMass() {
        int[] result = new int[this.capacity + 1];
        System.arraycopy(this.mass, this.capacity, result, 0, this.capacity + 1);
        return result;
    }

    public int getLeafFreeIndexPointer() {
        return this.freeLeafManager.getFreeIndexPointer();
    }

    public int getNodeFreeIndexPointer() {
        return this.freeNodeManager.getFreeIndexPointer();
    }

    @Override
    public int getCapacity() {
        return this.freeNodeManager.getCapacity();
    }

    @Override
    public int size() {
        return this.freeNodeManager.size();
    }

    @Override
    public boolean isCanonicalAndNotALeaf() {
        boolean check = this.leftIndex.length == this.rightIndex.length;
        int leafCounter = this.leftIndex.length;
        int nodeCounter = 1;
        check = check && this.parentIndex[0] == -1 && this.freeNodeManager.occupied.get(0);
        for (int i = 0; i < this.size() && check; ++i) {
            if (this.leftIndex[i] != -1) {
                if (this.leftIndex[i] < this.leftIndex.length) {
                    check = nodeCounter == this.leftIndex[i];
                    ++nodeCounter;
                } else {
                    check = this.leftIndex[i] == leafCounter;
                    ++leafCounter;
                }
                boolean bl = check = check && this.rightIndex[i] != -1;
                if (this.rightIndex[i] < this.rightIndex.length) {
                    check = check && nodeCounter == this.rightIndex[i];
                    ++nodeCounter;
                    continue;
                }
                check = check && this.rightIndex[i] == leafCounter;
                ++leafCounter;
                continue;
            }
            check = check && this.rightIndex[i] == -1;
        }
        return check;
    }
}

