/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.store;

import com.amazon.randomcutforest.CommonUtils;
import java.util.Arrays;
import java.util.BitSet;

public class IndexManager {
    protected final int capacity;
    protected int[] freeIndexes;
    protected int freeIndexPointer;
    protected final BitSet occupied;

    public IndexManager(int capacity) {
        this(capacity, new BitSet(capacity));
    }

    public IndexManager(int capacity, BitSet bits) {
        CommonUtils.checkArgument(capacity > 0, "capacity must be greater than 0");
        this.capacity = capacity;
        this.occupied = bits;
        this.freeIndexPointer = capacity - this.occupied.cardinality() - 1;
        if (this.freeIndexPointer != capacity - 1) {
            this.freeIndexes = new int[this.freeIndexPointer + 1];
            int location = 0;
            for (int i = capacity - 1; i >= 0; --i) {
                if (this.occupied.get(i)) continue;
                this.freeIndexes[location++] = i;
            }
        } else {
            this.freeIndexes = new int[0];
        }
    }

    public IndexManager(int capacity, int[] freeIndexes, int freeIndexPointer) {
        CommonUtils.checkNotNull(freeIndexes, "freeIndexes must not be null");
        this.capacity = capacity;
        this.freeIndexes = freeIndexes;
        this.freeIndexPointer = freeIndexPointer;
        this.occupied = new BitSet(capacity);
        this.occupied.set(0, capacity);
        for (int i = 0; i < freeIndexPointer; ++i) {
            if (i < freeIndexes.length) {
                this.occupied.clear(freeIndexes[i]);
                continue;
            }
            this.occupied.clear(capacity - i - 1);
        }
    }

    public IndexManager(int[] freeIndexes, int freeIndexPointer) {
        this(freeIndexes.length, freeIndexes, freeIndexPointer);
    }

    public IndexManager(IndexManager manager, int newCapacity) {
        this(newCapacity);
        CommonUtils.checkArgument(manager.occupied.cardinality() == manager.capacity, " incorrect application, not full");
        this.occupied.or(manager.occupied);
        this.freeIndexPointer = newCapacity - manager.capacity - 1;
    }

    public boolean isFull() {
        return this.freeIndexPointer == -1;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int size() {
        return this.capacity - this.freeIndexPointer - 1;
    }

    protected int takeIndex() {
        int index;
        CommonUtils.checkState(this.freeIndexPointer >= 0, "store is full");
        if (this.freeIndexPointer < this.freeIndexes.length) {
            index = this.freeIndexes[this.freeIndexPointer--];
        } else {
            index = this.capacity - this.freeIndexPointer - 1;
            --this.freeIndexPointer;
        }
        this.occupied.set(index);
        return index;
    }

    protected void releaseIndex(int index) {
        this.checkValidIndex(index);
        this.occupied.clear(index);
        if (this.freeIndexPointer + 1 >= this.freeIndexes.length) {
            if (index == this.capacity - (this.freeIndexPointer + 1) - 1) {
                ++this.freeIndexPointer;
                return;
            }
            int cap = Math.min(this.capacity, this.freeIndexPointer + 10);
            int oldLength = this.freeIndexes.length;
            this.freeIndexes = Arrays.copyOf(this.freeIndexes, cap);
            for (int j = oldLength; j < cap && j < this.freeIndexPointer + 1; ++j) {
                this.freeIndexes[j] = this.capacity - j - 1;
            }
        }
        this.freeIndexes[++this.freeIndexPointer] = index;
    }

    protected void checkValidIndex(int index) {
        CommonUtils.checkArgument(index >= 0 && index < this.capacity, "index must be between 0 (inclusive) and capacity (exclusive)");
        CommonUtils.checkArgument(this.occupied.get(index), "this index is not being used");
    }

    public int getFreeIndexPointer() {
        return this.freeIndexPointer;
    }

    public int[] getFreeIndexes() {
        if (this.freeIndexPointer + 1 < this.freeIndexes.length) {
            return Arrays.copyOf(this.freeIndexes, this.freeIndexPointer + 1);
        }
        return this.freeIndexes;
    }
}

