/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.state.tree;

import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.state.IContextualStateMapper;
import com.amazon.randomcutforest.state.IStateMapper;
import com.amazon.randomcutforest.state.store.NodeStoreMapper;
import com.amazon.randomcutforest.state.store.NodeStoreState;
import com.amazon.randomcutforest.state.store.SmallNodeStoreMapper;
import com.amazon.randomcutforest.state.tree.CompactRandomCutTreeContext;
import com.amazon.randomcutforest.state.tree.CompactRandomCutTreeState;
import com.amazon.randomcutforest.store.INodeStore;
import com.amazon.randomcutforest.store.NodeStore;
import com.amazon.randomcutforest.store.PointStoreFloat;
import com.amazon.randomcutforest.store.SmallNodeStore;
import com.amazon.randomcutforest.tree.AbstractCompactRandomCutTree;
import com.amazon.randomcutforest.tree.CompactRandomCutTreeFloat;
import lombok.Generated;

public class CompactRandomCutTreeFloatMapper
implements IContextualStateMapper<CompactRandomCutTreeFloat, CompactRandomCutTreeState, CompactRandomCutTreeContext> {
    private boolean partialTreeStateEnabled = false;
    private boolean compressed = true;

    @Override
    public CompactRandomCutTreeFloat toModel(CompactRandomCutTreeState state, CompactRandomCutTreeContext context, long seed) {
        INodeStore nodeStore;
        IStateMapper<SmallNodeStore, NodeStoreState> nodeStoreMapper;
        if (AbstractCompactRandomCutTree.canUseSmallNodeStore(Precision.valueOf(state.getNodeStoreState().getPrecision()), state.getMaxSize(), state.getDimensions())) {
            nodeStoreMapper = new SmallNodeStoreMapper();
            ((SmallNodeStoreMapper)nodeStoreMapper).setPartialTreeStateEnabled(state.isPartialTreeState());
            nodeStore = nodeStoreMapper.toModel(state.getNodeStoreState());
        } else {
            nodeStoreMapper = new NodeStoreMapper();
            ((NodeStoreMapper)nodeStoreMapper).setPartialTreeStateEnabled(state.isPartialTreeState());
            nodeStore = nodeStoreMapper.toModel(state.getNodeStoreState());
        }
        CompactRandomCutTreeFloat tree = ((CompactRandomCutTreeFloat.Builder)((CompactRandomCutTreeFloat.Builder)((CompactRandomCutTreeFloat.Builder)((CompactRandomCutTreeFloat.Builder)((CompactRandomCutTreeFloat.Builder)((CompactRandomCutTreeFloat.Builder)((CompactRandomCutTreeFloat.Builder)((CompactRandomCutTreeFloat.Builder)new CompactRandomCutTreeFloat.Builder().boundingBoxCacheFraction(state.getBoundingBoxCacheFraction())).storeSequenceIndexesEnabled(state.isStoreSequenceIndexesEnabled())).maxSize(state.getMaxSize())).root(state.getRoot())).randomSeed(state.getSeed())).pointStore((PointStoreFloat)context.getPointStore()).nodeStore(nodeStore)).centerOfMassEnabled(state.isCenterOfMassEnabled())).outputAfter(state.getOutputAfter())).build();
        return tree;
    }

    @Override
    public CompactRandomCutTreeState toState(CompactRandomCutTreeFloat model) {
        CompactRandomCutTreeState state = new CompactRandomCutTreeState();
        model.reorderNodesInBreadthFirstOrder();
        state.setRoot(model.getRootIndex());
        state.setMaxSize(model.getMaxSize());
        state.setPartialTreeState(model.storeSequenceIndexesEnabled || this.partialTreeStateEnabled);
        state.setStoreSequenceIndexesEnabled(model.storeSequenceIndexesEnabled);
        state.setCenterOfMassEnabled(model.centerOfMassEnabled);
        state.setBoundingBoxCacheFraction(model.getBoundingBoxCacheFraction());
        state.setOutputAfter(model.getOutputAfter());
        state.setSeed(model.getRandomSeed());
        state.setDimensions(model.getDimension());
        if (model.isSmallNodeStoreInUse()) {
            SmallNodeStoreMapper nodeStoreMapper = new SmallNodeStoreMapper();
            nodeStoreMapper.setCompressionEnabled(this.compressed);
            nodeStoreMapper.setPartialTreeStateEnabled(state.isPartialTreeState());
            nodeStoreMapper.setPrecision(Precision.FLOAT_32);
            state.setNodeStoreState(nodeStoreMapper.toState((SmallNodeStore)model.getNodeStore()));
        } else {
            NodeStoreMapper nodeStoreMapper = new NodeStoreMapper();
            nodeStoreMapper.setCompressionEnabled(this.compressed);
            nodeStoreMapper.setPartialTreeStateEnabled(state.isPartialTreeState());
            nodeStoreMapper.setPrecision(Precision.FLOAT_32);
            state.setNodeStoreState(nodeStoreMapper.toState((NodeStore)model.getNodeStore()));
        }
        return state;
    }

    @Generated
    public boolean isPartialTreeStateEnabled() {
        return this.partialTreeStateEnabled;
    }

    @Generated
    public boolean isCompressed() {
        return this.compressed;
    }

    @Generated
    public void setPartialTreeStateEnabled(boolean partialTreeStateEnabled) {
        this.partialTreeStateEnabled = partialTreeStateEnabled;
    }

    @Generated
    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }
}

