/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.state.store;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.state.IStateMapper;
import com.amazon.randomcutforest.state.store.NodeStoreMapper;
import com.amazon.randomcutforest.state.store.NodeStoreState;
import com.amazon.randomcutforest.store.SmallNodeStore;
import com.amazon.randomcutforest.util.ArrayPacking;
import java.util.Arrays;
import lombok.Generated;

public class SmallNodeStoreMapper
implements IStateMapper<SmallNodeStore, NodeStoreState> {
    private Precision precision = Precision.FLOAT_32;
    private boolean compressionEnabled = true;
    private boolean partialTreeStateEnabled = false;

    @Override
    public SmallNodeStore toModel(NodeStoreState state, long seed) {
        int[] leafPointIndex;
        int[] leafMass;
        CommonUtils.checkState(Precision.valueOf(state.getPrecision()) == Precision.FLOAT_32, " incorrect invocation of SmallNodeStore");
        int capacity = state.getCapacity();
        short[] cutDimension = ArrayPacking.unpackShorts(state.getCutDimension(), state.isCompressed());
        float[] cutValue = ArrayPacking.unpackFloats(state.getCutValueData());
        int[] leftIndex = ArrayPacking.unpackInts(state.getLeftIndex(), state.isCompressed());
        int[] rightIndex = ArrayPacking.unpackInts(state.getRightIndex(), state.isCompressed());
        if (state.isCanonicalAndNotALeaf()) {
            NodeStoreMapper.reverseBits(state.getSize(), leftIndex, rightIndex);
        }
        if (state.isPartialTreeStateEnabled()) {
            leafMass = null;
            leafPointIndex = null;
        } else {
            leafMass = ArrayPacking.unpackInts(state.getLeafMass(), state.isCompressed());
            leafPointIndex = ArrayPacking.unpackInts(state.getLeafPointIndex(), state.isCompressed());
        }
        int[] nodeFreeIndexes = ArrayPacking.unpackInts(state.getNodeFreeIndexes(), state.isCompressed());
        int nodeFreeIndexPointer = state.getNodeFreeIndexPointer();
        int[] leafFreeIndexes = ArrayPacking.unpackInts(state.getLeafFreeIndexes(), state.isCompressed());
        int leafFreeIndexPointer = state.getLeafFreeIndexPointer();
        return new SmallNodeStore(capacity, leftIndex, rightIndex, cutDimension, cutValue, leafMass, leafPointIndex, nodeFreeIndexes, nodeFreeIndexPointer, leafFreeIndexes, leafFreeIndexPointer);
    }

    @Override
    public NodeStoreState toState(SmallNodeStore model) {
        NodeStoreState state = new NodeStoreState();
        state.setCapacity(model.getCapacity());
        state.setCompressed(this.compressionEnabled);
        state.setPartialTreeStateEnabled(this.partialTreeStateEnabled);
        state.setPrecision(this.precision.name());
        int[] leftIndex = Arrays.copyOf(model.getLeftIndex(), model.getLeftIndex().length);
        int[] rightIndex = Arrays.copyOf(model.getRightIndex(), model.getRightIndex().length);
        boolean check = state.isCompressed() && model.isCanonicalAndNotALeaf();
        state.setCanonicalAndNotALeaf(check);
        if (check) {
            NodeStoreMapper.reduceToBits(model.size(), leftIndex, rightIndex);
            state.setLeftIndex(ArrayPacking.pack(leftIndex, state.isCompressed()));
            state.setRightIndex(ArrayPacking.pack(rightIndex, state.isCompressed()));
            state.setSize(model.size());
        } else {
            state.setLeftIndex(ArrayPacking.pack(model.getLeftIndex(), state.isCompressed()));
            state.setRightIndex(ArrayPacking.pack(model.getRightIndex(), state.isCompressed()));
        }
        state.setCutDimension(ArrayPacking.pack(model.getCutDimension(), state.isCompressed()));
        state.setCutValueData(ArrayPacking.pack(CommonUtils.toFloatArray(model.getCutValue())));
        state.setNodeFreeIndexes(ArrayPacking.pack(model.getNodeFreeIndexes(), state.isCompressed()));
        state.setNodeFreeIndexPointer(model.getNodeFreeIndexPointer());
        state.setLeafFreeIndexes(ArrayPacking.pack(model.getLeafFreeIndexes(), state.isCompressed()));
        state.setLeafFreeIndexPointer(model.getLeafFreeIndexPointer());
        if (!state.isPartialTreeStateEnabled()) {
            state.setLeafPointIndex(ArrayPacking.pack(model.getLeafPointIndex(), state.isCompressed()));
            state.setLeafMass(ArrayPacking.pack(model.getLeafMass(), state.isCompressed()));
        }
        return state;
    }

    @Generated
    public Precision getPrecision() {
        return this.precision;
    }

    @Generated
    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    @Generated
    public boolean isPartialTreeStateEnabled() {
        return this.partialTreeStateEnabled;
    }

    @Generated
    public void setPrecision(Precision precision) {
        this.precision = precision;
    }

    @Generated
    public void setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
    }

    @Generated
    public void setPartialTreeStateEnabled(boolean partialTreeStateEnabled) {
        this.partialTreeStateEnabled = partialTreeStateEnabled;
    }
}

