/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.state.store;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.state.IStateMapper;
import com.amazon.randomcutforest.state.store.PointStoreState;
import com.amazon.randomcutforest.store.PointStore;
import com.amazon.randomcutforest.store.PointStoreDouble;
import com.amazon.randomcutforest.util.ArrayPacking;
import java.util.Arrays;
import lombok.Generated;

public class PointStoreDoubleMapper
implements IStateMapper<PointStoreDouble, PointStoreState> {
    private boolean compressionEnabled = true;

    @Override
    public PointStoreDouble toModel(PointStoreState state, long seed) {
        CommonUtils.checkNotNull(state.getRefCount(), "refCount must not be null");
        CommonUtils.checkNotNull(state.getPointData(), "pointData must not be null");
        CommonUtils.checkArgument(Precision.valueOf(state.getPrecision()) == Precision.FLOAT_64, "precision must be " + (Object)((Object)Precision.FLOAT_64));
        int indexCapacity = state.getIndexCapacity();
        int dimensions = state.getDimensions();
        double[] store = ArrayPacking.unpackDoubles(state.getPointData(), state.getCurrentStoreCapacity() * dimensions);
        int startOfFreeSegment = state.getStartOfFreeSegment();
        int[] refCount = ArrayPacking.unpackInts(state.getRefCount(), indexCapacity, state.isCompressed());
        int[] locationList = new int[indexCapacity];
        Arrays.fill(locationList, PointStore.INFEASIBLE_POINTSTORE_LOCATION);
        int[] tempList = ArrayPacking.unpackInts(state.getLocationList(), state.isCompressed());
        System.arraycopy(tempList, 0, locationList, 0, tempList.length);
        return ((PointStoreDouble.Builder)((PointStoreDouble.Builder)((PointStoreDouble.Builder)((PointStoreDouble.Builder)((PointStoreDouble.Builder)((PointStoreDouble.Builder)((PointStoreDouble.Builder)((PointStoreDouble.Builder)((PointStoreDouble.Builder)((PointStoreDouble.Builder)((PointStoreDouble.Builder)((PointStoreDouble.Builder)((PointStoreDouble.Builder)((PointStoreDouble.Builder)PointStoreDouble.builder().internalRotationEnabled(state.isRotationEnabled())).internalShinglingEnabled(state.isInternalShinglingEnabled())).dynamicResizingEnabled(state.isDynamicResizingEnabled())).directLocationEnabled(state.isDirectLocationMap())).indexCapacity(indexCapacity)).currentStoreCapacity(state.getCurrentStoreCapacity())).capacity(state.getCapacity())).shingleSize(state.getShingleSize())).dimensions(state.getDimensions())).locationList(locationList)).nextTimeStamp(state.getLastTimeStamp())).startOfFreeSegment(startOfFreeSegment)).refCount(refCount)).knownShingle(state.getInternalShingle())).store(store).build();
    }

    @Override
    public PointStoreState toState(PointStoreDouble model) {
        model.compact();
        PointStoreState state = new PointStoreState();
        state.setCompressed(this.compressionEnabled);
        state.setDimensions(model.getDimensions());
        state.setCapacity(model.getCapacity());
        state.setShingleSize(model.getShingleSize());
        state.setDirectLocationMap(model.isDirectLocationMap());
        state.setInternalShinglingEnabled(model.isInternalShinglingEnabled());
        state.setLastTimeStamp(model.getNextSequenceIndex());
        if (model.isInternalShinglingEnabled()) {
            state.setInternalShingle(model.getInternalShingle());
            state.setRotationEnabled(model.isInternalRotationEnabled());
        }
        state.setDynamicResizingEnabled(model.isDynamicResizingEnabled());
        if (model.isDynamicResizingEnabled()) {
            state.setCurrentStoreCapacity(model.getCurrentStoreCapacity());
            state.setIndexCapacity(model.getIndexCapacity());
        }
        state.setStartOfFreeSegment(model.getStartOfFreeSegment());
        state.setPrecision(Precision.FLOAT_64.name());
        int prefix = model.getValidPrefix();
        state.setRefCount(ArrayPacking.pack(model.getRefCount(), prefix, state.isCompressed()));
        state.setLocationList(ArrayPacking.pack(model.getLocationList(), prefix, state.isCompressed()));
        state.setPointData(ArrayPacking.pack((double[])model.getStore(), model.getStartOfFreeSegment()));
        return state;
    }

    @Generated
    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    @Generated
    public void setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
    }
}

