/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.state.store;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.state.IStateMapper;
import com.amazon.randomcutforest.state.store.NodeStoreState;
import com.amazon.randomcutforest.store.NodeStore;
import com.amazon.randomcutforest.util.ArrayPacking;
import java.util.Arrays;
import lombok.Generated;

public class NodeStoreMapper
implements IStateMapper<NodeStore, NodeStoreState> {
    private Precision precision;
    private boolean compressionEnabled = true;
    private boolean partialTreeStateEnabled = false;

    @Override
    public NodeStore toModel(NodeStoreState state, long seed) {
        int[] leafPointIndex;
        int[] leafMass;
        int capacity = state.getCapacity();
        int[] cutDimension = ArrayPacking.unpackInts(state.getCutDimension(), state.isCompressed());
        double[] cutValue = Precision.valueOf(state.getPrecision()) == Precision.FLOAT_32 ? CommonUtils.toDoubleArray(ArrayPacking.unpackFloats(state.getCutValueData())) : ArrayPacking.unpackDoubles(state.getCutValueData());
        int[] leftIndex = ArrayPacking.unpackInts(state.getLeftIndex(), state.isCompressed());
        int[] rightIndex = ArrayPacking.unpackInts(state.getRightIndex(), state.isCompressed());
        if (state.isCanonicalAndNotALeaf()) {
            NodeStoreMapper.reverseBits(state.getSize(), leftIndex, rightIndex);
        }
        if (state.isPartialTreeStateEnabled()) {
            leafMass = null;
            leafPointIndex = null;
        } else {
            leafMass = ArrayPacking.unpackInts(state.getLeafMass(), state.isCompressed());
            leafPointIndex = ArrayPacking.unpackInts(state.getLeafPointIndex(), state.isCompressed());
        }
        int[] nodeFreeIndexes = ArrayPacking.unpackInts(state.getNodeFreeIndexes(), state.isCompressed());
        int nodeFreeIndexPointer = state.getNodeFreeIndexPointer();
        int[] leafFreeIndexes = ArrayPacking.unpackInts(state.getLeafFreeIndexes(), state.isCompressed());
        int leafFreeIndexPointer = state.getLeafFreeIndexPointer();
        return new NodeStore(capacity, leftIndex, rightIndex, cutDimension, cutValue, leafMass, leafPointIndex, nodeFreeIndexes, nodeFreeIndexPointer, leafFreeIndexes, leafFreeIndexPointer);
    }

    @Override
    public NodeStoreState toState(NodeStore model) {
        NodeStoreState state = new NodeStoreState();
        state.setCapacity(model.getCapacity());
        state.setCompressed(this.compressionEnabled);
        state.setPartialTreeStateEnabled(this.partialTreeStateEnabled);
        state.setPrecision(this.precision.name());
        int[] leftIndex = Arrays.copyOf(model.getLeftIndex(), model.getLeftIndex().length);
        int[] rightIndex = Arrays.copyOf(model.getRightIndex(), model.getRightIndex().length);
        boolean check = state.isCompressed() && model.isCanonicalAndNotALeaf();
        state.setCanonicalAndNotALeaf(check);
        if (check) {
            NodeStoreMapper.reduceToBits(model.size(), leftIndex, rightIndex);
            state.setLeftIndex(ArrayPacking.pack(leftIndex, state.isCompressed()));
            state.setRightIndex(ArrayPacking.pack(rightIndex, state.isCompressed()));
            state.setSize(model.size());
        } else {
            state.setLeftIndex(ArrayPacking.pack(model.getLeftIndex(), state.isCompressed()));
            state.setRightIndex(ArrayPacking.pack(model.getRightIndex(), state.isCompressed()));
        }
        state.setCutDimension(ArrayPacking.pack(model.getCutDimension(), state.isCompressed()));
        if (Precision.valueOf(state.getPrecision()) == Precision.FLOAT_32) {
            state.setCutValueData(ArrayPacking.pack(CommonUtils.toFloatArray(model.getCutValue())));
        } else {
            state.setCutValueData(ArrayPacking.pack(model.getCutValue(), model.getCutValue().length));
        }
        state.setNodeFreeIndexes(ArrayPacking.pack(model.getNodeFreeIndexes(), state.isCompressed()));
        state.setNodeFreeIndexPointer(model.getNodeFreeIndexPointer());
        state.setLeafFreeIndexes(ArrayPacking.pack(model.getLeafFreeIndexes(), state.isCompressed()));
        state.setLeafFreeIndexPointer(model.getLeafFreeIndexPointer());
        if (!state.isPartialTreeStateEnabled()) {
            state.setLeafPointIndex(ArrayPacking.pack(model.getLeafPointIndex(), state.isCompressed()));
            state.setLeafMass(ArrayPacking.pack(model.getLeafMass(), state.isCompressed()));
        }
        return state;
    }

    protected static void reduceToBits(int size, int[] leftIndex, int[] rightIndex) {
        for (int i = 0; i < size; ++i) {
            if (leftIndex[i] == -1) continue;
            leftIndex[i] = leftIndex[i] < leftIndex.length ? 1 : 0;
            rightIndex[i] = rightIndex[i] < rightIndex.length ? 1 : 0;
        }
    }

    protected static void reverseBits(int size, int[] leftIndex, int[] rightIndex) {
        int i;
        int nodeCounter = 1;
        int leafCounter = leftIndex.length;
        for (i = 0; i < size; ++i) {
            leftIndex[i] = leftIndex[i] != 0 ? nodeCounter++ : leafCounter++;
            rightIndex[i] = rightIndex[i] != 0 ? nodeCounter++ : leafCounter++;
        }
        for (i = size; i < leftIndex.length; ++i) {
            rightIndex[i] = -1;
            leftIndex[i] = -1;
        }
    }

    @Generated
    public Precision getPrecision() {
        return this.precision;
    }

    @Generated
    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    @Generated
    public boolean isPartialTreeStateEnabled() {
        return this.partialTreeStateEnabled;
    }

    @Generated
    public void setPrecision(Precision precision) {
        this.precision = precision;
    }

    @Generated
    public void setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
    }

    @Generated
    public void setPartialTreeStateEnabled(boolean partialTreeStateEnabled) {
        this.partialTreeStateEnabled = partialTreeStateEnabled;
    }
}

