/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.state.sampler;

import com.amazon.randomcutforest.sampler.SimpleStreamSampler;
import com.amazon.randomcutforest.sampler.Weighted;
import com.amazon.randomcutforest.state.sampler.CompactSamplerState;
import com.amazon.randomcutforest.state.store.PointStoreDoubleMapper;
import com.amazon.randomcutforest.state.store.PointStoreState;
import com.amazon.randomcutforest.store.PointStoreDouble;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArraySamplersToCompactStateConverter {
    private final Map<double[], Integer> pointMap = new HashMap<double[], Integer>();
    private final PointStoreDouble pointStoreDouble;
    private final List<CompactSamplerState> compactSamplerStates;
    boolean storeSequenceIndexesEnabled;

    public ArraySamplersToCompactStateConverter(boolean storeSequenceIndexesEnabled, int dimensions, int capacity) {
        this.pointStoreDouble = new PointStoreDouble(dimensions, capacity);
        this.compactSamplerStates = new ArrayList<CompactSamplerState>();
        this.storeSequenceIndexesEnabled = storeSequenceIndexesEnabled;
    }

    public PointStoreState getPointStoreDoubleState() {
        return new PointStoreDoubleMapper().toState(this.pointStoreDouble);
    }

    public List<CompactSamplerState> getCompactSamplerStates() {
        return this.compactSamplerStates;
    }

    public void addSampler(SimpleStreamSampler<double[]> sampler) {
        int[] pointIndex = new int[sampler.size()];
        float[] weight = new float[sampler.size()];
        long[] sequenceIndex = this.storeSequenceIndexesEnabled ? new long[sampler.size()] : null;
        int i = 0;
        for (Weighted<double[]> sample : sampler.getWeightedSample()) {
            double[] index = sample.getValue();
            if (this.pointMap.containsKey(index)) {
                pointIndex[i] = this.pointMap.get(index);
                this.pointStoreDouble.incrementRefCount(pointIndex[i]);
            } else {
                pointIndex[i] = this.pointStoreDouble.add(index, i);
                this.pointMap.put(index, pointIndex[i]);
            }
            weight[i] = sample.getWeight();
            if (sequenceIndex != null) {
                sequenceIndex[i] = sample.getSequenceIndex();
            }
            ++i;
        }
        CompactSamplerState samplerState = new CompactSamplerState();
        samplerState.setSize(sampler.size());
        samplerState.setCapacity(sampler.getCapacity());
        samplerState.setTimeDecay(sampler.getTimeDecay());
        samplerState.setPointIndex(pointIndex);
        samplerState.setWeight(weight);
        samplerState.setSequenceIndex(sequenceIndex);
        samplerState.setSequenceIndexOfMostRecentTimeDecayUpdate(sampler.getMostRecentTimeDecayUpdate());
        samplerState.setMaxSequenceIndex(sampler.getMaxSequenceIndex());
        samplerState.setInitialAcceptFraction(sampler.getInitialAcceptFraction());
        this.compactSamplerStates.add(samplerState);
    }
}

