/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.state;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.ComponentList;
import com.amazon.randomcutforest.IComponentModel;
import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.executor.PassThroughCoordinator;
import com.amazon.randomcutforest.executor.PointStoreCoordinator;
import com.amazon.randomcutforest.executor.SamplerPlusTree;
import com.amazon.randomcutforest.sampler.CompactSampler;
import com.amazon.randomcutforest.sampler.IStreamSampler;
import com.amazon.randomcutforest.sampler.SimpleStreamSampler;
import com.amazon.randomcutforest.sampler.Weighted;
import com.amazon.randomcutforest.state.ExecutionContext;
import com.amazon.randomcutforest.state.IContextualStateMapper;
import com.amazon.randomcutforest.state.RandomCutForestState;
import com.amazon.randomcutforest.state.sampler.ArraySamplersToCompactStateConverter;
import com.amazon.randomcutforest.state.sampler.CompactSamplerMapper;
import com.amazon.randomcutforest.state.sampler.CompactSamplerState;
import com.amazon.randomcutforest.state.store.PointStoreDoubleMapper;
import com.amazon.randomcutforest.state.store.PointStoreFloatMapper;
import com.amazon.randomcutforest.state.store.PointStoreState;
import com.amazon.randomcutforest.state.tree.CompactRandomCutTreeContext;
import com.amazon.randomcutforest.state.tree.CompactRandomCutTreeDoubleMapper;
import com.amazon.randomcutforest.state.tree.CompactRandomCutTreeFloatMapper;
import com.amazon.randomcutforest.state.tree.CompactRandomCutTreeState;
import com.amazon.randomcutforest.store.IPointStore;
import com.amazon.randomcutforest.store.PointStoreDouble;
import com.amazon.randomcutforest.store.PointStoreFloat;
import com.amazon.randomcutforest.tree.CompactRandomCutTreeDouble;
import com.amazon.randomcutforest.tree.CompactRandomCutTreeFloat;
import com.amazon.randomcutforest.tree.ITree;
import com.amazon.randomcutforest.tree.RandomCutTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import lombok.Generated;

public class RandomCutForestMapper
implements IContextualStateMapper<RandomCutForest, RandomCutForestState, ExecutionContext> {
    private boolean saveTreeStateEnabled = false;
    private boolean saveCoordinatorStateEnabled = true;
    private boolean saveSamplerStateEnabled = true;
    private boolean saveExecutorContextEnabled = false;
    private boolean compressionEnabled = true;
    private boolean partialTreeStateEnabled = false;

    @Override
    public RandomCutForestState toState(RandomCutForest forest) {
        if (this.saveTreeStateEnabled) {
            CommonUtils.checkArgument(forest.isCompact(), "tree state cannot be saved for noncompact forests");
        }
        RandomCutForestState state = new RandomCutForestState();
        state.setNumberOfTrees(forest.getNumberOfTrees());
        state.setDimensions(forest.getDimensions());
        state.setTimeDecay(forest.getTimeDecay());
        state.setSampleSize(forest.getSampleSize());
        state.setShingleSize(forest.getShingleSize());
        state.setCenterOfMassEnabled(forest.isCenterOfMassEnabled());
        state.setOutputAfter(forest.getOutputAfter());
        state.setStoreSequenceIndexesEnabled(forest.isStoreSequenceIndexesEnabled());
        state.setTotalUpdates(forest.getTotalUpdates());
        state.setCompact(forest.isCompact());
        state.setInternalShinglingEnabled(forest.isInternalShinglingEnabled());
        state.setBoundingBoxCacheFraction(forest.getBoundingBoxCacheFraction());
        state.setSaveSamplerStateEnabled(this.saveSamplerStateEnabled);
        state.setSaveTreeStateEnabled(this.saveTreeStateEnabled);
        state.setSaveCoordinatorStateEnabled(this.saveCoordinatorStateEnabled);
        state.setPrecision(forest.getPrecision().name());
        state.setCompressed(this.compressionEnabled);
        state.setPartialTreeState(this.partialTreeStateEnabled);
        if (this.saveExecutorContextEnabled) {
            ExecutionContext executionContext = new ExecutionContext();
            executionContext.setParallelExecutionEnabled(forest.isParallelExecutionEnabled());
            executionContext.setThreadPoolSize(forest.getThreadPoolSize());
            state.setExecutionContext(executionContext);
        }
        if (forest.isCompact()) {
            if (this.saveCoordinatorStateEnabled) {
                PointStoreState pointStoreState;
                PointStoreCoordinator pointStoreCoordinator = (PointStoreCoordinator)forest.getUpdateCoordinator();
                if (forest.getPrecision() == Precision.FLOAT_32) {
                    PointStoreFloatMapper pointStoreFloatMapper = new PointStoreFloatMapper();
                    pointStoreFloatMapper.setCompressionEnabled(this.compressionEnabled);
                    pointStoreState = pointStoreFloatMapper.toState((PointStoreFloat)pointStoreCoordinator.getStore());
                } else {
                    PointStoreDoubleMapper pointStoreDoubleMapper = new PointStoreDoubleMapper();
                    pointStoreDoubleMapper.setCompressionEnabled(this.compressionEnabled);
                    pointStoreState = pointStoreDoubleMapper.toState((PointStoreDouble)pointStoreCoordinator.getStore());
                }
                state.setPointStoreState(pointStoreState);
            }
            ArrayList<CompactSamplerState> samplerStates = null;
            if (this.saveSamplerStateEnabled) {
                samplerStates = new ArrayList<CompactSamplerState>();
            }
            ArrayList trees = null;
            if (this.saveTreeStateEnabled) {
                trees = new ArrayList();
            }
            CompactSamplerMapper compactSamplerMapper = new CompactSamplerMapper();
            compactSamplerMapper.setCompressionEnabled(this.compressionEnabled);
            for (IComponentModel iComponentModel : forest.getComponents()) {
                SamplerPlusTree samplerPlusTree = (SamplerPlusTree)iComponentModel;
                CompactSampler sampler = (CompactSampler)samplerPlusTree.getSampler();
                if (samplerStates != null) {
                    samplerStates.add(compactSamplerMapper.toState(sampler));
                }
                if (trees == null) continue;
                trees.add(samplerPlusTree.getTree());
            }
            state.setCompactSamplerStates(samplerStates);
            if (trees != null) {
                IContextualStateMapper<CompactRandomCutTreeFloat, CompactRandomCutTreeState, CompactRandomCutTreeContext> treeMapper;
                if (forest.getPrecision() == Precision.FLOAT_32) {
                    treeMapper = new CompactRandomCutTreeFloatMapper();
                    ((CompactRandomCutTreeFloatMapper)treeMapper).setCompressed(this.compressionEnabled);
                    ((CompactRandomCutTreeFloatMapper)treeMapper).setPartialTreeStateEnabled(this.partialTreeStateEnabled || forest.isStoreSequenceIndexesEnabled());
                    List<CompactRandomCutTreeState> list = trees.stream().map(t -> treeMapper.toState((CompactRandomCutTreeFloat)t)).collect(Collectors.toList());
                    state.setCompactRandomCutTreeStates(list);
                } else {
                    treeMapper = new CompactRandomCutTreeDoubleMapper();
                    ((CompactRandomCutTreeDoubleMapper)treeMapper).setCompress(this.compressionEnabled);
                    ((CompactRandomCutTreeDoubleMapper)treeMapper).setPartialTreeStateEnabled(this.partialTreeStateEnabled || forest.isStoreSequenceIndexesEnabled());
                    List<CompactRandomCutTreeState> list = trees.stream().map(t -> treeMapper.toState((CompactRandomCutTreeDouble)t)).collect(Collectors.toList());
                    state.setCompactRandomCutTreeStates(list);
                }
            }
        } else {
            ArraySamplersToCompactStateConverter converter = new ArraySamplersToCompactStateConverter(forest.isStoreSequenceIndexesEnabled(), forest.getDimensions(), forest.getNumberOfTrees() * forest.getSampleSize());
            for (IComponentModel iComponentModel : forest.getComponents()) {
                SamplerPlusTree samplerPlusTree = (SamplerPlusTree)iComponentModel;
                SimpleStreamSampler simpleStreamSampler = (SimpleStreamSampler)samplerPlusTree.getSampler();
                converter.addSampler(simpleStreamSampler);
            }
            state.setPointStoreState(converter.getPointStoreDoubleState());
            state.setCompactSamplerStates(converter.getCompactSamplerStates());
        }
        return state;
    }

    @Override
    public RandomCutForest toModel(RandomCutForestState state, ExecutionContext executionContext, long seed) {
        ExecutionContext ec;
        if (executionContext != null) {
            ec = executionContext;
        } else {
            CommonUtils.checkNotNull(state.getExecutionContext(), "The executor context in the state object is null, an executor context must be passed explicitly to toModel()");
            ec = state.getExecutionContext();
        }
        Object builder = ((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)RandomCutForest.builder().numberOfTrees(state.getNumberOfTrees())).dimensions(state.getDimensions())).timeDecay(state.getTimeDecay())).sampleSize(state.getSampleSize())).centerOfMassEnabled(state.isCenterOfMassEnabled())).outputAfter(state.getOutputAfter())).parallelExecutionEnabled(ec.isParallelExecutionEnabled())).threadPoolSize(ec.getThreadPoolSize())).storeSequenceIndexesEnabled(state.isStoreSequenceIndexesEnabled())).shingleSize(state.getShingleSize())).boundingBoxCacheFraction(state.getBoundingBoxCacheFraction())).compact(state.isCompact())).internalShinglingEnabled(state.isInternalShinglingEnabled())).randomSeed(seed);
        if (state.isCompact()) {
            if (Precision.valueOf(state.getPrecision()) == Precision.FLOAT_32) {
                return this.singlePrecisionForest((RandomCutForest.Builder<?>)builder, state, null, null, null);
            }
            return this.doublePrecisionForest((RandomCutForest.Builder<?>)builder, state, null, null, null);
        }
        Random random = ((RandomCutForest.Builder)builder).getRandom();
        List<CompactSamplerState> samplerStates = state.getCompactSamplerStates();
        CompactSamplerMapper samplerMapper = new CompactSamplerMapper();
        PointStoreDouble pointStore = (PointStoreDouble)new PointStoreDoubleMapper().toModel(state.getPointStoreState());
        PassThroughCoordinator coordinator = new PassThroughCoordinator();
        coordinator.setTotalUpdates(state.getTotalUpdates());
        ComponentList components = new ComponentList();
        for (int i = 0; i < state.getNumberOfTrees(); ++i) {
            CompactSampler compactData = (CompactSampler)samplerMapper.toModel(samplerStates.get(i));
            RandomCutTree tree = ((RandomCutTree.Builder)((RandomCutTree.Builder)((RandomCutTree.Builder)((RandomCutTree.Builder)RandomCutTree.builder().storeSequenceIndexesEnabled(state.isStoreSequenceIndexesEnabled())).outputAfter(state.getOutputAfter())).centerOfMassEnabled(state.isCenterOfMassEnabled())).randomSeed(random.nextLong())).build();
            SimpleStreamSampler sampler = ((SimpleStreamSampler.Builder)((SimpleStreamSampler.Builder)((SimpleStreamSampler.Builder)SimpleStreamSampler.builder().capacity(state.getSampleSize())).timeDecay(state.getTimeDecay())).randomSeed(random.nextLong())).build();
            sampler.setMaxSequenceIndex(compactData.getMaxSequenceIndex());
            sampler.setMostRecentTimeDecayUpdate(compactData.getMostRecentTimeDecayUpdate());
            for (Weighted<Integer> sample : compactData.getWeightedSample()) {
                double[] point = pointStore.get(sample.getValue());
                sampler.addSample(new Weighted<double[]>(point, sample.getWeight(), sample.getSequenceIndex()));
                tree.addPoint(point, sample.getSequenceIndex());
            }
            components.add(new SamplerPlusTree<double[], double[]>(sampler, tree));
        }
        return new RandomCutForest((RandomCutForest.Builder<?>)builder, coordinator, components, random);
    }

    @Override
    public RandomCutForest toModel(RandomCutForestState state, long seed) {
        return this.toModel(state, null, seed);
    }

    public RandomCutForest toModel(RandomCutForestState state) {
        return (RandomCutForest)this.toModel(state, null);
    }

    public RandomCutForest singlePrecisionForest(RandomCutForest.Builder<?> builder, RandomCutForestState state, IPointStore<float[]> extPointStore, List<ITree<Integer, float[]>> extTrees, List<IStreamSampler<Integer>> extSamplers) {
        CommonUtils.checkArgument(builder != null, "builder cannot be null");
        CommonUtils.checkArgument(extTrees == null || extTrees.size() == state.getNumberOfTrees(), "incorrect number of trees");
        CommonUtils.checkArgument(extSamplers == null || extSamplers.size() == state.getNumberOfTrees(), "incorrect number of samplers");
        CommonUtils.checkArgument(extSamplers != null | state.isSaveSamplerStateEnabled(), " need samplers ");
        CommonUtils.checkArgument(extPointStore != null || state.isSaveCoordinatorStateEnabled(), " need coordinator state ");
        Random random = builder.getRandom();
        ComponentList components = new ComponentList();
        CompactRandomCutTreeContext context = new CompactRandomCutTreeContext();
        IPointStore pointStore = extPointStore == null ? (IPointStore)new PointStoreFloatMapper().toModel(state.getPointStoreState()) : extPointStore;
        PointStoreCoordinator<float[]> coordinator = new PointStoreCoordinator<float[]>(pointStore);
        coordinator.setTotalUpdates(state.getTotalUpdates());
        context.setPointStore(pointStore);
        context.setMaxSize(state.getSampleSize());
        CompactRandomCutTreeFloatMapper treeMapper = new CompactRandomCutTreeFloatMapper();
        List<CompactRandomCutTreeState> treeStates = state.isSaveTreeStateEnabled() ? state.getCompactRandomCutTreeStates() : null;
        CompactSamplerMapper samplerMapper = new CompactSamplerMapper();
        List<CompactSamplerState> samplerStates = state.isSaveSamplerStateEnabled() ? state.getCompactSamplerStates() : null;
        for (int i = 0; i < state.getNumberOfTrees(); ++i) {
            CompactRandomCutTreeFloat tree;
            CompactSampler sampler;
            CompactSampler compactSampler = sampler = extSamplers != null ? extSamplers.get(i) : samplerMapper.toModel(samplerStates.get(i), random.nextLong());
            if (extTrees != null) {
                tree = extTrees.get(i);
            } else if (treeStates != null) {
                tree = treeMapper.toModel(treeStates.get(i), context, random.nextLong());
                if (treeStates.get(i).isPartialTreeState()) {
                    sampler.getSample().forEach(s -> tree.addPoint((Integer)s.getValue(), s.getSequenceIndex()));
                }
            } else {
                tree = ((CompactRandomCutTreeFloat.Builder)((CompactRandomCutTreeFloat.Builder)((CompactRandomCutTreeFloat.Builder)((CompactRandomCutTreeFloat.Builder)((CompactRandomCutTreeFloat.Builder)new CompactRandomCutTreeFloat.Builder().maxSize(state.getSampleSize())).randomSeed(random.nextLong())).pointStore(pointStore).boundingBoxCacheFraction(state.getBoundingBoxCacheFraction())).centerOfMassEnabled(state.isCenterOfMassEnabled())).storeSequenceIndexesEnabled(state.isStoreSequenceIndexesEnabled())).build();
                sampler.getSample().forEach(s -> tree.addPoint((Integer)s.getValue(), s.getSequenceIndex()));
            }
            components.add(new SamplerPlusTree<Integer, float[]>(sampler, tree));
        }
        builder.precision(Precision.FLOAT_32);
        return new RandomCutForest(builder, coordinator, components, random);
    }

    public RandomCutForest doublePrecisionForest(RandomCutForest.Builder<?> builder, RandomCutForestState state, IPointStore<double[]> extPointStore, List<ITree<Integer, double[]>> extTrees, List<IStreamSampler<Integer>> extSamplers) {
        CommonUtils.checkArgument(builder != null, "builder cannot be null");
        CommonUtils.checkArgument(extTrees == null || extTrees.size() == state.getNumberOfTrees(), "incorrect number of trees");
        CommonUtils.checkArgument(extSamplers == null || extSamplers.size() == state.getNumberOfTrees(), "incorrect number of samplers");
        CommonUtils.checkArgument(extSamplers != null | state.isSaveSamplerStateEnabled(), " need samplers ");
        CommonUtils.checkArgument(extPointStore != null || state.isSaveCoordinatorStateEnabled(), " need coordinator state ");
        Random random = builder.getRandom();
        ComponentList components = new ComponentList();
        CompactRandomCutTreeContext context = new CompactRandomCutTreeContext();
        IPointStore pointStore = extPointStore == null ? (IPointStore)new PointStoreDoubleMapper().toModel(state.getPointStoreState()) : extPointStore;
        PointStoreCoordinator<double[]> coordinator = new PointStoreCoordinator<double[]>(pointStore);
        coordinator.setTotalUpdates(state.getTotalUpdates());
        context.setPointStore(pointStore);
        context.setMaxSize(state.getSampleSize());
        CompactRandomCutTreeDoubleMapper treeMapper = new CompactRandomCutTreeDoubleMapper();
        List<CompactRandomCutTreeState> treeStates = state.isSaveTreeStateEnabled() ? state.getCompactRandomCutTreeStates() : null;
        CompactSamplerMapper samplerMapper = new CompactSamplerMapper();
        List<CompactSamplerState> samplerStates = state.isSaveSamplerStateEnabled() ? state.getCompactSamplerStates() : null;
        for (int i = 0; i < state.getNumberOfTrees(); ++i) {
            CompactRandomCutTreeDouble tree;
            CompactSampler sampler;
            CompactSampler compactSampler = sampler = extSamplers != null ? extSamplers.get(i) : samplerMapper.toModel(samplerStates.get(i), random.nextLong());
            if (extTrees != null) {
                tree = extTrees.get(i);
            } else if (treeStates != null) {
                tree = treeMapper.toModel(treeStates.get(i), context, random.nextLong());
                if (treeStates.get(i).isPartialTreeState()) {
                    sampler.getSample().forEach(s -> tree.addPoint((Integer)s.getValue(), s.getSequenceIndex()));
                }
            } else {
                tree = ((CompactRandomCutTreeDouble.Builder)((CompactRandomCutTreeDouble.Builder)((CompactRandomCutTreeDouble.Builder)((CompactRandomCutTreeDouble.Builder)((CompactRandomCutTreeDouble.Builder)new CompactRandomCutTreeDouble.Builder().maxSize(state.getSampleSize())).randomSeed(random.nextLong())).pointStore(pointStore).boundingBoxCacheFraction(state.getBoundingBoxCacheFraction())).centerOfMassEnabled(state.isCenterOfMassEnabled())).storeSequenceIndexesEnabled(state.isStoreSequenceIndexesEnabled())).build();
                sampler.getSample().forEach(s -> tree.addPoint((Integer)s.getValue(), s.getSequenceIndex()));
            }
            components.add(new SamplerPlusTree<Integer, double[]>(sampler, tree));
        }
        builder.precision(Precision.FLOAT_64);
        return new RandomCutForest(builder, coordinator, components, random);
    }

    @Generated
    public boolean isSaveTreeStateEnabled() {
        return this.saveTreeStateEnabled;
    }

    @Generated
    public boolean isSaveCoordinatorStateEnabled() {
        return this.saveCoordinatorStateEnabled;
    }

    @Generated
    public boolean isSaveSamplerStateEnabled() {
        return this.saveSamplerStateEnabled;
    }

    @Generated
    public boolean isSaveExecutorContextEnabled() {
        return this.saveExecutorContextEnabled;
    }

    @Generated
    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    @Generated
    public boolean isPartialTreeStateEnabled() {
        return this.partialTreeStateEnabled;
    }

    @Generated
    public void setSaveTreeStateEnabled(boolean saveTreeStateEnabled) {
        this.saveTreeStateEnabled = saveTreeStateEnabled;
    }

    @Generated
    public void setSaveCoordinatorStateEnabled(boolean saveCoordinatorStateEnabled) {
        this.saveCoordinatorStateEnabled = saveCoordinatorStateEnabled;
    }

    @Generated
    public void setSaveSamplerStateEnabled(boolean saveSamplerStateEnabled) {
        this.saveSamplerStateEnabled = saveSamplerStateEnabled;
    }

    @Generated
    public void setSaveExecutorContextEnabled(boolean saveExecutorContextEnabled) {
        this.saveExecutorContextEnabled = saveExecutorContextEnabled;
    }

    @Generated
    public void setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
    }

    @Generated
    public void setPartialTreeStateEnabled(boolean partialTreeStateEnabled) {
        this.partialTreeStateEnabled = partialTreeStateEnabled;
    }
}

