/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.sampler;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.sampler.AbstractStreamSampler;
import com.amazon.randomcutforest.sampler.AcceptPointState;
import com.amazon.randomcutforest.sampler.ISampled;
import com.amazon.randomcutforest.sampler.Weighted;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;

public class SimpleStreamSampler<P>
extends AbstractStreamSampler<P> {
    private final Queue<Weighted<P>> sample = new PriorityQueue<Weighted>(Comparator.comparingDouble(Weighted::getWeight).reversed());

    public static <Q> Builder<Q> builder() {
        return new Builder();
    }

    protected SimpleStreamSampler(Builder<P> builder) {
        super(builder);
        this.timeDecay = builder.timeDecay;
    }

    @Override
    public boolean acceptPoint(long sequenceIndex) {
        boolean initial;
        CommonUtils.checkState(sequenceIndex >= this.mostRecentTimeDecayUpdate, "incorrect sequences submitted to sampler");
        this.evictedPoint = null;
        float weight = this.computeWeight(sequenceIndex);
        boolean bl = initial = this.size() < this.capacity && this.random.nextDouble() < this.initialAcceptProbability(this.size());
        if (initial || weight < this.sample.element().getWeight()) {
            if (!initial) {
                this.evictedPoint = this.sample.poll();
            }
            this.acceptPointState = new AcceptPointState(sequenceIndex, weight);
            return true;
        }
        return false;
    }

    @Override
    public void addPoint(P point) {
        CommonUtils.checkState(this.acceptPointState != null, "this method should only be called after a successful call to acceptSample(long)");
        this.sample.add(new Weighted<P>(point, this.acceptPointState.getWeight(), this.acceptPointState.getSequenceIndex()));
        this.acceptPointState = null;
    }

    public void addSample(Weighted<P> point) {
        this.sample.add(point);
    }

    @Override
    public Optional<ISampled<P>> getEvictedPoint() {
        return Optional.ofNullable(this.evictedPoint);
    }

    public List<Weighted<P>> getWeightedSample() {
        return new ArrayList<Weighted<P>>(this.sample);
    }

    @Override
    public List<ISampled<P>> getSample() {
        return new ArrayList<ISampled<P>>(this.sample);
    }

    @Override
    public int size() {
        return this.sample.size();
    }

    public static class Builder<Q>
    extends AbstractStreamSampler.Builder<Builder<Q>> {
        public SimpleStreamSampler<Q> build() {
            return new SimpleStreamSampler(this);
        }
    }
}

