/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.sampler;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.sampler.AcceptPointState;
import com.amazon.randomcutforest.sampler.ISampled;
import com.amazon.randomcutforest.sampler.IStreamSampler;
import java.util.Random;

public abstract class AbstractStreamSampler<P>
implements IStreamSampler<P> {
    protected double timeDecay;
    protected long mostRecentTimeDecayUpdate = 0L;
    protected long maxSequenceIndex = 0L;
    protected double accumuluatedTimeDecay = 0.0;
    protected ReplayableRandom random;
    protected transient ISampled<P> evictedPoint;
    protected final double initialAcceptFraction;
    protected final int capacity;
    protected AcceptPointState acceptPointState;

    protected double initialAcceptProbability(int currentSize) {
        if ((double)currentSize < this.initialAcceptFraction * (double)this.capacity) {
            return 1.0;
        }
        if (this.initialAcceptFraction >= 1.0) {
            return 0.0;
        }
        return 1.0 - (1.0 * (double)currentSize / (double)this.capacity - this.initialAcceptFraction) / (1.0 - this.initialAcceptFraction);
    }

    @Override
    public abstract boolean acceptPoint(long var1);

    @Override
    public abstract void addPoint(P var1);

    AbstractStreamSampler(Builder<?> builder) {
        this.capacity = builder.capacity;
        this.initialAcceptFraction = builder.initialAcceptFraction;
        this.timeDecay = builder.timeDecay;
        this.random = builder.random != null ? new ReplayableRandom(builder.random) : new ReplayableRandom(builder.randomSeed);
    }

    protected float computeWeight(long sequenceIndex) {
        double randomNumber = 0.0;
        while (randomNumber == 0.0) {
            randomNumber = this.random.nextDouble();
        }
        this.maxSequenceIndex = this.maxSequenceIndex < sequenceIndex ? sequenceIndex : this.maxSequenceIndex;
        return (float)((double)(-(sequenceIndex - this.mostRecentTimeDecayUpdate)) * this.timeDecay - this.accumuluatedTimeDecay + Math.log(-Math.log(randomNumber)));
    }

    public void setTimeDecay(double newTimeDecay) {
        this.accumuluatedTimeDecay += (double)(this.maxSequenceIndex - this.mostRecentTimeDecayUpdate) * this.timeDecay;
        this.timeDecay = newTimeDecay;
        this.mostRecentTimeDecayUpdate = this.maxSequenceIndex;
    }

    public double getTimeDecay() {
        return this.timeDecay;
    }

    public long getMaxSequenceIndex() {
        return this.maxSequenceIndex;
    }

    @Override
    public void setMaxSequenceIndex(long index) {
        this.maxSequenceIndex = index;
    }

    public long getMostRecentTimeDecayUpdate() {
        return this.mostRecentTimeDecayUpdate;
    }

    public void setMostRecentTimeDecayUpdate(long index) {
        this.mostRecentTimeDecayUpdate = index;
    }

    @Override
    public <T> void setConfig(String name, T value, Class<T> clazz) {
        if (!"time_decay".equals(name)) {
            throw new IllegalArgumentException("Unsupported configuration setting: " + name);
        }
        CommonUtils.checkArgument(Double.class.isAssignableFrom(clazz), String.format("Setting '%s' must be a double value", name));
        this.setTimeDecay((Double)value);
    }

    @Override
    public <T> T getConfig(String name, Class<T> clazz) {
        CommonUtils.checkNotNull(clazz, "clazz must not be null");
        if ("time_decay".equals(name)) {
            CommonUtils.checkArgument(clazz.isAssignableFrom(Double.class), String.format("Setting '%s' must be a double value", name));
            return clazz.cast(this.getTimeDecay());
        }
        throw new IllegalArgumentException("Unsupported configuration setting: " + name);
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public double getInitialAcceptFraction() {
        return this.initialAcceptFraction;
    }

    public long getRandomSeed() {
        return this.random.randomSeed;
    }

    public static class Builder<T extends Builder<T>> {
        protected int capacity = 256;
        protected double timeDecay = 0.0;
        protected Random random = null;
        protected long randomSeed = new Random().nextLong();
        protected long maxSequenceIndex = 0L;
        protected long sequenceIndexOfMostRecentTimeDecayUpdate = 0L;
        protected double initialAcceptFraction = 1.0;

        public T capacity(int capacity) {
            this.capacity = capacity;
            return (T)this;
        }

        public T randomSeed(long seed) {
            this.randomSeed = seed;
            return (T)this;
        }

        public T random(Random random) {
            this.random = random;
            return (T)this;
        }

        public T maxSequenceIndex(long maxSequenceIndex) {
            this.maxSequenceIndex = maxSequenceIndex;
            return (T)this;
        }

        public T mostRecentTimeDecayUpdate(long sequenceIndexOfMostRecentTimeDecayUpdate) {
            this.sequenceIndexOfMostRecentTimeDecayUpdate = sequenceIndexOfMostRecentTimeDecayUpdate;
            return (T)this;
        }

        public T initialAcceptFraction(double initialAcceptFraction) {
            this.initialAcceptFraction = initialAcceptFraction;
            return (T)this;
        }

        public T timeDecay(double timeDecay) {
            this.timeDecay = timeDecay;
            return (T)this;
        }
    }

    protected class ReplayableRandom {
        long randomSeed;
        Random testRandom;

        ReplayableRandom(long randomSeed) {
            this.randomSeed = randomSeed;
        }

        ReplayableRandom(Random random) {
            this.testRandom = random;
        }

        double nextDouble() {
            if (this.testRandom != null) {
                return this.testRandom.nextDouble();
            }
            Random newRandom = new Random(this.randomSeed);
            this.randomSeed = newRandom.nextLong();
            return newRandom.nextDouble();
        }
    }
}

