/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.inspect;

import com.amazon.randomcutforest.Visitor;
import com.amazon.randomcutforest.returntypes.Neighbor;
import com.amazon.randomcutforest.tree.INodeView;
import java.util.ArrayList;
import java.util.Optional;

public class NearNeighborVisitor
implements Visitor<Optional<Neighbor>> {
    private final double[] queryPoint;
    private final double distanceThreshold;
    private Neighbor neighbor;

    public NearNeighborVisitor(double[] queryPoint, double distanceThreshold) {
        this.queryPoint = queryPoint;
        this.distanceThreshold = distanceThreshold;
        this.neighbor = null;
    }

    public NearNeighborVisitor(double[] queryPoint) {
        this(queryPoint, Double.POSITIVE_INFINITY);
    }

    @Override
    public void accept(INodeView node, int depthOfNode) {
    }

    @Override
    public void acceptLeaf(INodeView leafNode, int depthOfNode) {
        double[] leafPoint = leafNode.getLiftedLeafPoint();
        double distanceSquared = 0.0;
        for (int i = 0; i < leafPoint.length; ++i) {
            double diff = this.queryPoint[i] - leafPoint[i];
            distanceSquared += diff * diff;
        }
        if (Math.sqrt(distanceSquared) < this.distanceThreshold) {
            ArrayList<Long> sequenceIndexes = new ArrayList<Long>(leafNode.getSequenceIndexes());
            this.neighbor = new Neighbor(leafPoint, Math.sqrt(distanceSquared), sequenceIndexes);
        }
    }

    @Override
    public Optional<Neighbor> getResult() {
        return Optional.ofNullable(this.neighbor);
    }
}

