/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.imputation;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.MultiVisitor;
import com.amazon.randomcutforest.tree.INodeView;
import java.util.Arrays;

public class ImputeVisitor
implements MultiVisitor<double[]> {
    public static double DEFAULT_INIT_VALUE = 4.4942328371557893E307;
    protected final boolean[] missing;
    protected final boolean[] liftedMissing;
    protected double[] queryPoint;
    protected double[] liftedPoint;
    protected double anomalyRank;
    protected double distance;
    protected double centrality;

    public ImputeVisitor(double[] liftedPoint, double[] queryPoint, int[] liftedMissingIndexes, int[] missingIndexes, double centrality) {
        int i;
        this.liftedPoint = Arrays.copyOf(liftedPoint, liftedPoint.length);
        this.queryPoint = Arrays.copyOf(queryPoint, queryPoint.length);
        this.missing = new boolean[queryPoint.length];
        this.liftedMissing = new boolean[liftedPoint.length];
        this.centrality = centrality;
        if (missingIndexes == null) {
            missingIndexes = new int[]{};
        }
        for (i = 0; i < missingIndexes.length; ++i) {
            CommonUtils.checkArgument(0 <= missingIndexes[i] && missingIndexes[i] < queryPoint.length, "Missing value indexes must be between 0 (inclusive) and queryPoint.length (exclusive)");
            this.missing[missingIndexes[i]] = true;
        }
        for (i = 0; i < liftedMissingIndexes.length; ++i) {
            CommonUtils.checkArgument(0 <= liftedMissingIndexes[i] && liftedMissingIndexes[i] < liftedPoint.length, "Missing value indexes must be between 0 (inclusive) and liftedPoint.length (exclusive)");
            this.liftedMissing[liftedMissingIndexes[i]] = true;
        }
        this.anomalyRank = DEFAULT_INIT_VALUE;
        this.distance = DEFAULT_INIT_VALUE;
    }

    public ImputeVisitor(double[] queryPoint, int numberOfMissingIndices, int[] missingIndexes) {
        this(queryPoint, Arrays.copyOf(queryPoint, queryPoint.length), Arrays.copyOf(missingIndexes, Math.min(numberOfMissingIndices, missingIndexes.length)), Arrays.copyOf(missingIndexes, Math.min(numberOfMissingIndices, missingIndexes.length)), 1.0);
    }

    ImputeVisitor(ImputeVisitor original) {
        int length = original.queryPoint.length;
        this.queryPoint = Arrays.copyOf(original.queryPoint, length);
        this.missing = Arrays.copyOf(original.missing, length);
        this.liftedPoint = Arrays.copyOf(original.liftedPoint, original.liftedPoint.length);
        this.liftedMissing = Arrays.copyOf(original.liftedMissing, original.liftedPoint.length);
        this.anomalyRank = DEFAULT_INIT_VALUE;
        this.distance = DEFAULT_INIT_VALUE;
    }

    @Override
    public void accept(INodeView node, int depthOfNode) {
        double probabilityOfSeparation = CommonUtils.getProbabilityOfSeparation(node.getBoundingBox(), this.queryPoint);
        if (probabilityOfSeparation <= 0.0) {
            return;
        }
        this.anomalyRank = probabilityOfSeparation * this.scoreUnseen(depthOfNode, node.getMass()) + (1.0 - probabilityOfSeparation) * this.anomalyRank;
    }

    @Override
    public void acceptLeaf(INodeView leafNode, int depthOfNode) {
        double[] leafPoint = leafNode.getLeafPoint();
        for (int i = 0; i < this.queryPoint.length; ++i) {
            if (!this.missing[i]) continue;
            this.queryPoint[i] = leafPoint[i];
        }
        double[] liftedLeafPoint = leafNode.getLiftedLeafPoint();
        double squaredDistance = 0.0;
        for (int i = 0; i < liftedLeafPoint.length; ++i) {
            if (this.liftedMissing[i]) {
                this.liftedPoint[i] = liftedLeafPoint[i];
                continue;
            }
            double t = liftedLeafPoint[i] - this.liftedPoint[i];
            squaredDistance += t * t;
        }
        this.distance = Math.sqrt(squaredDistance);
        double probabilityOfSeparation = CommonUtils.getProbabilityOfSeparation(leafNode.getBoundingBox(), this.queryPoint);
        this.anomalyRank = probabilityOfSeparation <= 0.0 ? (depthOfNode == 0 ? 0.0 : this.scoreSeen(depthOfNode, leafNode.getMass())) : this.scoreUnseen(depthOfNode, leafNode.getMass());
    }

    @Override
    public double[] getResult() {
        return this.liftedPoint;
    }

    @Override
    public boolean trigger(INodeView node) {
        return this.missing[node.getCutDimension()];
    }

    protected double getAnomalyRank() {
        return this.anomalyRank;
    }

    protected double getDistance() {
        return this.distance;
    }

    @Override
    public MultiVisitor<double[]> newCopy() {
        return new ImputeVisitor(this);
    }

    protected boolean updateCombine(ImputeVisitor other) {
        return other.anomalyRank < this.anomalyRank;
    }

    @Override
    public void combine(MultiVisitor<double[]> other) {
        ImputeVisitor visitor = (ImputeVisitor)other;
        if (this.updateCombine(visitor)) {
            this.updateFrom(visitor);
        }
    }

    protected void updateFrom(ImputeVisitor visitor) {
        System.arraycopy(visitor.queryPoint, 0, this.queryPoint, 0, this.queryPoint.length);
        System.arraycopy(visitor.liftedPoint, 0, this.liftedPoint, 0, this.liftedPoint.length);
        this.anomalyRank = visitor.anomalyRank;
        this.distance = visitor.distance;
    }

    protected double scoreSeen(int depth, int mass) {
        return CommonUtils.defaultScoreSeenFunction(depth, mass);
    }

    protected double scoreUnseen(int depth, int mass) {
        return CommonUtils.defaultScoreUnseenFunction(depth, mass);
    }
}

