/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.anomalydetection;

import com.amazon.randomcutforest.anomalydetection.DynamicScoreVisitor;
import com.amazon.randomcutforest.tree.IBoundingBoxView;
import com.amazon.randomcutforest.tree.INodeView;
import java.util.function.BiFunction;
import java.util.function.Function;

public class TransductiveScalarScoreVisitor
extends DynamicScoreVisitor {
    protected final Function<IBoundingBoxView, double[]> vecSepScore;

    public TransductiveScalarScoreVisitor(double[] pointToScore, int treeMass, BiFunction<Double, Double, Double> scoreSeen, BiFunction<Double, Double, Double> scoreUnseen, BiFunction<Double, Double, Double> damp, Function<IBoundingBoxView, double[]> vecSep) {
        super(pointToScore, treeMass, 0, scoreSeen, scoreUnseen, damp);
        this.vecSepScore = vecSep;
    }

    @Override
    public void accept(INodeView node, int depthOfNode) {
        if (this.pointInsideBox) {
            return;
        }
        double probabilityOfSeparation = this.getProbabilityOfSeparation(node.getBoundingBox());
        double weight = this.getWeight(node.getCutDimension(), this.vecSepScore, node.getBoundingBox());
        if (probabilityOfSeparation == 0.0) {
            this.pointInsideBox = true;
            return;
        }
        this.score = probabilityOfSeparation * this.scoreUnseen(depthOfNode, node.getMass()) + weight * this.score;
    }

    @Override
    protected double getProbabilityOfSeparation(IBoundingBoxView boundingBox) {
        double sumOfDenominator = 0.0;
        double sumOfNumerator = 0.0;
        double[] vec = this.vecSepScore.apply(boundingBox.getMergedBox(this.pointToScore));
        for (int i = 0; i < this.pointToScore.length; ++i) {
            double maxVal = boundingBox.getMaxValue(i);
            double minVal = boundingBox.getMinValue(i);
            double oldRange = maxVal - minVal;
            sumOfDenominator += vec[i];
            if (this.coordInsideBox[i]) continue;
            if (maxVal < this.pointToScore[i]) {
                maxVal = this.pointToScore[i];
            } else if (minVal > this.pointToScore[i]) {
                minVal = this.pointToScore[i];
            }
            double newRange = maxVal - minVal;
            if (newRange > oldRange) {
                sumOfNumerator += vec[i] * (newRange - oldRange) / newRange;
                continue;
            }
            this.coordInsideBox[i] = true;
        }
        if (sumOfDenominator <= 0.0) {
            throw new IllegalStateException("Incorrect State");
        }
        return sumOfNumerator / sumOfDenominator;
    }

    protected double getWeight(int dim, Function<IBoundingBoxView, double[]> vecSepBuild, IBoundingBoxView boundingBox) {
        double[] vecSmall = vecSepBuild.apply(boundingBox);
        IBoundingBoxView largeBox = boundingBox.getMergedBox(this.pointToScore);
        double[] vecLarge = this.vecSepScore.apply(largeBox);
        double sumSmall = 0.0;
        double sumLarge = 0.0;
        for (int i = 0; i < this.pointToScore.length; ++i) {
            sumSmall += vecSmall[i];
            sumLarge += vecLarge[i];
        }
        return boundingBox.getRange(dim) / largeBox.getRange(dim) * (sumSmall / sumLarge) * (vecLarge[dim] / vecSmall[dim]);
    }
}

