/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.ComponentList;
import com.amazon.randomcutforest.IMultiVisitorFactory;
import com.amazon.randomcutforest.IVisitorFactory;
import com.amazon.randomcutforest.VisitorFactory;
import com.amazon.randomcutforest.anomalydetection.AnomalyAttributionVisitor;
import com.amazon.randomcutforest.anomalydetection.AnomalyScoreVisitor;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.executor.AbstractForestTraversalExecutor;
import com.amazon.randomcutforest.executor.AbstractForestUpdateExecutor;
import com.amazon.randomcutforest.executor.IStateCoordinator;
import com.amazon.randomcutforest.executor.ITraversable;
import com.amazon.randomcutforest.executor.ParallelForestTraversalExecutor;
import com.amazon.randomcutforest.executor.ParallelForestUpdateExecutor;
import com.amazon.randomcutforest.executor.PassThroughCoordinator;
import com.amazon.randomcutforest.executor.PointStoreCoordinator;
import com.amazon.randomcutforest.executor.SamplerPlusTree;
import com.amazon.randomcutforest.executor.SequentialForestTraversalExecutor;
import com.amazon.randomcutforest.executor.SequentialForestUpdateExecutor;
import com.amazon.randomcutforest.imputation.ImputeVisitor;
import com.amazon.randomcutforest.inspect.NearNeighborVisitor;
import com.amazon.randomcutforest.interpolation.SimpleInterpolationVisitor;
import com.amazon.randomcutforest.returntypes.ConvergingAccumulator;
import com.amazon.randomcutforest.returntypes.DensityOutput;
import com.amazon.randomcutforest.returntypes.DiVector;
import com.amazon.randomcutforest.returntypes.InterpolationMeasure;
import com.amazon.randomcutforest.returntypes.Neighbor;
import com.amazon.randomcutforest.returntypes.OneSidedConvergingDiVectorAccumulator;
import com.amazon.randomcutforest.returntypes.OneSidedConvergingDoubleAccumulator;
import com.amazon.randomcutforest.sampler.AbstractStreamSampler;
import com.amazon.randomcutforest.sampler.CompactSampler;
import com.amazon.randomcutforest.sampler.SimpleStreamSampler;
import com.amazon.randomcutforest.store.IPointStore;
import com.amazon.randomcutforest.store.PointStoreDouble;
import com.amazon.randomcutforest.store.PointStoreFloat;
import com.amazon.randomcutforest.tree.CompactRandomCutTreeDouble;
import com.amazon.randomcutforest.tree.CompactRandomCutTreeFloat;
import com.amazon.randomcutforest.tree.RandomCutTree;
import com.amazon.randomcutforest.util.ArrayUtils;
import com.amazon.randomcutforest.util.ShingleBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;

public class RandomCutForest {
    public static final int DEFAULT_SAMPLE_SIZE = 256;
    public static final double DEFAULT_OUTPUT_AFTER_FRACTION = 0.25;
    public static final double DEFAULT_SAMPLE_SIZE_COEFFICIENT_IN_TIME_DECAY = 10.0;
    public static final int DEFAULT_NUMBER_OF_TREES = 50;
    public static final boolean DEFAULT_STORE_SEQUENCE_INDEXES_ENABLED = false;
    public static final boolean DEFAULT_COMPACT = true;
    public static final double DEFAULT_INITIAL_ACCEPT_FRACTION = 1.0;
    public static final boolean DEFAULT_DYNAMIC_RESIZING_ENABLED = true;
    public static final boolean DEFAULT_INTERNAL_SHINGLING_ENABLED = false;
    public static final boolean DEFAULT_INTERNAL_ROTATION_ENABLED = false;
    public static final boolean DEFAULT_DIRECT_LOCATION_MAP = false;
    public static final Precision DEFAULT_PRECISION = Precision.FLOAT_64;
    public static final double DEFAULT_BOUNDING_BOX_CACHE_FRACTION = 1.0;
    public static final boolean DEFAULT_CENTER_OF_MASS_ENABLED = false;
    public static final int DEFAULT_SHINGLE_SIZE = 1;
    public static final boolean DEFAULT_PARALLEL_EXECUTION_ENABLED = false;
    public static final boolean DEFAULT_APPROXIMATE_ANOMALY_SCORE_HIGH_IS_CRITICAL = true;
    public static final double DEFAULT_APPROXIMATE_DYNAMIC_SCORE_PRECISION = 0.1;
    public static final int DEFAULT_APPROXIMATE_DYNAMIC_SCORE_MIN_VALUES_ACCEPTED = 5;
    protected Random random;
    protected final int dimensions;
    protected final int sampleSize;
    protected final int shingleSize;
    protected final int inputDimensions;
    protected final int outputAfter;
    protected final int numberOfTrees;
    protected double timeDecay;
    protected final boolean storeSequenceIndexesEnabled;
    protected final boolean compact;
    protected final boolean internalShinglingEnabled;
    protected final Precision precision;
    protected final double boundingBoxCacheFraction;
    protected final boolean centerOfMassEnabled;
    protected final boolean parallelExecutionEnabled;
    protected final int threadPoolSize;
    protected String executionMode;
    protected IStateCoordinator<?, ?> stateCoordinator;
    protected ComponentList<?, ?> components;
    private boolean outputReady;
    private final int initialPointStoreSize;
    private final int pointStoreCapacity;
    protected AbstractForestTraversalExecutor traversalExecutor;
    protected AbstractForestUpdateExecutor<?, ?> updateExecutor;

    public <P, Q> RandomCutForest(Builder<?> builder, IStateCoordinator<P, Q> stateCoordinator, ComponentList<P, Q> components, Random random) {
        this(builder, false);
        CommonUtils.checkNotNull(stateCoordinator, "updateCoordinator must not be null");
        CommonUtils.checkNotNull(components, "componentModels must not be null");
        CommonUtils.checkNotNull(random, "random must not be null");
        this.stateCoordinator = stateCoordinator;
        this.components = components;
        this.random = random;
        this.initExecutors(stateCoordinator, components);
    }

    public RandomCutForest(Builder<?> builder) {
        this(builder, false);
        this.random = builder.getRandom();
        if (this.precision == Precision.FLOAT_32) {
            this.initCompactFloat(builder);
        } else if (this.compact) {
            this.initCompactDouble(builder);
        } else {
            this.initNonCompact();
        }
    }

    private void initCompactDouble(Builder<?> builder) {
        PointStoreDouble tempStore = ((PointStoreDouble.Builder)((PointStoreDouble.Builder)((PointStoreDouble.Builder)((PointStoreDouble.Builder)((PointStoreDouble.Builder)((PointStoreDouble.Builder)((PointStoreDouble.Builder)((PointStoreDouble.Builder)PointStoreDouble.builder().internalRotationEnabled(builder.internalRotationEnabled)).capacity(this.pointStoreCapacity)).initialSize(this.initialPointStoreSize)).directLocationEnabled(((Builder)builder).directLocationMapEnabled)).internalShinglingEnabled(this.internalShinglingEnabled)).dynamicResizingEnabled(builder.dynamicResizingEnabled)).shingleSize(this.shingleSize)).dimensions(this.dimensions)).build();
        PointStoreCoordinator<double[]> stateCoordinator = new PointStoreCoordinator<double[]>(tempStore);
        ComponentList components = new ComponentList(this.numberOfTrees);
        for (int i = 0; i < this.numberOfTrees; ++i) {
            CompactRandomCutTreeDouble tree = ((CompactRandomCutTreeDouble.Builder)((CompactRandomCutTreeDouble.Builder)((CompactRandomCutTreeDouble.Builder)((CompactRandomCutTreeDouble.Builder)((CompactRandomCutTreeDouble.Builder)((CompactRandomCutTreeDouble.Builder)new CompactRandomCutTreeDouble.Builder().maxSize(this.sampleSize)).randomSeed(this.random.nextLong())).pointStore(tempStore).boundingBoxCacheFraction(this.boundingBoxCacheFraction)).centerOfMassEnabled(this.centerOfMassEnabled)).storeSequenceIndexesEnabled(this.storeSequenceIndexesEnabled)).outputAfter(this.outputAfter)).build();
            CompactSampler sampler = ((CompactSampler.Builder)((AbstractStreamSampler.Builder)((CompactSampler.Builder)((CompactSampler.Builder)((CompactSampler.Builder)CompactSampler.builder().capacity(this.sampleSize)).timeDecay(this.timeDecay)).randomSeed(this.random.nextLong())).storeSequenceIndexesEnabled(this.storeSequenceIndexesEnabled)).initialAcceptFraction(builder.initialAcceptFraction)).build();
            components.add(new SamplerPlusTree<Integer, double[]>(sampler, tree));
        }
        this.stateCoordinator = stateCoordinator;
        this.components = components;
        this.initExecutors(stateCoordinator, components);
    }

    private void initCompactFloat(Builder<?> builder) {
        PointStoreFloat tempStore = ((PointStoreFloat.Builder)((PointStoreFloat.Builder)((PointStoreFloat.Builder)((PointStoreFloat.Builder)((PointStoreFloat.Builder)((PointStoreFloat.Builder)((PointStoreFloat.Builder)((PointStoreFloat.Builder)PointStoreFloat.builder().internalRotationEnabled(builder.internalRotationEnabled)).capacity(this.pointStoreCapacity)).initialSize(this.initialPointStoreSize)).directLocationEnabled(((Builder)builder).directLocationMapEnabled)).internalShinglingEnabled(this.internalShinglingEnabled)).dynamicResizingEnabled(builder.dynamicResizingEnabled)).shingleSize(this.shingleSize)).dimensions(this.dimensions)).build();
        PointStoreCoordinator<float[]> stateCoordinator = new PointStoreCoordinator<float[]>(tempStore);
        ComponentList components = new ComponentList(this.numberOfTrees);
        for (int i = 0; i < this.numberOfTrees; ++i) {
            CompactRandomCutTreeFloat tree = ((CompactRandomCutTreeFloat.Builder)((CompactRandomCutTreeFloat.Builder)((CompactRandomCutTreeFloat.Builder)((CompactRandomCutTreeFloat.Builder)((CompactRandomCutTreeFloat.Builder)((CompactRandomCutTreeFloat.Builder)new CompactRandomCutTreeFloat.Builder().maxSize(this.sampleSize)).randomSeed(this.random.nextLong())).pointStore(tempStore).boundingBoxCacheFraction(this.boundingBoxCacheFraction)).centerOfMassEnabled(this.centerOfMassEnabled)).storeSequenceIndexesEnabled(this.storeSequenceIndexesEnabled)).outputAfter(this.outputAfter)).build();
            CompactSampler sampler = ((CompactSampler.Builder)((AbstractStreamSampler.Builder)((CompactSampler.Builder)((CompactSampler.Builder)((CompactSampler.Builder)CompactSampler.builder().capacity(this.sampleSize)).timeDecay(this.timeDecay)).randomSeed(this.random.nextLong())).storeSequenceIndexesEnabled(this.storeSequenceIndexesEnabled)).initialAcceptFraction(builder.initialAcceptFraction)).build();
            components.add(new SamplerPlusTree<Integer, float[]>(sampler, tree));
        }
        this.stateCoordinator = stateCoordinator;
        this.components = components;
        this.initExecutors(stateCoordinator, components);
    }

    private void initNonCompact() {
        PassThroughCoordinator stateCoordinator = new PassThroughCoordinator();
        ComponentList components = new ComponentList(this.numberOfTrees);
        for (int i = 0; i < this.numberOfTrees; ++i) {
            RandomCutTree tree = ((RandomCutTree.Builder)((RandomCutTree.Builder)((RandomCutTree.Builder)((RandomCutTree.Builder)((RandomCutTree.Builder)RandomCutTree.builder().randomSeed(this.random.nextLong())).boundingBoxCacheFraction(this.boundingBoxCacheFraction)).centerOfMassEnabled(this.centerOfMassEnabled)).storeSequenceIndexesEnabled(this.storeSequenceIndexesEnabled)).outputAfter(this.outputAfter)).build();
            SimpleStreamSampler sampler = ((SimpleStreamSampler.Builder)((SimpleStreamSampler.Builder)((SimpleStreamSampler.Builder)SimpleStreamSampler.builder().capacity(this.sampleSize)).timeDecay(this.timeDecay)).randomSeed(this.random.nextLong())).build();
            components.add(new SamplerPlusTree<double[], double[]>(sampler, tree));
        }
        this.stateCoordinator = stateCoordinator;
        this.components = components;
        this.initExecutors(stateCoordinator, components);
    }

    protected <PointReference, Point> void initExecutors(IStateCoordinator<PointReference, Point> updateCoordinator, ComponentList<PointReference, Point> components) {
        if (this.parallelExecutionEnabled) {
            this.traversalExecutor = new ParallelForestTraversalExecutor(components, this.threadPoolSize);
            this.updateExecutor = new ParallelForestUpdateExecutor(updateCoordinator, components, this.threadPoolSize);
        } else {
            this.traversalExecutor = new SequentialForestTraversalExecutor(components);
            this.updateExecutor = new SequentialForestUpdateExecutor(updateCoordinator, components);
        }
    }

    protected RandomCutForest(Builder<?> builder, boolean notUsed) {
        CommonUtils.checkArgument(((Builder)builder).numberOfTrees > 0, "numberOfTrees must be greater than 0");
        CommonUtils.checkArgument(((Builder)builder).sampleSize > 0, "sampleSize must be greater than 0");
        ((Builder)builder).outputAfter.ifPresent(n -> {
            CommonUtils.checkArgument(n > 0, "outputAfter must be greater than 0");
            CommonUtils.checkArgument(n <= ((Builder)builder).sampleSize, "outputAfter must be smaller or equal to sampleSize");
        });
        CommonUtils.checkArgument(((Builder)builder).dimensions > 0, "dimensions must be greater than 0");
        ((Builder)builder).timeDecay.ifPresent(timeDecay -> CommonUtils.checkArgument(timeDecay >= 0.0, "timeDecay must be greater than or equal to 0"));
        ((Builder)builder).threadPoolSize.ifPresent(n -> CommonUtils.checkArgument(n > 0 || n == 0 && !((Builder)builder).parallelExecutionEnabled, "threadPoolSize must be greater/equal than 0. To disable thread pool, set parallel execution to 'false'."));
        CommonUtils.checkArgument(((Builder)builder).precision == Precision.FLOAT_64 || ((Builder)builder).compact, "single precision is only supported for compact trees");
        CommonUtils.checkArgument(((Builder)builder).internalShinglingEnabled || ((Builder)builder).shingleSize == 1 || ((Builder)builder).dimensions % ((Builder)builder).shingleSize == 0, "wrong shingle size");
        if (builder.internalRotationEnabled) {
            CommonUtils.checkArgument(((Builder)builder).internalShinglingEnabled, " enable internal shingling");
            CommonUtils.checkArgument(((Builder)builder).compact, " option not supported, enable compact trees");
        }
        builder.initialPointStoreSize.ifPresent(n -> {
            CommonUtils.checkArgument(n > 0, "initial point store must be greater than 0");
            CommonUtils.checkArgument(n > ((Builder)builder).sampleSize * ((Builder)builder).numberOfTrees || builder.dynamicResizingEnabled, " enable dynamic resizing ");
            CommonUtils.checkArgument(((Builder)builder).compact, " enable compact trees ");
        });
        CommonUtils.checkArgument(((Builder)builder).boundingBoxCacheFraction >= 0.0 && ((Builder)builder).boundingBoxCacheFraction <= 1.0, "incorrect cache fraction range");
        this.numberOfTrees = ((Builder)builder).numberOfTrees;
        this.sampleSize = ((Builder)builder).sampleSize;
        this.outputAfter = ((Builder)builder).outputAfter.orElse((int)((double)this.sampleSize * 0.25));
        this.internalShinglingEnabled = ((Builder)builder).internalShinglingEnabled;
        this.shingleSize = ((Builder)builder).shingleSize;
        this.dimensions = ((Builder)builder).dimensions;
        this.timeDecay = ((Builder)builder).timeDecay.orElse(1.0 / (10.0 * (double)this.sampleSize));
        this.storeSequenceIndexesEnabled = ((Builder)builder).storeSequenceIndexesEnabled;
        this.centerOfMassEnabled = ((Builder)builder).centerOfMassEnabled;
        this.parallelExecutionEnabled = ((Builder)builder).parallelExecutionEnabled;
        this.compact = ((Builder)builder).compact;
        this.precision = ((Builder)builder).precision;
        this.boundingBoxCacheFraction = ((Builder)builder).boundingBoxCacheFraction;
        ((Builder)builder).directLocationMapEnabled = ((Builder)builder).directLocationMapEnabled || this.shingleSize == 1;
        this.inputDimensions = this.internalShinglingEnabled ? this.dimensions / this.shingleSize : this.dimensions;
        this.pointStoreCapacity = this.sampleSize * this.numberOfTrees + 1;
        this.initialPointStoreSize = builder.initialPointStoreSize.orElse(Math.min(2 * this.sampleSize, this.pointStoreCapacity));
        this.threadPoolSize = this.parallelExecutionEnabled ? ((Builder)builder).threadPoolSize.orElse(Runtime.getRuntime().availableProcessors() - 1) : 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RandomCutForest defaultForest(int dimensions, long randomSeed) {
        return ((Builder)((Builder)RandomCutForest.builder().dimensions(dimensions)).randomSeed(randomSeed)).build();
    }

    public static RandomCutForest defaultForest(int dimensions) {
        return ((Builder)RandomCutForest.builder().dimensions(dimensions)).build();
    }

    public int getNumberOfTrees() {
        return this.numberOfTrees;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public int getShingleSize() {
        return this.shingleSize;
    }

    public int getOutputAfter() {
        return this.outputAfter;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public double getTimeDecay() {
        return this.timeDecay;
    }

    public boolean isStoreSequenceIndexesEnabled() {
        return this.storeSequenceIndexesEnabled;
    }

    public Precision getPrecision() {
        return this.precision;
    }

    public boolean isCompact() {
        return this.compact;
    }

    public boolean isInternalShinglingEnabled() {
        return this.internalShinglingEnabled;
    }

    public boolean isCenterOfMassEnabled() {
        return this.centerOfMassEnabled;
    }

    public boolean isParallelExecutionEnabled() {
        return this.parallelExecutionEnabled;
    }

    public double getBoundingBoxCacheFraction() {
        return this.boundingBoxCacheFraction;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public IStateCoordinator<?, ?> getUpdateCoordinator() {
        return this.stateCoordinator;
    }

    public ComponentList<?, ?> getComponents() {
        return this.components;
    }

    public double[] transformToShingledPoint(double[] point) {
        CommonUtils.checkNotNull(point, "point must not be null");
        return this.internalShinglingEnabled && point.length == this.inputDimensions ? this.stateCoordinator.getStore().transformToShingledPoint(point) : ArrayUtils.cleanCopy(point);
    }

    public boolean isRotationEnabled() {
        return this.stateCoordinator.getStore().isInternalRotationEnabled();
    }

    protected int[] transformIndices(int[] indexList, int length) {
        return this.internalShinglingEnabled && length == this.inputDimensions ? this.stateCoordinator.getStore().transformIndices(indexList) : indexList;
    }

    public double[] lastShingledPoint() {
        CommonUtils.checkArgument(this.internalShinglingEnabled, "incorrect use");
        return this.stateCoordinator.getStore().getInternalShingle();
    }

    public long nextSequenceIndex() {
        CommonUtils.checkArgument(this.internalShinglingEnabled, "incorrect use");
        return this.stateCoordinator.getStore().getNextSequenceIndex();
    }

    public void update(double[] point) {
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkArgument(this.internalShinglingEnabled || point.length == this.dimensions, String.format("point.length must equal %d", this.dimensions));
        CommonUtils.checkArgument(!this.internalShinglingEnabled || point.length == this.inputDimensions, String.format("point.length must equal %d for internal shingling", this.inputDimensions));
        this.updateExecutor.update(point);
    }

    public void update(double[] point, long sequenceNum) {
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkArgument(!this.internalShinglingEnabled, "cannot be applied with internal shingling");
        CommonUtils.checkArgument(point.length == this.dimensions, String.format("point.length must equal %d", this.dimensions));
        this.updateExecutor.update(point, sequenceNum);
    }

    public void setBoundingBoxCacheFraction(double cacheFraction) {
        CommonUtils.checkArgument(0.0 <= cacheFraction && cacheFraction <= 1.0, "cacheFraction must be between 0 and 1 (inclusive)");
        this.updateExecutor.getComponents().forEach(c -> c.setConfig("bounding_box_cache_fraction", cacheFraction));
    }

    public void setTimeDecay(double timeDecay) {
        CommonUtils.checkArgument(0.0 <= timeDecay, "timeDecay must be greater than or equal to 0");
        this.timeDecay = timeDecay;
        this.updateExecutor.getComponents().forEach(c -> c.setConfig("time_decay", timeDecay));
    }

    public <R, S> S traverseForest(double[] point, IVisitorFactory<R> visitorFactory, BinaryOperator<R> accumulator, Function<R, S> finisher) {
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkArgument(point.length == this.dimensions, String.format("point.length must equal %d", this.dimensions));
        CommonUtils.checkNotNull(visitorFactory, "visitorFactory must not be null");
        CommonUtils.checkNotNull(accumulator, "accumulator must not be null");
        CommonUtils.checkNotNull(finisher, "finisher must not be null");
        return this.traversalExecutor.traverseForest(point, visitorFactory, accumulator, finisher);
    }

    public <R, S> S traverseForest(double[] point, IVisitorFactory<R> visitorFactory, Collector<R, ?, S> collector) {
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkArgument(point.length == this.dimensions, String.format("point.length must equal %d", this.dimensions));
        CommonUtils.checkNotNull(visitorFactory, "visitorFactory must not be null");
        CommonUtils.checkNotNull(collector, "collector must not be null");
        return this.traversalExecutor.traverseForest(point, visitorFactory, collector);
    }

    public <R, S> S traverseForest(double[] point, IVisitorFactory<R> visitorFactory, ConvergingAccumulator<R> accumulator, Function<R, S> finisher) {
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkArgument(point.length == this.dimensions, String.format("point.length must equal %d", this.dimensions));
        CommonUtils.checkNotNull(visitorFactory, "visitorFactory must not be null");
        CommonUtils.checkNotNull(accumulator, "accumulator must not be null");
        CommonUtils.checkNotNull(finisher, "finisher must not be null");
        return this.traversalExecutor.traverseForest(point, visitorFactory, accumulator, finisher);
    }

    public <R, S> S traverseForestMulti(double[] point, IMultiVisitorFactory<R> visitorFactory, BinaryOperator<R> accumulator, Function<R, S> finisher) {
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkArgument(point.length == this.dimensions, String.format("point.length must equal %d", this.dimensions));
        CommonUtils.checkNotNull(visitorFactory, "visitorFactory must not be null");
        CommonUtils.checkNotNull(accumulator, "accumulator must not be null");
        CommonUtils.checkNotNull(finisher, "finisher must not be null");
        return this.traversalExecutor.traverseForestMulti(point, visitorFactory, accumulator, finisher);
    }

    public <R, S> S traverseForestMulti(double[] point, IMultiVisitorFactory<R> visitorFactory, Collector<R, ?, S> collector) {
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkArgument(point.length == this.dimensions, String.format("point.length must equal %d", this.dimensions));
        CommonUtils.checkNotNull(visitorFactory, "visitorFactory must not be null");
        CommonUtils.checkNotNull(collector, "collector must not be null");
        return this.traversalExecutor.traverseForestMulti(point, visitorFactory, collector);
    }

    public double getAnomalyScore(double[] point) {
        if (!this.isOutputReady()) {
            return 0.0;
        }
        IVisitorFactory visitorFactory = (tree, x) -> new AnomalyScoreVisitor(tree.projectToTree(x), tree.getMass());
        BinaryOperator accumulator = Double::sum;
        Function<Double, Double> finisher = x -> x / (double)this.numberOfTrees;
        return this.traverseForest(this.transformToShingledPoint(point), visitorFactory, accumulator, finisher);
    }

    public double getApproximateAnomalyScore(double[] point) {
        if (!this.isOutputReady()) {
            return 0.0;
        }
        IVisitorFactory visitorFactory = (tree, x) -> new AnomalyScoreVisitor(tree.projectToTree(x), tree.getMass());
        OneSidedConvergingDoubleAccumulator accumulator = new OneSidedConvergingDoubleAccumulator(true, 0.1, 5, this.numberOfTrees);
        Function<Double, Double> finisher = x -> x / (double)accumulator.getValuesAccepted();
        return this.traverseForest(this.transformToShingledPoint(point), visitorFactory, accumulator, finisher);
    }

    public DiVector getAnomalyAttribution(double[] point) {
        if (!this.isOutputReady()) {
            return new DiVector(this.dimensions);
        }
        VisitorFactory<DiVector> visitorFactory = new VisitorFactory<DiVector>((tree, y) -> new AnomalyAttributionVisitor(tree.projectToTree((double[])y), tree.getMass()), (tree, x) -> x.lift(tree::liftFromTree));
        BinaryOperator accumulator = DiVector::addToLeft;
        Function<DiVector, DiVector> finisher = x -> x.scale(1.0 / (double)this.numberOfTrees);
        return this.traverseForest(this.transformToShingledPoint(point), visitorFactory, accumulator, finisher);
    }

    public DiVector getApproximateAnomalyAttribution(double[] point) {
        if (!this.isOutputReady()) {
            return new DiVector(this.dimensions);
        }
        VisitorFactory<DiVector> visitorFactory = new VisitorFactory<DiVector>((tree, y) -> new AnomalyAttributionVisitor(tree.projectToTree((double[])y), tree.getMass()), (tree, x) -> x.lift(tree::liftFromTree));
        OneSidedConvergingDiVectorAccumulator accumulator = new OneSidedConvergingDiVectorAccumulator(this.dimensions, true, 0.1, 5, this.numberOfTrees);
        Function<DiVector, DiVector> finisher = x -> x.scale(1.0 / (double)accumulator.getValuesAccepted());
        return this.traverseForest(this.transformToShingledPoint(point), visitorFactory, accumulator, finisher);
    }

    public DensityOutput getSimpleDensity(double[] point) {
        if (!this.samplersFull()) {
            return new DensityOutput(this.dimensions, this.sampleSize);
        }
        VisitorFactory<InterpolationMeasure> visitorFactory = new VisitorFactory<InterpolationMeasure>((tree, y) -> new SimpleInterpolationVisitor(tree.projectToTree((double[])y), this.sampleSize, 1.0, this.centerOfMassEnabled), (tree, x) -> x.lift(tree::liftFromTree));
        Collector<InterpolationMeasure, InterpolationMeasure, InterpolationMeasure> collector = InterpolationMeasure.collector(this.dimensions, this.sampleSize, this.numberOfTrees);
        return new DensityOutput(this.traverseForest(this.transformToShingledPoint(point), visitorFactory, collector));
    }

    public List<double[]> getConditionalField(double[] point, int numberOfMissingValues, int[] missingIndexes, double centrality) {
        CommonUtils.checkArgument(numberOfMissingValues > 0, "numberOfMissingValues must be greater than 0");
        CommonUtils.checkNotNull(missingIndexes, "missingIndexes must not be null");
        CommonUtils.checkArgument(numberOfMissingValues <= missingIndexes.length, "numberOfMissingValues must be less than or equal to missingIndexes.length");
        CommonUtils.checkArgument(centrality >= 0.0 && centrality <= 1.0, "centrality needs to be in range [0,1]");
        if (!this.isOutputReady()) {
            return new ArrayList<double[]>();
        }
        int[] liftedIndices = this.transformIndices(missingIndexes, point.length);
        IMultiVisitorFactory visitorFactory = (tree, y) -> new ImputeVisitor(y, tree.projectToTree(y), liftedIndices, tree.projectMissingIndices(liftedIndices), 1.0);
        Collector<double[], ArrayList, ArrayList> collector = Collector.of(ArrayList::new, ArrayList::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, list -> list, new Collector.Characteristics[0]);
        return this.traverseForestMulti(this.transformToShingledPoint(point), visitorFactory, collector);
    }

    public double[] imputeMissingValues(double[] point, int numberOfMissingValues, int[] missingIndexes) {
        CommonUtils.checkArgument(numberOfMissingValues >= 0, "numberOfMissingValues must be greater or equal than 0");
        CommonUtils.checkNotNull(missingIndexes, "missingIndexes must not be null");
        CommonUtils.checkArgument(numberOfMissingValues <= missingIndexes.length, "numberOfMissingValues must be less than or equal to missingIndexes.length");
        CommonUtils.checkArgument(point != null, " cannot be null");
        if (!this.isOutputReady()) {
            return new double[this.dimensions];
        }
        List<double[]> conditionalField = this.getConditionalField(point, numberOfMissingValues, missingIndexes, 1.0);
        if (numberOfMissingValues == 1) {
            double[] returnPoint = Arrays.copyOf(point, point.length);
            double[] basicList = conditionalField.stream().mapToDouble(array -> array[this.transformIndices(missingIndexes, point.length)[0]]).sorted().toArray();
            returnPoint[missingIndexes[0]] = basicList[this.numberOfTrees / 2];
            return returnPoint;
        }
        conditionalField.sort(Comparator.comparing(this::getAnomalyScore));
        return conditionalField.get(this.numberOfTrees / 4);
    }

    public double[] extrapolateBasic(double[] point, int horizon, int blockSize, boolean cyclic, int shingleIndex) {
        CommonUtils.checkArgument(0 < blockSize && blockSize < this.dimensions, "blockSize must be between 0 and dimensions (exclusive)");
        CommonUtils.checkArgument(this.dimensions % blockSize == 0, "dimensions must be evenly divisible by blockSize");
        CommonUtils.checkArgument(0 <= shingleIndex && shingleIndex < this.dimensions / blockSize, "shingleIndex must be between 0 (inclusive) and dimensions / blockSize");
        double[] result = new double[blockSize * horizon];
        int[] missingIndexes = new int[blockSize];
        double[] queryPoint = Arrays.copyOf(point, this.dimensions);
        if (cyclic) {
            this.extrapolateBasicCyclic(result, horizon, blockSize, shingleIndex, queryPoint, missingIndexes);
        } else {
            this.extrapolateBasicSliding(result, horizon, blockSize, queryPoint, missingIndexes);
        }
        return result;
    }

    public double[] extrapolateBasic(double[] point, int horizon, int blockSize, boolean cyclic) {
        return this.extrapolateBasic(point, horizon, blockSize, cyclic, 0);
    }

    public double[] extrapolateBasic(ShingleBuilder builder, int horizon) {
        return this.extrapolateBasic(builder.getShingle(), horizon, builder.getInputPointSize(), builder.isCyclic(), builder.getShingleIndex());
    }

    void extrapolateBasicSliding(double[] result, int horizon, int blockSize, double[] queryPoint, int[] missingIndexes) {
        int resultIndex = 0;
        Arrays.fill(missingIndexes, 0);
        for (int y = 0; y < blockSize; ++y) {
            missingIndexes[y] = this.dimensions - blockSize + y;
        }
        for (int k = 0; k < horizon; ++k) {
            System.arraycopy(queryPoint, blockSize, queryPoint, 0, this.dimensions - blockSize);
            double[] imputedPoint = this.imputeMissingValues(queryPoint, blockSize, missingIndexes);
            for (int y = 0; y < blockSize; ++y) {
                int n = resultIndex++;
                double d = imputedPoint[this.dimensions - blockSize + y];
                queryPoint[this.dimensions - blockSize + y] = d;
                result[n] = d;
            }
        }
    }

    void extrapolateBasicCyclic(double[] result, int horizon, int blockSize, int shingleIndex, double[] queryPoint, int[] missingIndexes) {
        int resultIndex = 0;
        int currentPosition = shingleIndex;
        Arrays.fill(missingIndexes, 0);
        for (int k = 0; k < horizon; ++k) {
            for (int y = 0; y < blockSize; ++y) {
                missingIndexes[y] = (currentPosition + y) % this.dimensions;
            }
            double[] imputedPoint = this.imputeMissingValues(queryPoint, blockSize, missingIndexes);
            for (int y = 0; y < blockSize; ++y) {
                int n = resultIndex++;
                double d = imputedPoint[(currentPosition + y) % this.dimensions];
                queryPoint[(currentPosition + y) % this.dimensions] = d;
                result[n] = d;
            }
            currentPosition = (currentPosition + blockSize) % this.dimensions;
        }
    }

    public double[] extrapolate(int horizon) {
        CommonUtils.checkArgument(this.internalShinglingEnabled, "incorrect use");
        IPointStore<?> store = this.stateCoordinator.getStore();
        return this.extrapolateBasic(this.lastShingledPoint(), horizon, this.inputDimensions, store.isInternalRotationEnabled(), (int)this.nextSequenceIndex() % this.dimensions);
    }

    public List<Neighbor> getNearNeighborsInSample(double[] point, double distanceThreshold) {
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkArgument(distanceThreshold > 0.0, "distanceThreshold must be greater than 0");
        if (!this.isOutputReady()) {
            return Collections.emptyList();
        }
        IVisitorFactory visitorFactory = (tree, x) -> new NearNeighborVisitor(x, distanceThreshold);
        return this.traverseForest(this.transformToShingledPoint(point), visitorFactory, Neighbor.collector());
    }

    public List<Neighbor> getNearNeighborsInSample(double[] point) {
        return this.getNearNeighborsInSample(point, Double.POSITIVE_INFINITY);
    }

    public boolean isOutputReady() {
        return this.outputReady || (this.outputReady = this.components.stream().allMatch(ITraversable::isOutputReady));
    }

    public boolean samplersFull() {
        return this.stateCoordinator.getTotalUpdates() >= (long)this.sampleSize;
    }

    public long getTotalUpdates() {
        return this.stateCoordinator.getTotalUpdates();
    }

    public static class Builder<T extends Builder<T>> {
        private int dimensions;
        private int sampleSize = 256;
        private Optional<Integer> outputAfter = Optional.empty();
        private int numberOfTrees = 50;
        private Optional<Double> timeDecay = Optional.empty();
        private Optional<Long> randomSeed = Optional.empty();
        private boolean compact = true;
        private boolean storeSequenceIndexesEnabled = false;
        private boolean centerOfMassEnabled = false;
        private boolean parallelExecutionEnabled = false;
        private Optional<Integer> threadPoolSize = Optional.empty();
        private boolean directLocationMapEnabled = false;
        private Precision precision = DEFAULT_PRECISION;
        private double boundingBoxCacheFraction = 1.0;
        private int shingleSize = 1;
        protected boolean dynamicResizingEnabled = true;
        private boolean internalShinglingEnabled = false;
        protected boolean internalRotationEnabled = false;
        protected Optional<Integer> initialPointStoreSize = Optional.empty();
        protected double initialAcceptFraction = 1.0;

        public T dimensions(int dimensions) {
            this.dimensions = dimensions;
            return (T)this;
        }

        public T sampleSize(int sampleSize) {
            this.sampleSize = sampleSize;
            return (T)this;
        }

        public T outputAfter(int outputAfter) {
            this.outputAfter = Optional.of(outputAfter);
            return (T)this;
        }

        public T numberOfTrees(int numberOfTrees) {
            this.numberOfTrees = numberOfTrees;
            return (T)this;
        }

        public T shingleSize(int shingleSize) {
            this.shingleSize = shingleSize;
            return (T)this;
        }

        public T timeDecay(double timeDecay) {
            this.timeDecay = Optional.of(timeDecay);
            return (T)this;
        }

        public T randomSeed(long randomSeed) {
            this.randomSeed = Optional.of(randomSeed);
            return (T)this;
        }

        public T centerOfMassEnabled(boolean centerOfMassEnabled) {
            this.centerOfMassEnabled = centerOfMassEnabled;
            return (T)this;
        }

        public T parallelExecutionEnabled(boolean parallelExecutionEnabled) {
            this.parallelExecutionEnabled = parallelExecutionEnabled;
            return (T)this;
        }

        public T threadPoolSize(int threadPoolSize) {
            this.threadPoolSize = Optional.of(threadPoolSize);
            return (T)this;
        }

        public T initialPointStoreSize(int initialPointStoreSize) {
            this.initialPointStoreSize = Optional.of(initialPointStoreSize);
            return (T)this;
        }

        public T storeSequenceIndexesEnabled(boolean storeSequenceIndexesEnabled) {
            this.storeSequenceIndexesEnabled = storeSequenceIndexesEnabled;
            return (T)this;
        }

        public T compact(boolean compact) {
            this.compact = compact;
            return (T)this;
        }

        public T internalShinglingEnabled(boolean internalShinglingEnabled) {
            this.internalShinglingEnabled = internalShinglingEnabled;
            return (T)this;
        }

        public T internalRotationEnabled(boolean internalRotationEnabled) {
            this.internalRotationEnabled = internalRotationEnabled;
            return (T)this;
        }

        public T dynamicResizingEnabled(boolean dynamicResizingEnabled) {
            this.dynamicResizingEnabled = dynamicResizingEnabled;
            return (T)this;
        }

        public T precision(Precision precision) {
            this.precision = precision;
            return (T)this;
        }

        public T boundingBoxCacheFraction(double boundingBoxCacheFraction) {
            this.boundingBoxCacheFraction = boundingBoxCacheFraction;
            return (T)this;
        }

        public T initialAcceptFraction(double initialAcceptFraction) {
            this.initialAcceptFraction = initialAcceptFraction;
            return (T)this;
        }

        public RandomCutForest build() {
            return new RandomCutForest(this);
        }

        public Random getRandom() {
            return this.randomSeed.map(Random::new).orElseGet(Random::new);
        }
    }
}

