/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.VisitorFactory;
import com.amazon.randomcutforest.anomalydetection.DynamicAttributionVisitor;
import com.amazon.randomcutforest.anomalydetection.DynamicScoreVisitor;
import com.amazon.randomcutforest.anomalydetection.SimulatedTransductiveScalarScoreVisitor;
import com.amazon.randomcutforest.returntypes.DiVector;
import com.amazon.randomcutforest.returntypes.OneSidedConvergingDiVectorAccumulator;
import com.amazon.randomcutforest.returntypes.OneSidedConvergingDoubleAccumulator;
import com.amazon.randomcutforest.tree.IBoundingBoxView;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;

public class DynamicScoringRandomCutForest
extends RandomCutForest {
    public static Builder builder() {
        return new Builder();
    }

    protected DynamicScoringRandomCutForest(Builder builder) {
        super(builder);
    }

    public static DynamicScoringRandomCutForest defaultForest(int dimensions, long randomSeed) {
        return ((Builder)((Builder)DynamicScoringRandomCutForest.builder().dimensions(dimensions)).randomSeed(randomSeed)).build();
    }

    public static DynamicScoringRandomCutForest defaultForest(int dimensions) {
        return ((Builder)DynamicScoringRandomCutForest.builder().dimensions(dimensions)).build();
    }

    public double getDynamicScore(double[] point, int ignoreLeafMassThreshold, BiFunction<Double, Double, Double> seen, BiFunction<Double, Double, Double> unseen, BiFunction<Double, Double, Double> damp) {
        CommonUtils.checkArgument(ignoreLeafMassThreshold >= 0, "ignoreLeafMassThreshold should be greater than or equal to 0");
        if (!this.isOutputReady()) {
            return 0.0;
        }
        VisitorFactory visitorFactory = new VisitorFactory((tree, y) -> new DynamicScoreVisitor(tree.projectToTree((double[])y), tree.getMass(), ignoreLeafMassThreshold, seen, unseen, damp));
        BinaryOperator accumulator = Double::sum;
        Function<Double, Double> finisher = sum -> sum / (double)this.numberOfTrees;
        return this.traverseForest(point, visitorFactory, accumulator, finisher);
    }

    public double getDynamicSimulatedScore(double[] point, BiFunction<Double, Double, Double> seen, BiFunction<Double, Double, Double> unseen, BiFunction<Double, Double, Double> damp, Function<IBoundingBoxView, double[]> vecSep) {
        if (!this.isOutputReady()) {
            return 0.0;
        }
        VisitorFactory visitorFactory = new VisitorFactory((tree, y) -> new SimulatedTransductiveScalarScoreVisitor(tree.projectToTree((double[])y), tree.getMass(), seen, unseen, damp, CommonUtils::defaultRCFgVecFunction, vecSep));
        BinaryOperator accumulator = Double::sum;
        Function<Double, Double> finisher = sum -> sum / (double)this.numberOfTrees;
        return this.traverseForest(point, visitorFactory, accumulator, finisher);
    }

    public double getApproximateDynamicScore(double[] point, double precision, boolean highIsCritical, int ignoreLeafMassThreshold, BiFunction<Double, Double, Double> seen, BiFunction<Double, Double, Double> unseen, BiFunction<Double, Double, Double> damp) {
        CommonUtils.checkArgument(ignoreLeafMassThreshold >= 0, "ignoreLeafMassThreshold should be greater than or equal to 0");
        if (!this.isOutputReady()) {
            return 0.0;
        }
        VisitorFactory visitorFactory = new VisitorFactory((tree, y) -> new DynamicScoreVisitor(tree.projectToTree((double[])y), tree.getMass(), ignoreLeafMassThreshold, seen, unseen, damp));
        OneSidedConvergingDoubleAccumulator accumulator = new OneSidedConvergingDoubleAccumulator(highIsCritical, precision, 5, this.numberOfTrees);
        Function<Double, Double> finisher = x -> x / (double)accumulator.getValuesAccepted();
        return this.traverseForest(point, visitorFactory, accumulator, finisher);
    }

    public DiVector getDynamicAttribution(double[] point, int ignoreLeafMassThreshold, BiFunction<Double, Double, Double> seen, BiFunction<Double, Double, Double> unseen, BiFunction<Double, Double, Double> newDamp) {
        if (!this.isOutputReady()) {
            return new DiVector(this.dimensions);
        }
        VisitorFactory<DiVector> visitorFactory = new VisitorFactory<DiVector>((tree, y) -> new DynamicAttributionVisitor(tree.projectToTree((double[])y), tree.getMass(), ignoreLeafMassThreshold, seen, unseen, newDamp), (tree, x) -> x.lift(tree::liftFromTree));
        BinaryOperator accumulator = DiVector::addToLeft;
        Function<DiVector, DiVector> finisher = x -> x.scale(1.0 / (double)this.numberOfTrees);
        return this.traverseForest(point, visitorFactory, accumulator, finisher);
    }

    public DiVector getApproximateDynamicAttribution(double[] point, double precision, boolean highIsCritical, int ignoreLeafMassThreshold, BiFunction<Double, Double, Double> seen, BiFunction<Double, Double, Double> unseen, BiFunction<Double, Double, Double> newDamp) {
        if (!this.isOutputReady()) {
            return new DiVector(this.dimensions);
        }
        VisitorFactory<DiVector> visitorFactory = new VisitorFactory<DiVector>((tree, y) -> new DynamicAttributionVisitor((double[])y, tree.getMass(), ignoreLeafMassThreshold, seen, unseen, newDamp), (tree, x) -> x.lift(tree::liftFromTree));
        OneSidedConvergingDiVectorAccumulator accumulator = new OneSidedConvergingDiVectorAccumulator(this.dimensions, highIsCritical, precision, 5, this.numberOfTrees);
        Function<DiVector, DiVector> finisher = vector -> vector.scale(1.0 / (double)accumulator.getValuesAccepted());
        return this.traverseForest(point, visitorFactory, accumulator, finisher);
    }

    public static class Builder
    extends RandomCutForest.Builder<Builder> {
        @Override
        public DynamicScoringRandomCutForest build() {
            return new DynamicScoringRandomCutForest(this);
        }
    }
}

