/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest;

import com.amazon.randomcutforest.tree.IBoundingBoxView;
import java.util.Objects;

public class CommonUtils {
    private CommonUtils() {
    }

    public static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    public static void validateInternalState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    public static <T> T checkNotNull(T object, String message) {
        Objects.requireNonNull(object, message);
        return object;
    }

    public static double getProbabilityOfSeparation(IBoundingBoxView boundingBox, double[] queryPoint) {
        double sumOfNewRange = 0.0;
        double sumOfDifferenceInRange = 0.0;
        for (int i = 0; i < queryPoint.length; ++i) {
            double maxVal = boundingBox.getMaxValue(i);
            double minVal = boundingBox.getMinValue(i);
            double oldRange = maxVal - minVal;
            if (maxVal < queryPoint[i]) {
                maxVal = queryPoint[i];
            } else if (minVal > queryPoint[i]) {
                minVal = queryPoint[i];
            } else {
                sumOfNewRange += oldRange;
                continue;
            }
            double newRange = maxVal - minVal;
            sumOfNewRange += newRange;
            sumOfDifferenceInRange += newRange - oldRange;
        }
        if (sumOfNewRange <= 0.0) {
            return 0.0;
        }
        return sumOfDifferenceInRange / sumOfNewRange;
    }

    public static double defaultScoreSeenFunction(double depth, double mass) {
        return 1.0 / (depth + Math.log(mass + 1.0) / Math.log(2.0));
    }

    public static double defaultScoreUnseenFunction(double depth, double mass) {
        return 1.0 / (depth + 1.0);
    }

    public static double defaultDampFunction(double leafMass, double treeMass) {
        return 1.0 - leafMass / (2.0 * treeMass);
    }

    public static double defaultScalarNormalizerFunction(double scalarValue, double mass) {
        return scalarValue * Math.log(mass + 1.0) / Math.log(2.0);
    }

    public static double[] defaultRCFgVecFunction(IBoundingBoxView boundingBox) {
        double[] answer = new double[boundingBox.getDimensions()];
        for (int i = 0; i < boundingBox.getDimensions(); ++i) {
            double minVal;
            double maxVal = boundingBox.getMaxValue(i);
            double oldRange = maxVal - (minVal = boundingBox.getMinValue(i));
            if (!(oldRange > 0.0)) continue;
            answer[i] = oldRange;
        }
        return answer;
    }

    public static double[] toDoubleArray(float[] point) {
        CommonUtils.checkNotNull(point, "point must not be null");
        double[] result = new double[point.length];
        for (int i = 0; i < point.length; ++i) {
            result[i] = point[i];
        }
        return result;
    }

    public static float[] toFloatArray(double[] point) {
        CommonUtils.checkNotNull(point, "point must not be null");
        float[] result = new float[point.length];
        for (int i = 0; i < point.length; ++i) {
            result[i] = (float)point[i];
        }
        return result;
    }
}

