/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.utils;

import inet.ipaddr.IPAddressString;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.opensearch.common.Strings;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0003\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0003\u001a\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0003\u001a\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001c\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a8\u0006\u000f"}, d2={"isHostInDenylist", "", "urlString", "", "hostDenyList", "", "isValidEmail", "email", "isValidUrl", "validateEmail", "", "validateMethod", "method", "validateUrl", "validateUrlHost", "opensearch-notifications-core"})
public final class ValidationHelpersKt {
    public static final void validateUrl(@NotNull String urlString) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        if (!(!Strings.isNullOrEmpty((String)urlString))) {
            boolean $i$a$-require-ValidationHelpersKt$validateUrl$32 = false;
            String $i$a$-require-ValidationHelpersKt$validateUrl$32 = "url is null or empty";
            throw new IllegalArgumentException($i$a$-require-ValidationHelpersKt$validateUrl$32.toString());
        }
        if (!ValidationHelpersKt.isValidUrl(urlString)) {
            boolean bl = false;
            String string = "Invalid URL or unsupported";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final void validateUrlHost(@NotNull String urlString, @NotNull List<String> hostDenyList) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter(hostDenyList, (String)"hostDenyList");
        if (!(!org.opensearch.notifications.spi.utils.ValidationHelpersKt.isHostInDenylist((String)urlString, hostDenyList))) {
            boolean bl = false;
            String string = "Host of url is denied, based on plugin setting [notification.core.email.host_deny_list]";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final void validateEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        if (!(!Strings.isNullOrEmpty((String)email))) {
            boolean $i$a$-require-ValidationHelpersKt$validateEmail$32 = false;
            String $i$a$-require-ValidationHelpersKt$validateEmail$32 = "FromAddress and recipient should be provided";
            throw new IllegalArgumentException($i$a$-require-ValidationHelpersKt$validateEmail$32.toString());
        }
        if (!ValidationHelpersKt.isValidEmail(email)) {
            boolean bl = false;
            String string = "Invalid email address";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final boolean isValidUrl(@NotNull String urlString) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        URL url = new URL(urlString);
        return Intrinsics.areEqual((Object)"https", (Object)url.getProtocol()) || Intrinsics.areEqual((Object)"http", (Object)url.getProtocol());
    }

    public static final boolean isHostInDenylist(@NotNull String urlString, @NotNull List<String> hostDenyList) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter(hostDenyList, (String)"hostDenyList");
        URL url = new URL(urlString);
        if (url.getHost() != null) {
            IPAddressString ipStr = new IPAddressString(url.getHost());
            for (String network : hostDenyList) {
                IPAddressString netStr = new IPAddressString(network);
                if (!netStr.contains(ipStr)) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean isValidEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Regex validEmailPattern = new Regex("(?:[a-z0-9!#$%&'*+\\/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+\\/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9]))\\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", RegexOption.IGNORE_CASE);
        return validEmailPattern.matches((CharSequence)email);
    }

    public static final void validateMethod(@NotNull String method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!(!Strings.isNullOrEmpty((String)method))) {
            boolean bl = false;
            String string = "Method is null or empty";
            throw new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new String[]{"POST", "PUT", "PATCH"};
        List validMethods = CollectionsKt.listOf((Object[])objectArray);
        if (!(StringsKt.findAnyOf$default((CharSequence)method, (Collection)validMethods, (int)0, (boolean)false, (int)6, null) != null)) {
            boolean bl = false;
            String string = "Invalid method supplied. Only POST, PUT and PATCH are allowed";
            throw new IllegalArgumentException(string.toString());
        }
    }
}

