/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.samplers;

import java.util.Objects;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaRuntimeMetrics;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.stats.collectors.SampleAggregator;
import org.opensearch.performanceanalyzer.rca.stats.emitters.ISampler;

public class RcaEnabledSampler
implements ISampler {
    private final AppContext appContext;

    RcaEnabledSampler(AppContext appContext) {
        Objects.requireNonNull(appContext);
        this.appContext = appContext;
    }

    @Override
    public void sample(SampleAggregator sampleCollector) {
        sampleCollector.updateStat(RcaRuntimeMetrics.RCA_ENABLED, "", this.isRcaEnabled() ? 1 : 0);
    }

    boolean isRcaEnabled() {
        InstanceDetails currentNode = this.appContext.getMyInstanceDetails();
        if (currentNode != null && currentNode.getIsMaster()) {
            return PerformanceAnalyzerApp.getRcaController().isRcaEnabled();
        }
        return false;
    }
}

