/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.metrics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.performanceanalyzer.rca.stats.eval.Statistics;
import org.opensearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;

public enum WriterMetrics implements MeasurementSet
{
    EVENT_LOG_FILES_DELETION_TIME("EventLogFilesDeletionTime", "millis", Arrays.asList(Statistics.MAX, Statistics.MEAN, Statistics.SUM)),
    EVENT_LOG_FILES_DELETED("EventLogFilesDeleted", "count", Arrays.asList(Statistics.MAX, Statistics.SUM)),
    STALE_METRICS("StaleMetrics"),
    JVM_ATTACH_ERROR("JvmAttachErrror"),
    JVM_ATTACH_ERROR_JAVA_PID_FILE_MISSING("JvmAttachErrorJavaPidFileMissing"),
    JVM_ATTACH_LOCK_ACQUISITION_FAILED("JvmAttachLockAcquisitionFailed"),
    NO_THREAD_STATE_INFO("NoThreadStateInfo"),
    JVM_THREAD_DUMP_SUCCESSFUL("JvmThreadDumpSuccessful"),
    JVM_THREAD_ID_NO_LONGER_EXISTS("JVMThreadIdNoLongerExists"),
    COLLECTORS_MUTED("CollectorsMutedCount", "namedCount", Collections.singletonList(Statistics.NAMED_COUNTERS)),
    MASTER_METRICS_ERROR("MasterMetricsError"),
    MASTER_NODE_NOT_UP("MasterNodeNotUp"),
    OPENSEARCH_REQUEST_INTERCEPTOR_ERROR("OpenSearchRequestInterceptorError"),
    SHARD_STATE_COLLECTOR_EXECUTION_TIME("ShardStateCollectorExecutionTime", "millis", Arrays.asList(Statistics.MAX, Statistics.MIN, Statistics.MEAN, Statistics.COUNT, Statistics.SUM)),
    MASTER_THROTTLING_COLLECTOR_EXECUTION_TIME("MasterThrottlingCollectorExecutionTime", "millis", Arrays.asList(Statistics.MAX, Statistics.MIN, Statistics.MEAN, Statistics.COUNT, Statistics.SUM)),
    MASTER_THROTTLING_COLLECTOR_NOT_AVAILABLE("MasterThrottlingCollectorNotAvailable", "count", Arrays.asList(Statistics.MAX, Statistics.MIN, Statistics.MEAN, Statistics.COUNT, Statistics.SUM)),
    ADMISSION_CONTROL_COLLECTOR_EXECUTION_TIME("AdmissionControlCollectorExecutionTime", "millis", Arrays.asList(Statistics.MAX, Statistics.MIN, Statistics.MEAN, Statistics.COUNT, Statistics.SUM)),
    ADMISSION_CONTROL_COLLECTOR_NOT_AVAILABLE("AdmissionControlCollectorNotAvailable", "count", Arrays.asList(Statistics.MAX, Statistics.MIN, Statistics.MEAN, Statistics.COUNT, Statistics.SUM)),
    FAULT_DETECTION_COLLECTOR_EXECUTION_TIME("FaultDetectionCollectorExecutionTime", "millis", Arrays.asList(Statistics.MAX, Statistics.MIN, Statistics.MEAN, Statistics.COUNT, Statistics.SUM)),
    CLUSTER_APPLIER_SERVICE_STATS_COLLECTOR_EXECUTION_TIME("ClusterApplierServiceStatsCollectorExecutionTime", "millis", Arrays.asList(Statistics.MAX, Statistics.MIN, Statistics.MEAN, Statistics.COUNT, Statistics.SUM)),
    MASTER_CLUSTER_UPDATE_STATS_COLLECTOR_DISABLED("MasterClusterUpdateStatsCollectorDisabled", "count", Arrays.asList(Statistics.MAX, Statistics.MIN, Statistics.MEAN, Statistics.COUNT, Statistics.SUM)),
    MASTER_CLUSTER_UPDATE_STATS_COLLECTOR_EXECUTION_TIME("MasterClusterUpdateStatsCollectorExecutionTime", "millis", Arrays.asList(Statistics.MAX, Statistics.MIN, Statistics.MEAN, Statistics.COUNT, Statistics.SUM)),
    ELECTION_TERM_COLLECTOR_EXECUTION_TIME("ElectionTermCollectorExecutionTime", "millis", Arrays.asList(Statistics.MAX, Statistics.MIN, Statistics.MEAN, Statistics.COUNT, Statistics.SUM)),
    SHARD_INDEXING_PRESSURE_COLLECTOR_EXECUTION_TIME("ShardIndexingPressureCollectorExecutionTime", "millis", Arrays.asList(Statistics.MAX, Statistics.MIN, Statistics.MEAN, Statistics.COUNT, Statistics.SUM)),
    WRITER_FILE_CREATION_SKIPPED("WriterFileCreationSkipped", "count", Arrays.asList(Statistics.COUNT)),
    METRICS_WRITE_ERROR("MetricsWriteError", "namedCount", Collections.singletonList(Statistics.NAMED_COUNTERS)),
    METRICS_REMOVE_ERROR("MetricsRemoveError", "count", Arrays.asList(Statistics.COUNT)),
    METRICS_REMOVE_FAILURE("MetricsRemoveFailure", "count", Arrays.asList(Statistics.COUNT)),
    GRPC_CHANNEL_CLOSURE_ERROR("GrpcChannelClosureError", "count", Arrays.asList(Statistics.COUNT)),
    GRPC_SERVER_CLOSURE_ERROR("GrpcServerClosureError", "count", Arrays.asList(Statistics.COUNT)),
    METRICS_DB_CLOSURE_ERROR("MetricsDbClosureError", "count", Arrays.asList(Statistics.COUNT)),
    IN_MEMORY_DATABASE_CONN_CLOSURE_ERROR("InMemoryDatabaseConnClosureError", "count", Arrays.asList(Statistics.COUNT));

    private String name;
    private String unit;
    private List<Statistics> statsList;

    private WriterMetrics(String name) {
        this.name = name;
        this.unit = "count";
        this.statsList = Collections.singletonList(Statistics.COUNT);
    }

    private WriterMetrics(String name, String unit, List<Statistics> stats) {
        this.name = name;
        this.unit = unit;
        this.statsList = stats;
    }

    private WriterMetrics(String name, String unit, Statistics stats) {
        this(name, unit, Collections.singletonList(stats));
    }

    public String toString() {
        return this.name + "-" + this.unit;
    }

    @Override
    public List<Statistics> getStatsList() {
        return this.statsList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }
}

