/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.metrics;

import java.util.Collections;
import java.util.List;
import org.opensearch.performanceanalyzer.rca.stats.eval.Statistics;
import org.opensearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;

public enum RcaRuntimeMetrics implements MeasurementSet
{
    RCA_STOPPED_BY_OPERATOR("RcaStoppedByOperator", "count", Collections.singletonList(Statistics.COUNT)),
    RCA_RESTARTED_BY_OPERATOR("RcaRestartedByOperator", "count", Collections.singletonList(Statistics.COUNT)),
    OPEN_SEARCH_APIS_CALLED("OpenSearchApisCalled", "count", Collections.singletonList(Statistics.NAMED_COUNTERS)),
    RCA_ENABLED("RcaEnabled", "count", Collections.singletonList(Statistics.SAMPLE)),
    NO_INCREASE_ACTION_SUGGESTED("NoIncreaseAction", "namedCount", Collections.singletonList(Statistics.NAMED_COUNTERS)),
    HEAP_SIZE_INCREASE_ACTION_SUGGESTED("HeapSizeIncreaseAction", "count", Collections.singletonList(Statistics.COUNT)),
    ACTIONS_PUBLISHED("ActionsPublished", "namedCount", Collections.singletonList(Statistics.NAMED_COUNTERS));

    private String name;
    private String unit;
    private List<Statistics> statsList;

    private RcaRuntimeMetrics(String name, String unit, List<Statistics> statisticList) {
        this.name = name;
        this.unit = unit;
        this.statsList = statisticList;
    }

    public String toString() {
        return this.name + "-" + this.unit;
    }

    @Override
    public List<Statistics> getStatsList() {
        return this.statsList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }
}

