/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.configs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.performanceanalyzer.rca.framework.core.NestedConfig;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.util.range.Range;

public class AdmissionControlRcaConfig {
    public static final String CONFIG_NAME = "admission-control-rca";
    private static final String REQUEST_SIZE = "request-size";
    private static final String GLOBAL_JVMMP = "global-jvmmp";
    private static final String UPPER_BOUND = "upper-bound";
    private static final String LOWER_BOUND = "lower-bound";
    private static final String THRESHOLD = "threshold";
    private static final String RANGE = "heap-range";
    private static final double DEFAULT_LOWER_BOUND = 0.0;
    private static final double DEFAULT_UPPER_BOUND = 100.0;
    private static final double DEFAULT_GLOBAL_JVMMP_THRESHOLD = 85.0;
    private static final double DEFAULT_REQUEST_SIZE_THRESHOLD = 10.0;
    private final NestedConfig admissionControlConfig;
    private final ControllerConfig requestSizeControllerConfig;
    private final ControllerConfig globalJVMMPControllerConfig;

    public AdmissionControlRcaConfig(RcaConf rcaConf) {
        Map<String, Object> actionConfig = rcaConf.getRcaConfigSettings();
        this.admissionControlConfig = new NestedConfig(CONFIG_NAME, actionConfig);
        this.requestSizeControllerConfig = new ControllerConfig(REQUEST_SIZE, this.admissionControlConfig);
        this.globalJVMMPControllerConfig = new ControllerConfig(GLOBAL_JVMMP, this.admissionControlConfig);
    }

    public ControllerConfig getGlobalJVMMPControllerConfig() {
        return this.globalJVMMPControllerConfig;
    }

    public ControllerConfig getRequestSizeControllerConfig() {
        return this.requestSizeControllerConfig;
    }

    public static class ControllerConfig {
        private NestedConfig controllerConfig;
        private List<Range> heapRangeConfiguration = Collections.emptyList();

        public ControllerConfig(String controller, NestedConfig settingsConfig) {
            List rangeList;
            this.controllerConfig = new NestedConfig(controller, settingsConfig.getValue());
            if (this.controllerConfig.getValue() != null && !Objects.isNull(rangeList = (List)this.controllerConfig.getValue().get(AdmissionControlRcaConfig.RANGE))) {
                this.heapRangeConfiguration = rangeList.stream().map(r -> new Range(Double.parseDouble(((Object)r.getOrDefault(AdmissionControlRcaConfig.LOWER_BOUND, 0.0)).toString()), Double.parseDouble(((Object)r.getOrDefault(AdmissionControlRcaConfig.UPPER_BOUND, 100.0)).toString()), Double.parseDouble(((Object)r.getOrDefault(AdmissionControlRcaConfig.THRESHOLD, 10.0)).toString()))).collect(Collectors.toList());
            }
        }

        public List<Range> getHeapRangeConfiguration() {
            return this.heapRangeConfiguration;
        }

        public String toString() {
            return String.format("ControllerConfig{controllerConfig=%s, heapRangeConfiguration=%s}", this.controllerConfig, this.heapRangeConfiguration);
        }
    }
}

