/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.settings;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.bootstrap.BootstrapInfo;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.OpenForTesting;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u00106\u001a\u0002072\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u00108\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000609J\u0006\u0010:\u001a\u00020\u000fJ\b\u0010;\u001a\u000207H\u0007J\u0010\u0010<\u001a\u0002072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010=\u001a\u0002072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u000e\u0010\u0013\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\bR\u000e\u0010\u001c\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001b\u0010+\u001a\u00020,8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b-\u0010.R\u001a\u00101\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105\u00a8\u0006>"}, d2={"Lorg/opensearch/notifications/settings/PluginSettings;", "", "()V", "DECIMAL_RADIX", "", "DEFAULT_ITEMS_QUERY_COUNT", "Lorg/opensearch/common/settings/Setting;", "getDEFAULT_ITEMS_QUERY_COUNT", "()Lorg/opensearch/common/settings/Setting;", "DEFAULT_ITEMS_QUERY_COUNT_KEY", "", "DEFAULT_ITEMS_QUERY_COUNT_VALUE", "DEFAULT_OPERATION_TIMEOUT_MS", "", "FILTER_BY_BACKEND_ROLES", "", "FILTER_BY_BACKEND_ROLES_KEY", "FILTER_SEND_BY_BACKEND_ROLES", "getFILTER_SEND_BY_BACKEND_ROLES", "FILTER_SEND_BY_BACKEND_ROLES_KEY", "GENERAL_KEY_PREFIX", "KEY_PREFIX", "LEGACY_FILTER_BY_BACKEND_ROLES", "LEGACY_FILTER_BY_BACKEND_ROLES_KEY", "MINIMUM_ITEMS_QUERY_COUNT", "MINIMUM_OPERATION_TIMEOUT_MS", "OPERATION_TIMEOUT_MS", "getOPERATION_TIMEOUT_MS", "OPERATION_TIMEOUT_MS_KEY", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "defaultItemsQueryCount", "getDefaultItemsQueryCount", "()I", "setDefaultItemsQueryCount", "(I)V", "defaultSettings", "", "filterSendByBackendRoles", "getFilterSendByBackendRoles", "()Z", "setFilterSendByBackendRoles", "(Z)V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "operationTimeoutMs", "getOperationTimeoutMs", "()J", "setOperationTimeoutMs", "(J)V", "addSettingsUpdateConsumer", "", "getAllSettings", "", "isRbacEnabled", "reset", "updateSettingValuesFromCluster", "updateSettingValuesFromLocal", "opensearch-notifications"})
public final class PluginSettings {
    @NotNull
    public static final PluginSettings INSTANCE;
    private static ClusterService clusterService;
    @NotNull
    private static final String KEY_PREFIX = "opensearch.notifications";
    @NotNull
    private static final String GENERAL_KEY_PREFIX = "opensearch.notifications.general";
    @NotNull
    private static final String OPERATION_TIMEOUT_MS_KEY = "opensearch.notifications.general.operationTimeoutMs";
    @NotNull
    private static final String DEFAULT_ITEMS_QUERY_COUNT_KEY = "opensearch.notifications.general.defaultItemsQueryCount";
    @NotNull
    private static final String FILTER_SEND_BY_BACKEND_ROLES_KEY = "opensearch.notifications.general.filterSendByBackendRoles";
    @NotNull
    private static final String LEGACY_FILTER_BY_BACKEND_ROLES_KEY = "opendistro.alerting.filter_by_backend_roles";
    @NotNull
    private static final String FILTER_BY_BACKEND_ROLES_KEY = "plugins.alerting.filter_by_backend_roles";
    private static final long DEFAULT_OPERATION_TIMEOUT_MS = 60000L;
    private static final long MINIMUM_OPERATION_TIMEOUT_MS = 100L;
    private static final int DEFAULT_ITEMS_QUERY_COUNT_VALUE = 100;
    private static final int MINIMUM_ITEMS_QUERY_COUNT = 10;
    private static volatile long operationTimeoutMs;
    private static volatile int defaultItemsQueryCount;
    private static volatile boolean filterSendByBackendRoles;
    private static final int DECIMAL_RADIX = 10;
    @NotNull
    private static final Lazy log$delegate;
    @NotNull
    private static final Map<String, String> defaultSettings;
    @NotNull
    private static final Setting<Long> OPERATION_TIMEOUT_MS;
    @NotNull
    private static final Setting<Integer> DEFAULT_ITEMS_QUERY_COUNT;
    @NotNull
    private static final Setting<Boolean> FILTER_SEND_BY_BACKEND_ROLES;
    @NotNull
    private static final Setting<Boolean> LEGACY_FILTER_BY_BACKEND_ROLES;
    @NotNull
    private static final Setting<Boolean> FILTER_BY_BACKEND_ROLES;

    private PluginSettings() {
    }

    public final long getOperationTimeoutMs() {
        return operationTimeoutMs;
    }

    public final void setOperationTimeoutMs(long l) {
        operationTimeoutMs = l;
    }

    public final int getDefaultItemsQueryCount() {
        return defaultItemsQueryCount;
    }

    public final void setDefaultItemsQueryCount(int n) {
        defaultItemsQueryCount = n;
    }

    public final boolean getFilterSendByBackendRoles() {
        return filterSendByBackendRoles;
    }

    public final void setFilterSendByBackendRoles(boolean bl) {
        filterSendByBackendRoles = bl;
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final Setting<Long> getOPERATION_TIMEOUT_MS() {
        return OPERATION_TIMEOUT_MS;
    }

    @NotNull
    public final Setting<Integer> getDEFAULT_ITEMS_QUERY_COUNT() {
        return DEFAULT_ITEMS_QUERY_COUNT;
    }

    @NotNull
    public final Setting<Boolean> getFILTER_SEND_BY_BACKEND_ROLES() {
        return FILTER_SEND_BY_BACKEND_ROLES;
    }

    public final boolean isRbacEnabled() {
        ClusterService clusterService = PluginSettings.clusterService;
        if (clusterService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
            clusterService = null;
        }
        if (clusterService.getClusterSettings().get(FILTER_BY_BACKEND_ROLES_KEY) != null) {
            ClusterService clusterService2 = PluginSettings.clusterService;
            if (clusterService2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
                clusterService2 = null;
            }
            Boolean bl = (Boolean)clusterService2.getClusterSettings().get(FILTER_BY_BACKEND_ROLES);
            return bl == null ? false : bl;
        }
        return false;
    }

    @NotNull
    public final List<Setting<?>> getAllSettings() {
        Object[] objectArray = new Setting[]{OPERATION_TIMEOUT_MS, DEFAULT_ITEMS_QUERY_COUNT, FILTER_SEND_BY_BACKEND_ROLES};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final void updateSettingValuesFromLocal(ClusterService clusterService) {
        Object object = OPERATION_TIMEOUT_MS.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"OPERATION_TIMEOUT_MS.get(clusterService.settings)");
        operationTimeoutMs = ((Number)object).longValue();
        object = DEFAULT_ITEMS_QUERY_COUNT.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DEFAULT_ITEMS_QUERY_COUN\u2026(clusterService.settings)");
        defaultItemsQueryCount = ((Number)object).intValue();
        object = FILTER_SEND_BY_BACKEND_ROLES.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"FILTER_SEND_BY_BACKEND_R\u2026(clusterService.settings)");
        filterSendByBackendRoles = (Boolean)object;
    }

    private final void updateSettingValuesFromCluster(ClusterService clusterService) {
        Boolean clusterFilterSendByBackendRole;
        Integer clusterDefaultItemsQueryCount;
        Long clusterOperationTimeoutMs = (Long)clusterService.getClusterSettings().get(OPERATION_TIMEOUT_MS);
        if (clusterOperationTimeoutMs != null) {
            this.getLog().debug("notifications:opensearch.notifications.general.operationTimeoutMs -autoUpdatedTo-> " + clusterOperationTimeoutMs);
            operationTimeoutMs = clusterOperationTimeoutMs;
        }
        if ((clusterDefaultItemsQueryCount = (Integer)clusterService.getClusterSettings().get(DEFAULT_ITEMS_QUERY_COUNT)) != null) {
            this.getLog().debug("notifications:opensearch.notifications.general.defaultItemsQueryCount -autoUpdatedTo-> " + clusterDefaultItemsQueryCount);
            defaultItemsQueryCount = clusterDefaultItemsQueryCount;
        }
        if ((clusterFilterSendByBackendRole = (Boolean)clusterService.getClusterSettings().get(FILTER_SEND_BY_BACKEND_ROLES)) != null) {
            this.getLog().debug("notifications:opensearch.notifications.general.filterSendByBackendRoles -autoUpdatedTo-> " + clusterFilterSendByBackendRole);
            filterSendByBackendRoles = clusterFilterSendByBackendRole;
        }
    }

    public final void addSettingsUpdateConsumer(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        PluginSettings.clusterService = clusterService;
        this.updateSettingValuesFromLocal(clusterService);
        this.updateSettingValuesFromCluster(clusterService);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(OPERATION_TIMEOUT_MS, PluginSettings::addSettingsUpdateConsumer$lambda-0);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DEFAULT_ITEMS_QUERY_COUNT, PluginSettings::addSettingsUpdateConsumer$lambda-1);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(FILTER_SEND_BY_BACKEND_ROLES, PluginSettings::addSettingsUpdateConsumer$lambda-2);
    }

    @OpenForTesting
    public final void reset() {
        operationTimeoutMs = 60000L;
        defaultItemsQueryCount = 100;
        filterSendByBackendRoles = false;
    }

    private static final void addSettingsUpdateConsumer$lambda-0(Long it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        operationTimeoutMs = it;
        INSTANCE.getLog().info("notifications:opensearch.notifications.general.operationTimeoutMs -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda-1(Integer it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        defaultItemsQueryCount = it;
        INSTANCE.getLog().info("notifications:opensearch.notifications.general.defaultItemsQueryCount -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda-2(Boolean it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        filterSendByBackendRoles = it;
        INSTANCE.getLog().info("notifications:opensearch.notifications.general.filterSendByBackendRoles -updatedTo-> " + it);
    }

    static {
        boolean bl;
        int n;
        long l;
        Object object;
        String configDirName;
        String string;
        INSTANCE = new PluginSettings();
        log$delegate = HelpersKt.logger(INSTANCE.getClass());
        Pair[] settings = null;
        Dictionary dictionary = BootstrapInfo.getSystemProperties();
        if (dictionary == null) {
            string = null;
        } else {
            Object v = dictionary.get("opensearch.path.conf");
            string = configDirName = v == null ? null : v.toString();
        }
        if (configDirName != null) {
            object = new String[]{"opensearch-notifications", "notifications.yml"};
            Path defaultSettingYmlFile = Path.of(configDirName, object);
            try {
                settings = Settings.builder().loadFromPath(defaultSettingYmlFile).build();
            }
            catch (IOException e) {
                INSTANCE.getLog().warn("notifications:Failed to load " + defaultSettingYmlFile.toAbsolutePath() + ":" + e.getMessage());
            }
        }
        operationTimeoutMs = settings == null ? 60000L : ((object = settings.get(OPERATION_TIMEOUT_MS_KEY)) == null ? 60000L : (l = Long.parseLong((String)object)));
        Pair[] pairArray = settings;
        defaultItemsQueryCount = pairArray == null ? 100 : ((object = pairArray.get(DEFAULT_ITEMS_QUERY_COUNT_KEY)) == null ? 100 : (n = Integer.parseInt((String)object)));
        pairArray = settings;
        filterSendByBackendRoles = pairArray == null ? false : ((object = pairArray.get(FILTER_SEND_BY_BACKEND_ROLES_KEY)) == null ? false : (bl = Boolean.parseBoolean((String)object)));
        pairArray = new Pair[3];
        String string2 = Long.toString(operationTimeoutMs, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
        pairArray[0] = TuplesKt.to((Object)OPERATION_TIMEOUT_MS_KEY, (Object)string2);
        String string3 = Integer.toString(defaultItemsQueryCount, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this, checkRadix(radix))");
        pairArray[1] = TuplesKt.to((Object)DEFAULT_ITEMS_QUERY_COUNT_KEY, (Object)string3);
        pairArray[2] = TuplesKt.to((Object)FILTER_SEND_BY_BACKEND_ROLES_KEY, (Object)String.valueOf(filterSendByBackendRoles));
        defaultSettings = MapsKt.mapOf((Pair[])pairArray);
        String string4 = defaultSettings.get(OPERATION_TIMEOUT_MS_KEY);
        Intrinsics.checkNotNull((Object)string4);
        Setting.Property[] propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting = Setting.longSetting((String)OPERATION_TIMEOUT_MS_KEY, (long)Long.parseLong(string4), (long)100L, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting, (String)"longSetting(\n        OPE\u2026 NodeScope, Dynamic\n    )");
        OPERATION_TIMEOUT_MS = setting;
        String string5 = defaultSettings.get(DEFAULT_ITEMS_QUERY_COUNT_KEY);
        Intrinsics.checkNotNull((Object)string5);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        setting = Setting.intSetting((String)DEFAULT_ITEMS_QUERY_COUNT_KEY, (int)Integer.parseInt(string5), (int)10, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting, (String)"intSetting(\n        DEFA\u2026 NodeScope, Dynamic\n    )");
        DEFAULT_ITEMS_QUERY_COUNT = setting;
        String string6 = defaultSettings.get(FILTER_SEND_BY_BACKEND_ROLES_KEY);
        Intrinsics.checkNotNull((Object)string6);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        setting = Setting.boolSetting((String)FILTER_SEND_BY_BACKEND_ROLES_KEY, (boolean)Boolean.parseBoolean(string6), (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting, (String)"boolSetting(\n        FIL\u2026 NodeScope, Dynamic\n    )");
        FILTER_SEND_BY_BACKEND_ROLES = setting;
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Deprecated};
        setting = Setting.boolSetting((String)LEGACY_FILTER_BY_BACKEND_ROLES_KEY, (boolean)false, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting, (String)"boolSetting(\n        LEG\u2026ynamic, Deprecated,\n    )");
        LEGACY_FILTER_BY_BACKEND_ROLES = setting;
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        setting = Setting.boolSetting((String)FILTER_BY_BACKEND_ROLES_KEY, LEGACY_FILTER_BY_BACKEND_ROLES, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting, (String)"boolSetting(\n        FIL\u2026 NodeScope, Dynamic\n    )");
        FILTER_BY_BACKEND_ROLES = setting;
    }
}

