/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.security;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.commons.authuser.User;
import org.opensearch.notifications.security.UserAccess;
import org.opensearch.notifications.settings.PluginSettings;
import org.opensearch.rest.RestStatus;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J \u0010\n\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/opensearch/notifications/security/UserAccessManager;", "Lorg/opensearch/notifications/security/UserAccess;", "()V", "doesUserHaveAccess", "", "user", "Lorg/opensearch/commons/authuser/User;", "access", "", "", "doesUserHaveSendAccess", "getAllAccessInfo", "getSearchAccessInfo", "validateUser", "", "opensearch-notifications"})
public final class UserAccessManager
implements UserAccess {
    @NotNull
    public static final UserAccessManager INSTANCE = new UserAccessManager();

    private UserAccessManager() {
    }

    @Override
    public void validateUser(@Nullable User user) {
        if (PluginSettings.INSTANCE.isRbacEnabled()) {
            User user2 = user;
            Collection collection = (Collection)(user2 == null ? null : user2.getBackendRoles());
            if (collection == null || collection.isEmpty()) {
                throw new OpenSearchStatusException("User doesn't have backend roles configured. Contact administrator.", RestStatus.FORBIDDEN, new Object[0]);
            }
        }
    }

    @Override
    @NotNull
    public List<String> getAllAccessInfo(@Nullable User user) {
        if (user == null) {
            return CollectionsKt.emptyList();
        }
        List list = user.getBackendRoles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"user.backendRoles");
        return list;
    }

    @Override
    @NotNull
    public List<String> getSearchAccessInfo(@Nullable User user) {
        if (user == null || !PluginSettings.INSTANCE.isRbacEnabled()) {
            return CollectionsKt.emptyList();
        }
        List list = user.getBackendRoles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"user.backendRoles");
        return list;
    }

    @Override
    public boolean doesUserHaveAccess(@Nullable User user, @NotNull List<String> access) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(access, (String)"access");
            if (user == null || !PluginSettings.INSTANCE.isRbacEnabled()) {
                return true;
            }
            List list = user.getBackendRoles();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"user.backendRoles");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!access.contains(it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean doesUserHaveSendAccess(@Nullable User user, @NotNull List<String> access) {
        Intrinsics.checkNotNullParameter(access, (String)"access");
        return !PluginSettings.INSTANCE.getFilterSendByBackendRoles() || this.doesUserHaveAccess(user, access);
    }
}

