/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.index;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionFuture;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContent;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.notifications.action.GetNotificationConfigRequest;
import org.opensearch.commons.notifications.model.NotificationConfigInfo;
import org.opensearch.commons.notifications.model.NotificationConfigSearchResult;
import org.opensearch.commons.notifications.model.SearchResults;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.notifications.index.ConfigOperations;
import org.opensearch.notifications.index.ConfigQueryHelper;
import org.opensearch.notifications.index.NotificationConfigIndex;
import org.opensearch.notifications.model.DocInfo;
import org.opensearch.notifications.model.NotificationConfigDoc;
import org.opensearch.notifications.model.NotificationConfigDocInfo;
import org.opensearch.notifications.settings.PluginSettings;
import org.opensearch.notifications.util.SecureIndexClient;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortOrder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000w\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0012\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J\"\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 H\u0016J\u001e\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040$2\u0006\u0010%\u001a\u00020&H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020(0$2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 H\u0016J\u0016\u0010*\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\b\u0010+\u001a\u00020\u001bH\u0002J\u001a\u0010,\u001a\u0004\u0018\u00010(2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u00061"}, d2={"Lorg/opensearch/notifications/index/NotificationConfigIndex;", "Lorg/opensearch/notifications/index/ConfigOperations;", "()V", "INDEX_NAME", "", "MAPPING_FILE_NAME", "SETTINGS_FILE_NAME", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "searchHitParser", "org/opensearch/notifications/index/NotificationConfigIndex$searchHitParser$1", "Lorg/opensearch/notifications/index/NotificationConfigIndex$searchHitParser$1;", "createIndex", "", "createNotificationConfig", "configDoc", "Lorg/opensearch/notifications/model/NotificationConfigDoc;", "id", "deleteNotificationConfig", "", "deleteNotificationConfigs", "", "Lorg/opensearch/rest/RestStatus;", "ids", "", "getAllNotificationConfigs", "Lorg/opensearch/commons/notifications/model/NotificationConfigSearchResult;", "access", "", "request", "Lorg/opensearch/commons/notifications/action/GetNotificationConfigRequest;", "getNotificationConfig", "Lorg/opensearch/notifications/model/NotificationConfigDocInfo;", "getNotificationConfigs", "initialize", "isIndexExists", "parseNotificationConfigDoc", "response", "Lorg/opensearch/action/get/GetResponse;", "updateNotificationConfig", "notificationConfigDoc", "opensearch-notifications"})
public final class NotificationConfigIndex
implements ConfigOperations {
    @NotNull
    public static final NotificationConfigIndex INSTANCE = new NotificationConfigIndex();
    @NotNull
    private static final Lazy log$delegate = HelpersKt.logger(NotificationConfigIndex.class);
    @NotNull
    private static final String INDEX_NAME = ".opensearch-notifications-config";
    @NotNull
    private static final String MAPPING_FILE_NAME = "notifications-config-mapping.yml";
    @NotNull
    private static final String SETTINGS_FILE_NAME = "notifications-config-settings.yml";
    private static Client client;
    private static ClusterService clusterService;
    @NotNull
    private static final searchHitParser.1 searchHitParser;

    private NotificationConfigIndex() {
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    public final void initialize(@NotNull Client client, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        NotificationConfigIndex.client = new SecureIndexClient(client);
        NotificationConfigIndex.clusterService = clusterService;
    }

    private final void createIndex() {
        block9: {
            if (!this.isIndexExists()) {
                String string;
                Object object;
                String string2;
                ClassLoader classLoader = NotificationConfigIndex.class.getClassLoader();
                URL uRL = classLoader.getResource(MAPPING_FILE_NAME);
                if (uRL == null) {
                    string2 = null;
                } else {
                    URL uRL2 = uRL;
                    Charset charset = Charsets.UTF_8;
                    object = TextStreamsKt.readBytes((URL)uRL2);
                    string2 = new String((byte[])object, charset);
                }
                Intrinsics.checkNotNull(string2);
                String indexMappingSource = string2;
                Map indexMappingAsMap = XContentHelper.convertToMap((XContent)XContentType.YAML.xContent(), (String)indexMappingSource, (boolean)false);
                URL uRL3 = classLoader.getResource(SETTINGS_FILE_NAME);
                if (uRL3 == null) {
                    string = null;
                } else {
                    object = uRL3;
                    Charset charset = Charsets.UTF_8;
                    byte[] byArray = TextStreamsKt.readBytes((URL)object);
                    string = new String(byArray, charset);
                }
                Intrinsics.checkNotNull(string);
                String indexSettingsSource = string;
                CreateIndexRequest request = new CreateIndexRequest(INDEX_NAME).mapping(indexMappingAsMap).settings(indexSettingsSource, XContentType.YAML);
                try {
                    ActionFuture actionFuture;
                    CreateIndexResponse response;
                    Client client = NotificationConfigIndex.client;
                    if (client == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                        client = null;
                    }
                    if (!(response = (CreateIndexResponse)(actionFuture = client.admin().indices().create(request)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).isAcknowledged()) {
                        throw new IllegalStateException("notifications:Index .opensearch-notifications-config creation not Acknowledged");
                    }
                    this.getLog().info("notifications:Index .opensearch-notifications-config creation Acknowledged");
                }
                catch (Exception exception) {
                    if (exception instanceof ResourceAlreadyExistsException || exception.getCause() instanceof ResourceAlreadyExistsException) break block9;
                    throw exception;
                }
            }
        }
    }

    private final boolean isIndexExists() {
        ClusterService clusterService = NotificationConfigIndex.clusterService;
        if (clusterService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
            clusterService = null;
        }
        ClusterState clusterState = clusterService.state();
        return clusterState.getRoutingTable().hasIndex(INDEX_NAME);
    }

    @Override
    @Nullable
    public String createNotificationConfig(@NotNull NotificationConfigDoc configDoc, @Nullable String id) {
        String string;
        ActionFuture actionFuture;
        IndexResponse response;
        Client client;
        Intrinsics.checkNotNullParameter((Object)configDoc, (String)"configDoc");
        this.createIndex();
        IndexRequest indexRequest = new IndexRequest(INDEX_NAME).source(NotificationConfigDoc.toXContent$default(configDoc, null, 1, null)).create(true);
        if (id != null) {
            indexRequest.id(id);
        }
        if ((client = NotificationConfigIndex.client) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (IndexResponse)(actionFuture = client.index(indexRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getResult() != DocWriteResponse.Result.CREATED) {
            this.getLog().warn("notifications:createNotificationConfig - response:" + response);
            string = null;
        } else {
            string = response.getId();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<NotificationConfigDocInfo> getNotificationConfigs(@NotNull Set<String> ids) {
        void $this$mapNotNullTo$iv$iv;
        Object[] it;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        this.createIndex();
        MultiGetRequest getRequest = new MultiGetRequest();
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Object[])element$iv;
            boolean bl = false;
            getRequest.add(INDEX_NAME, (String)it);
        }
        Client client = NotificationConfigIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        ActionFuture actionFuture = client.multiGet(getRequest);
        MultiGetResponse response = (MultiGetResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        MultiGetItemResponse[] multiGetItemResponseArray = response.getResponses();
        Intrinsics.checkNotNullExpressionValue((Object)multiGetItemResponseArray, (String)"response.responses");
        Object[] $this$mapNotNull$iv = multiGetItemResponseArray;
        boolean $i$f$mapNotNull = false;
        it = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        for (void element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            NotificationConfigDocInfo it$iv$iv;
            void element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            MultiGetItemResponse it2 = (MultiGetItemResponse)element$iv$iv;
            boolean bl2 = false;
            String string = it2.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.id");
            String string2 = string;
            string = it2.getResponse();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.response");
            if (INSTANCE.parseNotificationConfigDoc(string2, (GetResponse)string) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public NotificationConfigDocInfo getNotificationConfig(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.createIndex();
        GetRequest getRequest = new GetRequest(INDEX_NAME).id(id);
        Client client = NotificationConfigIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        ActionFuture actionFuture = client.get(getRequest);
        GetResponse response = (GetResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        return this.parseNotificationConfigDoc(id, response);
    }

    private final NotificationConfigDocInfo parseNotificationConfigDoc(String id, GetResponse response) {
        NotificationConfigDocInfo notificationConfigDocInfo;
        if (response.getSourceAsString() == null) {
            this.getLog().warn("notifications:getNotificationConfig - " + id + " not found; response:" + response);
            notificationConfigDocInfo = null;
        } else {
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response.getSourceAsString());
            parser.nextToken();
            Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"parser");
            NotificationConfigDoc doc = NotificationConfigDoc.Companion.parse(parser);
            DocInfo info = new DocInfo(id, response.getVersion(), response.getSeqNo(), response.getPrimaryTerm());
            notificationConfigDocInfo = new NotificationConfigDocInfo(info, doc);
        }
        return notificationConfigDocInfo;
    }

    @Override
    @NotNull
    public NotificationConfigSearchResult getAllNotificationConfigs(@NotNull List<String> access, @NotNull GetNotificationConfigRequest request) {
        Intrinsics.checkNotNullParameter(access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.createIndex();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().timeout(new TimeValue(PluginSettings.INSTANCE.getOperationTimeoutMs(), TimeUnit.MILLISECONDS));
        String string = ConfigQueryHelper.INSTANCE.getSortField(request.getSortField());
        SortOrder sortOrder = request.getSortOrder();
        if (sortOrder == null) {
            sortOrder = SortOrder.ASC;
        }
        SearchSourceBuilder sourceBuilder = searchSourceBuilder.sort(string, sortOrder).size(request.getMaxItems()).from(request.getFromIndex());
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        if (!((Collection)access).isEmpty()) {
            query.filter((QueryBuilder)QueryBuilders.termsQuery((String)"metadata.access", (Collection)access));
        }
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"query");
        ConfigQueryHelper.INSTANCE.addQueryFilters(query, request.getFilterParams());
        sourceBuilder.query((QueryBuilder)query);
        String[] stringArray = new String[]{INDEX_NAME};
        SearchRequest searchRequest = new SearchRequest().indices(stringArray).source(sourceBuilder);
        Client client = NotificationConfigIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        ActionFuture actionFuture = client.search(searchRequest);
        SearchResponse response = (SearchResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        long l = request.getFromIndex();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        NotificationConfigSearchResult result = new NotificationConfigSearchResult(l, response, (SearchResults.SearchHitParser)searchHitParser);
        this.getLog().info("notifications:getAllNotificationConfigs from:" + request.getFromIndex() + ", maxItems:" + request.getMaxItems() + ", sortField:" + request.getSortField() + ", sortOrder=" + request.getSortOrder() + ", filters=" + request.getFilterParams() + " retCount:" + result.getObjectList().size() + ", totalCount:" + result.getTotalHits());
        return result;
    }

    @Override
    public boolean updateNotificationConfig(@NotNull String id, @NotNull NotificationConfigDoc notificationConfigDoc) {
        ActionFuture actionFuture;
        IndexResponse response;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)notificationConfigDoc, (String)"notificationConfigDoc");
        this.createIndex();
        IndexRequest indexRequest = new IndexRequest(INDEX_NAME).source(NotificationConfigDoc.toXContent$default(notificationConfigDoc, null, 1, null)).create(false).id(id);
        Client client = NotificationConfigIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (IndexResponse)(actionFuture = client.index(indexRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getResult() != DocWriteResponse.Result.UPDATED) {
            this.getLog().warn("notifications:updateNotificationConfig failed for " + id + "; response:" + response);
        }
        return response.getResult() == DocWriteResponse.Result.UPDATED;
    }

    @Override
    public boolean deleteNotificationConfig(@NotNull String id) {
        ActionFuture actionFuture;
        DeleteResponse response;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.createIndex();
        DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index(INDEX_NAME)).id(id);
        Client client = NotificationConfigIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (DeleteResponse)(actionFuture = client.delete(deleteRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getResult() != DocWriteResponse.Result.DELETED) {
            this.getLog().warn("notifications:deleteNotificationConfig failed for " + id + "; response:" + response);
        }
        return response.getResult() == DocWriteResponse.Result.DELETED;
    }

    @Override
    @NotNull
    public Map<String, RestStatus> deleteNotificationConfigs(@NotNull Set<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        this.createIndex();
        BulkRequest bulkRequest = new BulkRequest();
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index(INDEX_NAME)).id(it);
            bulkRequest.add(deleteRequest);
        }
        Client client = NotificationConfigIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        ActionFuture actionFuture = client.bulk(bulkRequest);
        BulkResponse response = (BulkResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        Map mutableMap = new LinkedHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        Iterable $this$forEach$iv2 = (Iterable)response;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            BulkItemResponse it = (BulkItemResponse)element$iv;
            boolean bl = false;
            String string = it.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.id");
            RestStatus restStatus = it.status();
            Intrinsics.checkNotNullExpressionValue((Object)restStatus, (String)"it.status()");
            mutableMap.put(string, restStatus);
            if (!it.isFailed()) continue;
            INSTANCE.getLog().warn("notifications:deleteNotificationConfig failed for " + it.getId() + "; response:" + it.getFailureMessage());
        }
        return mutableMap;
    }

    static {
        searchHitParser = new SearchResults.SearchHitParser<NotificationConfigInfo>(){

            @NotNull
            public NotificationConfigInfo parse(@NotNull SearchHit searchHit) {
                Intrinsics.checkNotNullParameter((Object)searchHit, (String)"searchHit");
                XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, searchHit.getSourceAsString());
                parser.nextToken();
                Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"parser");
                NotificationConfigDoc doc = NotificationConfigDoc.Companion.parse(parser);
                String string = searchHit.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"searchHit.id");
                return new NotificationConfigInfo(string, doc.getMetadata().getLastUpdateTime(), doc.getMetadata().getCreatedTime(), doc.getConfig());
            }
        };
    }
}

