/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.index;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.commons.authuser.User;
import org.opensearch.commons.notifications.action.CreateNotificationConfigRequest;
import org.opensearch.commons.notifications.action.CreateNotificationConfigResponse;
import org.opensearch.commons.notifications.action.DeleteNotificationConfigRequest;
import org.opensearch.commons.notifications.action.DeleteNotificationConfigResponse;
import org.opensearch.commons.notifications.action.GetChannelListRequest;
import org.opensearch.commons.notifications.action.GetChannelListResponse;
import org.opensearch.commons.notifications.action.GetNotificationConfigRequest;
import org.opensearch.commons.notifications.action.GetNotificationConfigResponse;
import org.opensearch.commons.notifications.action.UpdateNotificationConfigRequest;
import org.opensearch.commons.notifications.action.UpdateNotificationConfigResponse;
import org.opensearch.commons.notifications.model.BaseConfigData;
import org.opensearch.commons.notifications.model.Channel;
import org.opensearch.commons.notifications.model.ChannelList;
import org.opensearch.commons.notifications.model.Chime;
import org.opensearch.commons.notifications.model.ConfigType;
import org.opensearch.commons.notifications.model.Email;
import org.opensearch.commons.notifications.model.EmailGroup;
import org.opensearch.commons.notifications.model.NotificationConfig;
import org.opensearch.commons.notifications.model.NotificationConfigInfo;
import org.opensearch.commons.notifications.model.NotificationConfigSearchResult;
import org.opensearch.commons.notifications.model.SesAccount;
import org.opensearch.commons.notifications.model.Slack;
import org.opensearch.commons.notifications.model.SmtpAccount;
import org.opensearch.commons.notifications.model.Sns;
import org.opensearch.commons.notifications.model.Webhook;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.notifications.index.ConfigOperations;
import org.opensearch.notifications.metrics.Metrics;
import org.opensearch.notifications.model.DocMetadata;
import org.opensearch.notifications.model.NotificationConfigDoc;
import org.opensearch.notifications.model.NotificationConfigDocInfo;
import org.opensearch.notifications.security.UserAccess;
import org.opensearch.rest.RestStatus;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J \u0010\u0013\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00192\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u001c2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u001a\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u001c2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020 2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\"H\u0002J\u001a\u0010#\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J \u0010#\u001a\u00020\u001b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0016\u0010$\u001a\u00020%2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010&\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020(2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u001a\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020+2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020.2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010/\u001a\u00020%2\u0006\u00100\u001a\u0002012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u00102\u001a\u00020%2\u0006\u00103\u001a\u0002042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u00105\u001a\u00020%2\u0006\u00106\u001a\u0002072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u00108\u001a\u00020%2\u0006\u00109\u001a\u00020:2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010;\u001a\u00020%2\u0006\u0010<\u001a\u00020=2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010>\u001a\u00020%2\u0006\u0010?\u001a\u00020@2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010A\u001a\u00020%2\u0006\u0010B\u001a\u00020C2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/opensearch/notifications/index/ConfigIndexingActions;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "operations", "Lorg/opensearch/notifications/index/ConfigOperations;", "userAccess", "Lorg/opensearch/notifications/security/UserAccess;", "create", "Lorg/opensearch/commons/notifications/action/CreateNotificationConfigResponse;", "request", "Lorg/opensearch/commons/notifications/action/CreateNotificationConfigRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "delete", "Lorg/opensearch/commons/notifications/action/DeleteNotificationConfigResponse;", "configId", "", "configIds", "", "Lorg/opensearch/commons/notifications/action/DeleteNotificationConfigRequest;", "get", "Lorg/opensearch/commons/notifications/action/GetNotificationConfigResponse;", "Lorg/opensearch/commons/notifications/action/GetNotificationConfigRequest;", "getAll", "getChannelList", "Lorg/opensearch/commons/notifications/action/GetChannelListResponse;", "Lorg/opensearch/commons/notifications/action/GetChannelListRequest;", "getSupportedChannelList", "", "info", "initialize", "", "update", "Lorg/opensearch/commons/notifications/action/UpdateNotificationConfigResponse;", "Lorg/opensearch/commons/notifications/action/UpdateNotificationConfigRequest;", "validateChimeConfig", "chime", "Lorg/opensearch/commons/notifications/model/Chime;", "validateConfig", "config", "Lorg/opensearch/commons/notifications/model/NotificationConfig;", "validateEmailConfig", "email", "Lorg/opensearch/commons/notifications/model/Email;", "validateEmailGroupConfig", "emailGroup", "Lorg/opensearch/commons/notifications/model/EmailGroup;", "validateSesAccountConfig", "sesAccount", "Lorg/opensearch/commons/notifications/model/SesAccount;", "validateSlackConfig", "slack", "Lorg/opensearch/commons/notifications/model/Slack;", "validateSmtpAccountConfig", "smtpAccount", "Lorg/opensearch/commons/notifications/model/SmtpAccount;", "validateSnsConfig", "sns", "Lorg/opensearch/commons/notifications/model/Sns;", "validateWebhookConfig", "webhook", "Lorg/opensearch/commons/notifications/model/Webhook;", "opensearch-notifications"})
public final class ConfigIndexingActions {
    @NotNull
    public static final ConfigIndexingActions INSTANCE = new ConfigIndexingActions();
    @NotNull
    private static final Lazy log$delegate = HelpersKt.logger(ConfigIndexingActions.class);
    private static ConfigOperations operations;
    private static UserAccess userAccess;

    private ConfigIndexingActions() {
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    public final void initialize(@NotNull ConfigOperations operations, @NotNull UserAccess userAccess) {
        Intrinsics.checkNotNullParameter((Object)operations, (String)"operations");
        Intrinsics.checkNotNullParameter((Object)userAccess, (String)"userAccess");
        ConfigIndexingActions.operations = operations;
        ConfigIndexingActions.userAccess = userAccess;
    }

    private final void validateSlackConfig(Slack slack, User user) {
    }

    private final void validateChimeConfig(Chime chime, User user) {
    }

    private final void validateWebhookConfig(Webhook webhook, User user) {
    }

    private final void validateSnsConfig(Sns sns, User user) {
    }

    /*
     * WARNING - void declaration
     */
    private final void validateEmailConfig(Email email, User user) {
        List<NotificationConfigDocInfo> configDocs;
        if (email.getEmailGroupIds().contains(email.getEmailAccountID())) {
            throw new OpenSearchStatusException("Config IDs " + email.getEmailAccountID() + " is in both emailAccountID and emailGroupIds", RestStatus.BAD_REQUEST, new Object[0]);
        }
        Set configIds = CollectionsKt.union((Iterable)SetsKt.setOf((Object)email.getEmailAccountID()), (Iterable)email.getEmailGroupIds());
        ConfigOperations configOperations = operations;
        if (configOperations == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
            configOperations = null;
        }
        if ((configDocs = configOperations.getNotificationConfigs(configIds)).size() != configIds.size()) {
            void $this$filterNotTo$iv$iv;
            String it;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = configDocs;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                NotificationConfigDocInfo notificationConfigDocInfo = (NotificationConfigDocInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((NotificationConfigDocInfo)((Object)it)).getDocInfo().getId());
            }
            Set availableIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Iterable $this$filterNot$iv = configIds;
            boolean $i$f$filterNot = false;
            $this$mapTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (availableIds.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Object[] objectArray = new Object[]{};
            RestStatus restStatus = RestStatus.NOT_FOUND;
            String string = "Config IDs not found:" + (List)destination$iv$iv;
            throw new OpenSearchStatusException(string, restStatus, objectArray);
        }
        Iterable $this$forEach$iv = configDocs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotificationConfigDocInfo it = (NotificationConfigDocInfo)element$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.getConfigDoc().getConfig().getConfigType().ordinal()]) {
                case 1: {
                    if (!Intrinsics.areEqual((Object)it.getDocInfo().getId(), (Object)email.getEmailAccountID())) break;
                    Metrics.NOTIFICATIONS_CONFIG_USER_ERROR_INVALID_EMAIL_ACCOUNT_ID.getCounter().increment();
                    throw new OpenSearchStatusException("configId " + it.getDocInfo().getId() + " is not a valid email account ID", RestStatus.NOT_ACCEPTABLE, new Object[0]);
                }
                case 2: {
                    if (Intrinsics.areEqual((Object)it.getDocInfo().getId(), (Object)email.getEmailAccountID())) break;
                    Metrics.NOTIFICATIONS_CONFIG_USER_ERROR_INVALID_EMAIL_GROUP_ID.getCounter().increment();
                    throw new OpenSearchStatusException("configId " + it.getDocInfo().getId() + " is not a valid email group ID", RestStatus.NOT_ACCEPTABLE, new Object[0]);
                }
                case 3: {
                    if (Intrinsics.areEqual((Object)it.getDocInfo().getId(), (Object)email.getEmailAccountID())) break;
                    Metrics.NOTIFICATIONS_CONFIG_USER_ERROR_INVALID_EMAIL_GROUP_ID.getCounter().increment();
                    throw new OpenSearchStatusException("configId " + it.getDocInfo().getId() + " is not a valid email group ID", RestStatus.NOT_ACCEPTABLE, new Object[0]);
                }
                default: {
                    Metrics.NOTIFICATIONS_CONFIG_USER_ERROR_NEITHER_EMAIL_NOR_GROUP.getCounter().increment();
                    throw new OpenSearchStatusException("configId " + it.getDocInfo().getId() + " is not a valid email group ID or email account ID", RestStatus.NOT_ACCEPTABLE, new Object[0]);
                }
            }
            DocMetadata currentMetadata = it.getConfigDoc().getMetadata();
            UserAccess userAccess = ConfigIndexingActions.userAccess;
            if (userAccess == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                userAccess = null;
            }
            if (userAccess.doesUserHaveAccess(user, currentMetadata.getAccess())) continue;
            Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("Permission denied for NotificationConfig " + it.getDocInfo().getId(), RestStatus.FORBIDDEN, new Object[0]);
        }
    }

    private final void validateSmtpAccountConfig(SmtpAccount smtpAccount, User user) {
    }

    private final void validateSesAccountConfig(SesAccount sesAccount, User user) {
    }

    private final void validateEmailGroupConfig(EmailGroup emailGroup, User user) {
    }

    private final void validateConfig(NotificationConfig config, User user) {
        switch (WhenMappings.$EnumSwitchMapping$0[config.getConfigType().ordinal()]) {
            case 4: {
                throw new OpenSearchStatusException("NotificationConfig with type NONE is not acceptable", RestStatus.NOT_ACCEPTABLE, new Object[0]);
            }
            case 5: {
                BaseConfigData baseConfigData = config.getConfigData();
                if (baseConfigData == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.opensearch.commons.notifications.model.Slack");
                }
                this.validateSlackConfig((Slack)baseConfigData, user);
                break;
            }
            case 6: {
                BaseConfigData baseConfigData = config.getConfigData();
                if (baseConfigData == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.opensearch.commons.notifications.model.Chime");
                }
                this.validateChimeConfig((Chime)baseConfigData, user);
                break;
            }
            case 7: {
                BaseConfigData baseConfigData = config.getConfigData();
                if (baseConfigData == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.opensearch.commons.notifications.model.Webhook");
                }
                this.validateWebhookConfig((Webhook)baseConfigData, user);
                break;
            }
            case 8: {
                BaseConfigData baseConfigData = config.getConfigData();
                if (baseConfigData == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.opensearch.commons.notifications.model.Email");
                }
                this.validateEmailConfig((Email)baseConfigData, user);
                break;
            }
            case 2: {
                BaseConfigData baseConfigData = config.getConfigData();
                if (baseConfigData == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.opensearch.commons.notifications.model.SmtpAccount");
                }
                this.validateSmtpAccountConfig((SmtpAccount)baseConfigData, user);
                break;
            }
            case 3: {
                BaseConfigData baseConfigData = config.getConfigData();
                if (baseConfigData == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.opensearch.commons.notifications.model.SesAccount");
                }
                this.validateSesAccountConfig((SesAccount)baseConfigData, user);
                break;
            }
            case 1: {
                BaseConfigData baseConfigData = config.getConfigData();
                if (baseConfigData == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.opensearch.commons.notifications.model.EmailGroup");
                }
                this.validateEmailGroupConfig((EmailGroup)baseConfigData, user);
                break;
            }
            case 9: {
                BaseConfigData baseConfigData = config.getConfigData();
                if (baseConfigData == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.opensearch.commons.notifications.model.Sns");
                }
                this.validateSnsConfig((Sns)baseConfigData, user);
            }
        }
    }

    @NotNull
    public final CreateNotificationConfigResponse create(@NotNull CreateNotificationConfigRequest request, @Nullable User user) {
        String docId;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.getLog().info("notifications:NotificationConfig-create");
        UserAccess userAccess = ConfigIndexingActions.userAccess;
        if (userAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
            userAccess = null;
        }
        userAccess.validateUser(user);
        this.validateConfig(request.getNotificationConfig(), user);
        Instant currentTime = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)currentTime, (String)"currentTime");
        UserAccess userAccess2 = ConfigIndexingActions.userAccess;
        if (userAccess2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
            userAccess2 = null;
        }
        DocMetadata metadata = new DocMetadata(currentTime, currentTime, userAccess2.getAllAccessInfo(user));
        NotificationConfigDoc configDoc = new NotificationConfigDoc(metadata, request.getNotificationConfig());
        ConfigOperations configOperations = operations;
        if (configOperations == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
            configOperations = null;
        }
        if ((docId = configOperations.createNotificationConfig(configDoc, request.getConfigId())) == null) {
            ConfigIndexingActions $this$create_u24lambda_u2d3 = this;
            boolean bl = false;
            Metrics.NOTIFICATIONS_CONFIG_CREATE_SYSTEM_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("NotificationConfig Creation failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        return new CreateNotificationConfigResponse(docId);
    }

    @NotNull
    public final UpdateNotificationConfigResponse update(@NotNull UpdateNotificationConfigRequest request, @Nullable User user) {
        NotificationConfigDocInfo currentConfigDoc;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.getLog().info("notifications:NotificationConfig-update " + request.getConfigId());
        UserAccess userAccess = ConfigIndexingActions.userAccess;
        if (userAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
            userAccess = null;
        }
        userAccess.validateUser(user);
        this.validateConfig(request.getNotificationConfig(), user);
        ConfigOperations configOperations = operations;
        if (configOperations == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
            configOperations = null;
        }
        if ((currentConfigDoc = configOperations.getNotificationConfig(request.getConfigId())) == null) {
            ConfigIndexingActions $this$update_u24lambda_u2d4 = this;
            boolean bl = false;
            Metrics.NOTIFICATIONS_CONFIG_UPDATE_USER_ERROR_INVALID_CONFIG_ID.getCounter().increment();
            throw new OpenSearchStatusException("NotificationConfig " + request.getConfigId() + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        DocMetadata currentMetadata = currentConfigDoc.getConfigDoc().getMetadata();
        UserAccess userAccess2 = ConfigIndexingActions.userAccess;
        if (userAccess2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
            userAccess2 = null;
        }
        if (!userAccess2.doesUserHaveAccess(user, currentMetadata.getAccess())) {
            Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("Permission denied for NotificationConfig " + request.getConfigId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        if (currentConfigDoc.getConfigDoc().getConfig().getConfigType() != request.getNotificationConfig().getConfigType()) {
            throw new OpenSearchStatusException("Config type cannot be changed after creation", RestStatus.CONFLICT, new Object[0]);
        }
        Instant bl = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"now()");
        DocMetadata newMetadata = DocMetadata.copy$default(currentMetadata, bl, null, null, 6, null);
        NotificationConfigDoc newConfigData = new NotificationConfigDoc(newMetadata, request.getNotificationConfig());
        ConfigOperations configOperations2 = operations;
        if (configOperations2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
            configOperations2 = null;
        }
        if (!configOperations2.updateNotificationConfig(request.getConfigId(), newConfigData)) {
            Metrics.NOTIFICATIONS_CONFIG_UPDATE_SYSTEM_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("NotificationConfig Update failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        return new UpdateNotificationConfigResponse(request.getConfigId());
    }

    @NotNull
    public final GetNotificationConfigResponse get(@NotNull GetNotificationConfigRequest request, @Nullable User user) {
        GetNotificationConfigResponse getNotificationConfigResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.getLog().info("notifications:NotificationConfig-get " + request);
        UserAccess userAccess = ConfigIndexingActions.userAccess;
        if (userAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
            userAccess = null;
        }
        userAccess.validateUser(user);
        switch (request.getConfigIds().size()) {
            case 0: {
                getNotificationConfigResponse = this.getAll(request, user);
                break;
            }
            case 1: {
                getNotificationConfigResponse = this.info((String)CollectionsKt.first((Iterable)request.getConfigIds()), user);
                break;
            }
            default: {
                getNotificationConfigResponse = this.info(request.getConfigIds(), user);
            }
        }
        return getNotificationConfigResponse;
    }

    private final GetNotificationConfigResponse info(String configId, User user) {
        NotificationConfigDocInfo configDoc;
        this.getLog().info("notifications:NotificationConfig-info " + configId);
        ConfigOperations configOperations = operations;
        if (configOperations == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
            configOperations = null;
        }
        if ((configDoc = configOperations.getNotificationConfig(configId)) == null) {
            ConfigIndexingActions $this$info_u24lambda_u2d5 = this;
            boolean bl = false;
            Metrics.NOTIFICATIONS_CONFIG_INFO_USER_ERROR_INVALID_CONFIG_ID.getCounter().increment();
            throw new OpenSearchStatusException("NotificationConfig " + configId + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        DocMetadata metadata = configDoc.getConfigDoc().getMetadata();
        UserAccess userAccess = ConfigIndexingActions.userAccess;
        if (userAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
            userAccess = null;
        }
        if (!userAccess.doesUserHaveAccess(user, metadata.getAccess())) {
            Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("Permission denied for NotificationConfig " + configId, RestStatus.FORBIDDEN, new Object[0]);
        }
        NotificationConfigInfo configInfo = new NotificationConfigInfo(configId, metadata.getLastUpdateTime(), metadata.getCreatedTime(), configDoc.getConfigDoc().getConfig());
        return new GetNotificationConfigResponse(new NotificationConfigSearchResult(configInfo));
    }

    /*
     * WARNING - void declaration
     */
    private final GetNotificationConfigResponse info(Set<String> configIds, User user) {
        void $this$mapTo$iv$iv;
        Object element$iv3;
        List<NotificationConfigDocInfo> configDocs;
        this.getLog().info("notifications:NotificationConfig-info " + configIds);
        ConfigOperations configOperations = operations;
        if (configOperations == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
            configOperations = null;
        }
        if ((configDocs = configOperations.getNotificationConfigs(configIds)).size() != configIds.size()) {
            Set mutableSet = CollectionsKt.toMutableSet((Iterable)configIds);
            Iterable $this$forEach$iv = configDocs;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                NotificationConfigDocInfo it = (NotificationConfigDocInfo)element$iv2;
                boolean bl = false;
                ((Collection)mutableSet).remove(it.getDocInfo().getId());
            }
            Metrics.NOTIFICATIONS_CONFIG_INFO_USER_ERROR_SET_NOT_FOUND.getCounter().increment();
            throw new OpenSearchStatusException("NotificationConfig " + mutableSet + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        Iterable $this$forEach$iv = configDocs;
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            NotificationConfigDocInfo it = (NotificationConfigDocInfo)element$iv3;
            boolean bl = false;
            DocMetadata currentMetadata = it.getConfigDoc().getMetadata();
            UserAccess userAccess = ConfigIndexingActions.userAccess;
            if (userAccess == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                userAccess = null;
            }
            if (userAccess.doesUserHaveAccess(user, currentMetadata.getAccess())) continue;
            Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("Permission denied for NotificationConfig " + it.getDocInfo().getId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        Iterable $this$map$iv = configDocs;
        boolean $i$f$map = false;
        element$iv3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NotificationConfigDocInfo notificationConfigDocInfo = (NotificationConfigDocInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getDocInfo().getId();
            Intrinsics.checkNotNull((Object)string);
            collection.add(new NotificationConfigInfo(string, it.getConfigDoc().getMetadata().getLastUpdateTime(), it.getConfigDoc().getMetadata().getCreatedTime(), it.getConfigDoc().getConfig()));
        }
        List configSearchResult = (List)destination$iv$iv;
        return new GetNotificationConfigResponse(new NotificationConfigSearchResult(configSearchResult));
    }

    private final GetNotificationConfigResponse getAll(GetNotificationConfigRequest request, User user) {
        UserAccess userAccess;
        this.getLog().info("notifications:NotificationConfig-getAll");
        ConfigOperations configOperations = operations;
        if (configOperations == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
            configOperations = null;
        }
        if ((userAccess = ConfigIndexingActions.userAccess) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
            userAccess = null;
        }
        NotificationConfigSearchResult searchResult = configOperations.getAllNotificationConfigs(userAccess.getSearchAccessInfo(user), request);
        return new GetNotificationConfigResponse(searchResult);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GetChannelListResponse getChannelList(@NotNull GetChannelListRequest request, @Nullable User user) {
        void $this$mapTo$iv$iv;
        UserAccess userAccess;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.getLog().info("notifications:getChannelList " + request);
        UserAccess userAccess2 = ConfigIndexingActions.userAccess;
        if (userAccess2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
            userAccess2 = null;
        }
        userAccess2.validateUser(user);
        String supportedChannelListString = CollectionsKt.joinToString$default((Iterable)this.getSupportedChannelList(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        Map filterParams = MapsKt.mapOf((Pair)new Pair((Object)"config_type", (Object)supportedChannelListString));
        GetNotificationConfigRequest getAllRequest = new GetNotificationConfigRequest(null, 0, 0, null, null, filterParams, 31, null);
        ConfigOperations configOperations = operations;
        if (configOperations == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
            configOperations = null;
        }
        if ((userAccess = ConfigIndexingActions.userAccess) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
            userAccess = null;
        }
        NotificationConfigSearchResult getAllResult = configOperations.getAllNotificationConfigs(userAccess.getSearchAccessInfo(user), getAllRequest);
        Iterable $this$map$iv = getAllResult.getObjectList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NotificationConfigInfo notificationConfigInfo = (NotificationConfigInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String configId = it.getConfigId();
            NotificationConfig config = it.getNotificationConfig();
            collection.add(new Channel(configId, config.getName(), config.getDescription(), config.getConfigType(), config.isEnabled()));
        }
        List searchResult = (List)destination$iv$iv;
        ChannelList ChannelList2 = new ChannelList(searchResult);
        return new GetChannelListResponse(ChannelList2);
    }

    private final List<String> getSupportedChannelList() {
        Object[] objectArray = new String[]{ConfigType.SLACK.getTag(), ConfigType.CHIME.getTag(), ConfigType.WEBHOOK.getTag(), ConfigType.EMAIL.getTag(), ConfigType.SNS.getTag()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final DeleteNotificationConfigResponse delete(String configId, User user) {
        NotificationConfigDocInfo currentConfigDoc;
        this.getLog().info("notifications:NotificationConfig-delete " + configId);
        UserAccess userAccess = ConfigIndexingActions.userAccess;
        if (userAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
            userAccess = null;
        }
        userAccess.validateUser(user);
        ConfigOperations configOperations = operations;
        if (configOperations == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
            configOperations = null;
        }
        if ((currentConfigDoc = configOperations.getNotificationConfig(configId)) == null) {
            ConfigIndexingActions $this$delete_u24lambda_u2d10 = this;
            boolean bl = false;
            Metrics.NOTIFICATIONS_CONFIG_DELETE_USER_ERROR_INVALID_CONFIG_ID.getCounter().increment();
            throw new OpenSearchStatusException("NotificationConfig " + configId + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        DocMetadata currentMetadata = currentConfigDoc.getConfigDoc().getMetadata();
        UserAccess userAccess2 = ConfigIndexingActions.userAccess;
        if (userAccess2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
            userAccess2 = null;
        }
        if (!userAccess2.doesUserHaveAccess(user, currentMetadata.getAccess())) {
            Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("Permission denied for NotificationConfig " + configId, RestStatus.FORBIDDEN, new Object[0]);
        }
        ConfigOperations configOperations2 = operations;
        if (configOperations2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
            configOperations2 = null;
        }
        if (!configOperations2.deleteNotificationConfig(configId)) {
            Metrics.NOTIFICATIONS_CONFIG_DELETE_SYSTEM_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("NotificationConfig " + configId + " delete failed", RestStatus.REQUEST_TIMEOUT, new Object[0]);
        }
        return new DeleteNotificationConfigResponse(MapsKt.mapOf((Pair)new Pair((Object)configId, (Object)RestStatus.OK)));
    }

    private final DeleteNotificationConfigResponse delete(Set<String> configIds, User user) {
        List<NotificationConfigDocInfo> configDocs;
        this.getLog().info("notifications:NotificationConfig-delete " + configIds);
        UserAccess userAccess = ConfigIndexingActions.userAccess;
        if (userAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
            userAccess = null;
        }
        userAccess.validateUser(user);
        ConfigOperations configOperations = operations;
        if (configOperations == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
            configOperations = null;
        }
        if ((configDocs = configOperations.getNotificationConfigs(configIds)).size() != configIds.size()) {
            Set mutableSet = CollectionsKt.toMutableSet((Iterable)configIds);
            Iterable $this$forEach$iv = configDocs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NotificationConfigDocInfo it = (NotificationConfigDocInfo)element$iv;
                boolean bl = false;
                ((Collection)mutableSet).remove(it.getDocInfo().getId());
            }
            Metrics.NOTIFICATIONS_CONFIG_DELETE_USER_ERROR_SET_NOT_FOUND.getCounter().increment();
            throw new OpenSearchStatusException("NotificationConfig " + mutableSet + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        Iterable $this$forEach$iv = configDocs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotificationConfigDocInfo it = (NotificationConfigDocInfo)element$iv;
            boolean bl = false;
            DocMetadata currentMetadata = it.getConfigDoc().getMetadata();
            UserAccess userAccess2 = ConfigIndexingActions.userAccess;
            if (userAccess2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                userAccess2 = null;
            }
            if (userAccess2.doesUserHaveAccess(user, currentMetadata.getAccess())) continue;
            Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("Permission denied for NotificationConfig " + it.getDocInfo().getId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        ConfigOperations configOperations2 = operations;
        if (configOperations2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
            configOperations2 = null;
        }
        Map<String, RestStatus> deleteStatus = configOperations2.deleteNotificationConfigs(configIds);
        return new DeleteNotificationConfigResponse(deleteStatus);
    }

    @NotNull
    public final DeleteNotificationConfigResponse delete(@NotNull DeleteNotificationConfigRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.getLog().info("notifications:NotificationConfig-delete " + request.getConfigIds());
        return request.getConfigIds().size() == 1 ? this.delete((String)CollectionsKt.first((Iterable)request.getConfigIds()), user) : this.delete(request.getConfigIds(), user);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConfigType.values().length];
            nArray[ConfigType.EMAIL_GROUP.ordinal()] = 1;
            nArray[ConfigType.SMTP_ACCOUNT.ordinal()] = 2;
            nArray[ConfigType.SES_ACCOUNT.ordinal()] = 3;
            nArray[ConfigType.NONE.ordinal()] = 4;
            nArray[ConfigType.SLACK.ordinal()] = 5;
            nArray[ConfigType.CHIME.ordinal()] = 6;
            nArray[ConfigType.WEBHOOK.ordinal()] = 7;
            nArray[ConfigType.EMAIL.ordinal()] = 8;
            nArray[ConfigType.SNS.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

