/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.destination.factory;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.alerting.destination.client.DestinationEmailClient;
import org.opensearch.alerting.destination.client.DestinationEmailClientPool;
import org.opensearch.alerting.destination.factory.DestinationFactory;
import org.opensearch.alerting.destination.message.EmailMessage;
import org.opensearch.alerting.destination.response.DestinationResponse;

public class EmailDestinationFactory
implements DestinationFactory<EmailMessage, DestinationEmailClient> {
    private DestinationEmailClient destinationEmailClient = DestinationEmailClientPool.getEmailClient();
    private static final Logger logger = LogManager.getLogger(EmailDestinationFactory.class);

    public DestinationResponse publish(EmailMessage message) {
        try {
            String response = this.getClient(message).execute(message);
            int status = response.equals("Sent") ? 0 : 1;
            return new DestinationResponse.Builder().withStatusCode(status).withResponseContent(response).build();
        }
        catch (Exception ex) {
            logger.error("Exception publishing Message: " + message.toString(), (Throwable)ex);
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public DestinationEmailClient getClient(EmailMessage message) {
        return this.destinationEmailClient;
    }

    public void setClient(DestinationEmailClient client) {
        this.destinationEmailClient = client;
    }
}

