/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.util;

import org.opensearch.OpenSearchException;

public class ExceptionUtils {
    public static Throwable getRootCause(Throwable e) {
        if (e == null) {
            return null;
        }
        Throwable cause = e.getCause();
        if (cause == null) {
            return e;
        }
        return ExceptionUtils.getRootCause(cause);
    }

    public static Throwable findMsg(Throwable e, String msg) {
        if (e == null) {
            return null;
        }
        if (e.getMessage() != null && e.getMessage().contains(msg)) {
            return e;
        }
        Throwable cause = e.getCause();
        if (cause == null) {
            return null;
        }
        return ExceptionUtils.findMsg(cause, msg);
    }

    public static OpenSearchException createBadHeaderException() {
        return new OpenSearchException("Illegal parameter in http or transport request found." + System.lineSeparator() + "This means that one node is trying to connect to another with " + System.lineSeparator() + "a non-node certificate (no OID or security.nodes_dn incorrect configured) or that someone " + System.lineSeparator() + "is spoofing requests. Check your TLS certificate setup as described here: See https://opendistro.github.io/for-elasticsearch-docs/docs/troubleshoot/tls/", new Object[0]);
    }

    public static OpenSearchException createTransportClientNoLongerSupportedException() {
        return new OpenSearchException("Transport client authentication no longer supported.", new Object[0]);
    }
}

