/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.filter;

import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.greenrobot.eventbus.Subscribe;
import org.opensearch.OpenSearchException;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.settings.Settings;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.auth.BackendRegistry;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.CompatConfig;
import org.opensearch.security.securityconf.impl.WhitelistingSettings;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.security.ssl.util.ExceptionUtils;
import org.opensearch.security.ssl.util.SSLRequestHelper;
import org.opensearch.security.support.HTTPHelper;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;

public class SecurityRestFilter {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final BackendRegistry registry;
    private final AuditLog auditLog;
    private final org.opensearch.common.util.concurrent.ThreadContext threadContext;
    private final PrincipalExtractor principalExtractor;
    private final Settings settings;
    private final Path configPath;
    private final CompatConfig compatConfig;
    private WhitelistingSettings whitelistingSettings;
    private static final String HEALTH_SUFFIX = "health";
    private static final String WHO_AM_I_SUFFIX = "whoami";
    private static final String REGEX_PATH_PREFIX = "/(_opendistro/_security|_plugins/_security)/(.*)";
    private static final Pattern PATTERN_PATH_PREFIX = Pattern.compile("/(_opendistro/_security|_plugins/_security)/(.*)");

    public SecurityRestFilter(BackendRegistry registry, AuditLog auditLog, ThreadPool threadPool, PrincipalExtractor principalExtractor, Settings settings, Path configPath, CompatConfig compatConfig) {
        this.registry = registry;
        this.auditLog = auditLog;
        this.threadContext = threadPool.getThreadContext();
        this.principalExtractor = principalExtractor;
        this.settings = settings;
        this.configPath = configPath;
        this.compatConfig = compatConfig;
        this.whitelistingSettings = new WhitelistingSettings();
    }

    public RestHandler wrap(final RestHandler original, final AdminDNs adminDNs) {
        return new RestHandler(){

            public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
                User user;
                ThreadContext.clearAll();
                if (!SecurityRestFilter.this.checkAndAuthenticateRequest(request, channel, client) && (SecurityRestFilter.this.userIsSuperAdmin(user = (User)SecurityRestFilter.this.threadContext.getTransient("_opendistro_security_user"), adminDNs) || SecurityRestFilter.this.whitelistingSettings.checkRequestIsAllowed(request, channel, client))) {
                    original.handleRequest(request, channel, client);
                }
            }
        };
    }

    private boolean userIsSuperAdmin(User user, AdminDNs adminDNs) {
        return user != null && adminDNs.isAdmin(user);
    }

    private boolean checkAndAuthenticateRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        String suffix;
        this.threadContext.putTransient("_opendistro_security_origin", (Object)AuditLog.Origin.REST.toString());
        if (HTTPHelper.containsBadHeader(request)) {
            OpenSearchException exception = ExceptionUtils.createBadHeaderException();
            this.log.error(exception.toString());
            this.auditLog.logBadHeaders(request);
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.FORBIDDEN, (Exception)exception));
            return true;
        }
        if (SSLRequestHelper.containsBadHeader(this.threadContext, "_opendistro_security_")) {
            OpenSearchException exception = ExceptionUtils.createBadHeaderException();
            this.log.error(exception.toString());
            this.auditLog.logBadHeaders(request);
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.FORBIDDEN, (Exception)exception));
            return true;
        }
        try {
            SSLRequestHelper.SSLInfo sslInfo = SSLRequestHelper.getSSLInfo(this.settings, this.configPath, request, this.principalExtractor);
            if (sslInfo != null) {
                if (sslInfo.getPrincipal() != null) {
                    this.threadContext.putTransient("_opendistro_security_ssl_principal", (Object)sslInfo.getPrincipal());
                }
                if (sslInfo.getX509Certs() != null) {
                    this.threadContext.putTransient("_opendistro_security_ssl_peer_certificates", (Object)sslInfo.getX509Certs());
                }
                this.threadContext.putTransient("_opendistro_security_ssl_protocol", (Object)sslInfo.getProtocol());
                this.threadContext.putTransient("_opendistro_security_ssl_cipher", (Object)sslInfo.getCipher());
            }
        }
        catch (SSLPeerUnverifiedException e) {
            this.log.error("No ssl info", (Throwable)e);
            this.auditLog.logSSLException(request, e);
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.FORBIDDEN, (Exception)e));
            return true;
        }
        if (!this.compatConfig.restAuthEnabled()) {
            return false;
        }
        Matcher matcher = PATTERN_PATH_PREFIX.matcher(request.path());
        String string = suffix = matcher.matches() ? matcher.group(2) : null;
        if (request.method() != RestRequest.Method.OPTIONS && !HEALTH_SUFFIX.equals(suffix) && !WHO_AM_I_SUFFIX.equals(suffix)) {
            if (!this.registry.authenticate(request, channel, this.threadContext)) {
                ThreadContext.remove((String)"user");
                return true;
            }
            ThreadContext.put((String)"user", (String)((User)this.threadContext.getTransient("_opendistro_security_user")).getName());
        }
        return false;
    }

    @Subscribe
    public void onWhitelistingSettingChanged(WhitelistingSettings whitelistingSettings) {
        this.whitelistingSettings = whitelistingSettings;
    }
}

