/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.validation;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.settings.Settings;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.configuration.MaskedField;
import org.opensearch.security.configuration.Salt;
import org.opensearch.security.dlic.rest.validation.AbstractConfigurationValidator;

public class RolesValidator
extends AbstractConfigurationValidator {
    private static final Salt SALT = new Salt(new byte[]{1, 2, 3, 4, 5, 1, 2, 3, 4, 5, 1, 2, 3, 4, 5, 6});

    public RolesValidator(RestRequest request, boolean isSuperAdmin, BytesReference ref, Settings opensearchSettings, Object ... param) {
        super(request, ref, opensearchSettings, param);
        this.payloadMandatory = true;
        this.allowedKeys.put("cluster_permissions", AbstractConfigurationValidator.DataType.ARRAY);
        this.allowedKeys.put("tenant_permissions", AbstractConfigurationValidator.DataType.ARRAY);
        this.allowedKeys.put("index_permissions", AbstractConfigurationValidator.DataType.ARRAY);
        this.allowedKeys.put("description", AbstractConfigurationValidator.DataType.STRING);
        if (isSuperAdmin) {
            this.allowedKeys.put("reserved", AbstractConfigurationValidator.DataType.BOOLEAN);
        }
    }

    @Override
    public boolean validate() {
        DocumentContext ctx;
        List maskedFields;
        if (!super.validate()) {
            return false;
        }
        boolean valid = true;
        if (this.content != null && this.content.length() > 0 && (maskedFields = (List)(ctx = JsonPath.parse((String)this.content.utf8ToString())).read("$..masked_fields[*]", new Predicate[0])) != null) {
            for (String mf : maskedFields) {
                if (this.validateMaskedFieldSyntax(mf)) continue;
                valid = false;
            }
        }
        if (!valid) {
            this.errorType = AbstractConfigurationValidator.ErrorType.WRONG_DATATYPE;
        }
        return valid;
    }

    private boolean validateMaskedFieldSyntax(String mf) {
        try {
            new MaskedField(mf, SALT).isValid();
        }
        catch (Exception e) {
            this.wrongDatatypes.put("Masked field not valid: " + mf, e.getMessage());
            return false;
        }
        return true;
    }
}

