/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auditlog;

import org.opensearch.OpenSearchException;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.ssl.SslExceptionHandler;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportRequest;

public class AuditLogSslExceptionHandler
implements SslExceptionHandler {
    private final AuditLog auditLog;

    public AuditLogSslExceptionHandler(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    @Override
    public void logError(Throwable t, RestRequest request, int type) {
        switch (type) {
            case 0: {
                this.auditLog.logSSLException(request, t);
                break;
            }
            case 1: {
                this.auditLog.logBadHeaders(request);
                break;
            }
        }
    }

    @Override
    public void logError(Throwable t, boolean isRest) {
        if (isRest) {
            this.auditLog.logSSLException(null, t);
        } else {
            this.auditLog.logSSLException(null, t, null, null);
        }
    }

    @Override
    public void logError(Throwable t, TransportRequest request, String action, Task task, int type) {
        switch (type) {
            case 0: {
                if (t instanceof OpenSearchException) {
                    this.auditLog.logMissingPrivileges(action, request, task);
                    break;
                }
                this.auditLog.logSSLException(request, t, action, task);
                break;
            }
            case 1: {
                this.auditLog.logBadHeaders(request, action, task);
                break;
            }
        }
    }
}

