/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.http_action.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessControlException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.performanceanalyzer.config.PluginSettings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;

public class PerformanceAnalyzerResourceProvider
extends BaseRestHandler {
    private static final Logger LOG = LogManager.getLogger(PerformanceAnalyzerResourceProvider.class);
    private static final int HTTP_CLIENT_CONNECTION_TIMEOUT_MILLIS = 200;
    private static final String AGENT_PATH = "/_plugins/_performanceanalyzer/_agent/";
    private static final String LEGACY_AGENT_PATH = "/_opendistro/_performanceanalyzer/_agent/";
    private static final String DEFAULT_PORT_NUMBER = "9600";
    private String portNumber;
    private final boolean isHttpsEnabled;
    private static Set<String> SUPPORTED_REDIRECTIONS = ImmutableSet.of((Object)"rca", (Object)"metrics", (Object)"batch", (Object)"actions");
    private static final List<RestHandler.ReplacedRoute> REPLACED_ROUTES = Collections.singletonList(new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_performanceanalyzer/_agent/{redirectEndpoint}", RestRequest.Method.GET, "/_opendistro/_performanceanalyzer/_agent/{redirectEndpoint}"));

    @Inject
    public PerformanceAnalyzerResourceProvider(Settings settings, RestController controller) {
        PluginSettings pluginSettings = PluginSettings.instance();
        this.portNumber = pluginSettings.getSettingValue("webservice-listener-port", DEFAULT_PORT_NUMBER);
        this.isHttpsEnabled = pluginSettings.getHttpsEnabled();
        if (this.isHttpsEnabled) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            }
            catch (AccessControlException e) {
                LOG.warn("SecurityManager forbids setting default SSL Socket Factory...using default settings", (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn("Error encountered while initializing SSLContext...using default settings", (Throwable)e);
            }
            HostnameVerifier allHostsValid = (hostname, session) -> true;
            try {
                HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            }
            catch (AccessControlException e) {
                LOG.warn("SecurityManager forbids setting default hostname verifier...using default settings", (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn("Error encountered while initializing hostname verifier...using default settings", (Throwable)e);
            }
        }
    }

    public String getName() {
        return "PerformanceAnalyzer_ResourceProvider";
    }

    public List<RestHandler.Route> routes() {
        return Collections.emptyList();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return REPLACED_ROUTES;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        StringBuilder response = new StringBuilder();
        URL url = this.getAgentUri(request);
        if (url == null) {
            return channel -> {
                BytesRestResponse finalResponse = new BytesRestResponse(RestStatus.NOT_FOUND, "");
                channel.sendResponse((RestResponse)finalResponse);
            };
        }
        HttpURLConnection httpURLConnection = this.isHttpsEnabled ? this.createHttpsURLConnection(url) : this.createHttpURLConnection(url);
        int responseCode = httpURLConnection.getResponseCode();
        InputStream inputStream = responseCode == 200 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            LOG.debug("Response received - {}", (Object)response);
        }
        catch (Exception ex) {
            LOG.error("Error receiving response for Request Uri {} - {}", (Object)request.uri(), (Object)ex);
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, "Encountered error possibly with downstream APIs"));
        }
        BytesRestResponse finalResponse = new BytesRestResponse(RestStatus.fromCode((int)responseCode), String.valueOf(response));
        LOG.debug("finalResponse: {}", (Object)finalResponse);
        return arg_0 -> PerformanceAnalyzerResourceProvider.lambda$prepareRequest$3(httpURLConnection, (RestResponse)finalResponse, arg_0);
    }

    private HttpURLConnection createHttpsURLConnection(URL url) throws IOException {
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)url.openConnection();
        httpsURLConnection.setConnectTimeout(200);
        return httpsURLConnection;
    }

    private HttpURLConnection createHttpURLConnection(URL url) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setConnectTimeout(200);
        return httpURLConnection;
    }

    @VisibleForTesting
    void setPortNumber(String portNumber) {
        this.portNumber = portNumber;
    }

    public URL getAgentUri(RestRequest request) throws IOException {
        String redirectEndpoint = request.param("redirectEndpoint");
        String urlScheme = this.isHttpsEnabled ? "https://" : "http://";
        String redirectBasePath = urlScheme + "localhost:" + this.portNumber + "/_plugins/_performanceanalyzer/";
        for (String key : request.params().keySet()) {
            request.param(key);
        }
        if (SUPPORTED_REDIRECTIONS.contains(redirectEndpoint)) {
            String uri = null;
            if (request.uri().contains(AGENT_PATH)) {
                uri = redirectBasePath + request.uri().split(AGENT_PATH)[1];
            } else if (request.uri().contains(LEGACY_AGENT_PATH)) {
                uri = redirectBasePath + request.uri().split(LEGACY_AGENT_PATH)[1];
            } else {
                throw new IOException();
            }
            return new URL(uri);
        }
        return null;
    }

    private static /* synthetic */ void lambda$prepareRequest$3(HttpURLConnection httpURLConnection, RestResponse finalResponse, RestChannel channel) throws Exception {
        try {
            Map<String, List<String>> map = httpURLConnection.getHeaderFields();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                finalResponse.addHeader(entry.getKey(), entry.getValue().toString());
            }
            channel.sendResponse(finalResponse);
        }
        catch (Exception ex) {
            LOG.error("Error sending response", (Throwable)ex);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, "Something went wrong"));
        }
    }
}

