/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.TableLike;
import org.jooq.True;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.DBUtils;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.config.TroubleshootingConfig;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.metricsdb.Dimensions;
import org.opensearch.performanceanalyzer.metricsdb.Metric;
import org.opensearch.performanceanalyzer.metricsdb.MetricsDB;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ReaderMetrics;
import org.opensearch.performanceanalyzer.reader.AdmissionControlSnapshot;
import org.opensearch.performanceanalyzer.reader.FaultDetectionMetricsSnapshot;
import org.opensearch.performanceanalyzer.reader.GarbageCollectorInfoSnapshot;
import org.opensearch.performanceanalyzer.reader.HttpRequestMetricsSnapshot;
import org.opensearch.performanceanalyzer.reader.MasterEventMetricsSnapshot;
import org.opensearch.performanceanalyzer.reader.MasterThrottlingMetricsSnapshot;
import org.opensearch.performanceanalyzer.reader.MemoryDBSnapshot;
import org.opensearch.performanceanalyzer.reader.OSMetricsSnapshot;
import org.opensearch.performanceanalyzer.reader.ShardRequestMetricsSnapshot;
import org.opensearch.performanceanalyzer.reader.ShardStateMetricsSnapshot;

public class MetricsEmitter {
    private static final Logger LOG = LogManager.getLogger(MetricsEmitter.class);
    private static final Pattern GC_PATTERN = Pattern.compile(".*(GC|CMS|Parallel).*");
    private static final Pattern REFRESH_PATTERN = Pattern.compile(".*opensearch.*\\[refresh\\].*");
    private static final Pattern MANAGEMENT_PATTERN = Pattern.compile(".*opensearch.*\\[management\\].*");
    private static final Pattern MERGE_PATTERN = Pattern.compile(".*opensearch\\[.*\\]\\[\\[(.*)\\]\\[(.*)\\].*Lucene Merge.*");
    private static final Pattern SEARCH_PATTERN = Pattern.compile(".*opensearch.*\\[search\\].*");
    private static final Pattern BULK_PATTERN = Pattern.compile(".*opensearch.*\\[bulk\\].*");
    private static final Pattern GENERIC_PATTERN = Pattern.compile(".*opensearch.*\\[generic\\].*");
    private static final Pattern GET_PATTERN = Pattern.compile(".*opensearch.*\\[get\\].*");
    private static final Pattern SNAPSHOT_PATTERN = Pattern.compile(".*opensearch.*\\[(snapshot|snapshot_segments)\\].*");
    private static final Pattern FLUSH_PATTERN = Pattern.compile(".*opensearch.*\\[flush\\].*");
    private static final Pattern WRITE_PATTERN = Pattern.compile(".*opensearch.*\\[write\\].*");
    private static final Pattern HTTP_SERVER_PATTERN = Pattern.compile(".*opensearch.*\\[http_server_worker\\].*");
    private static final Pattern TRANS_WORKER_PATTERN = Pattern.compile(".*opensearch.*\\[transport_worker.*");
    private static final List<String> LATENCY_TABLE_DIMENSIONS = new ArrayList<String>(){
        {
            this.add(ShardRequestMetricsSnapshot.Fields.OPERATION.toString());
            this.add(HttpRequestMetricsSnapshot.Fields.EXCEPTION.toString());
            this.add(HttpRequestMetricsSnapshot.Fields.INDICES.toString());
            this.add(HttpRequestMetricsSnapshot.Fields.HTTP_RESP_CODE.toString());
            this.add(ShardRequestMetricsSnapshot.Fields.SHARD_ID.toString());
            this.add(ShardRequestMetricsSnapshot.Fields.INDEX_NAME.toString());
            this.add(ShardRequestMetricsSnapshot.Fields.SHARD_ROLE.toString());
        }
    };
    private static final List<String> SHARD_STATE_TABLE_DIMENSIONS = new ArrayList<String>(){
        {
            this.add(AllMetrics.ShardStateDimension.INDEX_NAME.toString());
            this.add(AllMetrics.ShardStateDimension.SHARD_ID.toString());
            this.add(AllMetrics.ShardStateDimension.SHARD_TYPE.toString());
            this.add(AllMetrics.ShardStateDimension.NODE_NAME.toString());
            this.add(AllMetrics.ShardStateDimension.SHARD_STATE.toString());
        }
    };
    private static final List<String> FAULT_DETECTION_TABLE_DIMENSIONS = new ArrayList<String>(){
        {
            this.add(AllMetrics.FaultDetectionDimension.SOURCE_NODE_ID.toString());
            this.add(AllMetrics.FaultDetectionDimension.TARGET_NODE_ID.toString());
        }
    };

    public static void emitAggregatedOSMetrics(DSLContext create, MetricsDB db, OSMetricsSnapshot osMetricsSnap, ShardRequestMetricsSnapshot rqMetricsSnap) throws Exception {
        SelectHavingStep<Record> rqTable = rqMetricsSnap.fetchThreadUtilizationRatioTable();
        SelectHavingStep<Record> osTable = osMetricsSnap.selectAll();
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)ShardRequestMetricsSnapshot.Fields.SHARD_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)ShardRequestMetricsSnapshot.Fields.INDEX_NAME.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)ShardRequestMetricsSnapshot.Fields.OPERATION.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)ShardRequestMetricsSnapshot.Fields.SHARD_ROLE.toString()), String.class));
            }
        };
        for (AllMetrics.OSMetrics metric : AllMetrics.OSMetrics.values()) {
            fields.add((SelectField<?>)DSL.field((String)ShardRequestMetricsSnapshot.Fields.TUTIL.toString(), Double.class).mul(DSL.field((Name)DSL.name((String)metric.toString()), Double.class)).as(metric.toString()));
        }
        ArrayList groupByFields = new ArrayList<Field<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)ShardRequestMetricsSnapshot.Fields.SHARD_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)ShardRequestMetricsSnapshot.Fields.INDEX_NAME.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)ShardRequestMetricsSnapshot.Fields.OPERATION.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)ShardRequestMetricsSnapshot.Fields.SHARD_ROLE.toString()), String.class));
            }
        };
        ArrayList aggFields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)ShardRequestMetricsSnapshot.Fields.SHARD_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)ShardRequestMetricsSnapshot.Fields.INDEX_NAME.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)ShardRequestMetricsSnapshot.Fields.OPERATION.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)ShardRequestMetricsSnapshot.Fields.SHARD_ROLE.toString()), String.class));
            }
        };
        for (AllMetrics.OSMetrics metric : AllMetrics.OSMetrics.values()) {
            aggFields.add((SelectField<?>)DSL.sum((Field)DSL.field((Name)DSL.name((String)metric.toString()), Double.class)).as("sum_" + metric.toString()));
            aggFields.add((SelectField<?>)DSL.avg((Field)DSL.field((Name)DSL.name((String)metric.toString()), Double.class)).as("avg_" + metric.toString()));
            aggFields.add((SelectField<?>)DSL.min((Field)DSL.field((Name)DSL.name((String)metric.toString()), Double.class)).as("min_" + metric.toString()));
            aggFields.add((SelectField<?>)DSL.max((Field)DSL.field((Name)DSL.name((String)metric.toString()), Double.class)).as("max_" + metric.toString()));
        }
        long mCurrT = System.currentTimeMillis();
        Result res = create.select((Collection)aggFields).from((TableLike)create.select((Collection)fields).from(rqTable).join(osTable).on(new Condition[]{osTable.field(OSMetricsSnapshot.Fields.tid.toString(), String.class).eq(rqTable.field(OSMetricsSnapshot.Fields.tid.toString(), String.class))})).groupBy((Collection)groupByFields).fetch();
        long mFinalT = System.currentTimeMillis();
        LOG.debug("Total time taken for tid corelation: {}", (Object)(mFinalT - mCurrT));
        MetricsEmitter.checkInvalidData(rqTable, osTable, create);
        Set<String> metricColumns = osMetricsSnap.getMetricColumns();
        mCurrT = System.currentTimeMillis();
        for (String metricColumn : metricColumns) {
            ArrayList<String> dims = new ArrayList<String>(){
                {
                    this.add(AllMetrics.CommonDimension.SHARD_ID.toString());
                    this.add(AllMetrics.CommonDimension.INDEX_NAME.toString());
                    this.add(AllMetrics.CommonDimension.OPERATION.toString());
                    this.add(AllMetrics.CommonDimension.SHARD_ROLE.toString());
                }
            };
            db.createMetric(new Metric<Double>(metricColumn, 0.0), (List<String>)dims);
            BatchBindStep handle = db.startBatchPut(new Metric<Double>(metricColumn, 0.0), (List<String>)dims);
            for (Record r : res) {
                if (r.get("sum_" + metricColumn) == null) continue;
                Double sumMetric = Double.parseDouble(r.get("sum_" + metricColumn).toString());
                Double avgMetric = Double.parseDouble(r.get("avg_" + metricColumn).toString());
                Double minMetric = Double.parseDouble(r.get("min_" + metricColumn).toString());
                Double maxMetric = Double.parseDouble(r.get("max_" + metricColumn).toString());
                handle.bind(new Object[]{r.get(ShardRequestMetricsSnapshot.Fields.SHARD_ID.toString()).toString(), r.get(ShardRequestMetricsSnapshot.Fields.INDEX_NAME.toString()).toString(), r.get(ShardRequestMetricsSnapshot.Fields.OPERATION.toString()).toString(), r.get(ShardRequestMetricsSnapshot.Fields.SHARD_ROLE.toString()).toString(), sumMetric, avgMetric, minMetric, maxMetric});
            }
            if (handle.size() <= 0) continue;
            handle.execute();
        }
        mFinalT = System.currentTimeMillis();
        LOG.debug("Total time taken for writing resource metrics metricsdb: {}", (Object)(mFinalT - mCurrT));
    }

    private static void checkInvalidData(SelectHavingStep<Record> rqTable, SelectHavingStep<Record> osTable, DSLContext create) {
        if (!TroubleshootingConfig.getEnableDevAssert()) {
            return;
        }
        True condition = DSL.trueCondition();
        Field tidField = DSL.field((Name)DSL.name((String)OSMetricsSnapshot.Fields.tid.toString()), String.class);
        Field tNameField = DSL.field((Name)DSL.name((String)OSMetricsSnapshot.Fields.tName.toString()), String.class);
        Set<String> rqSet = DBUtils.getRecordSetByField(rqTable, tidField, (Condition)condition, create);
        condition = tNameField.contains((Object)"[bulk]").or(tNameField.contains((Object)"[search]"));
        Set<String> osSet = DBUtils.getRecordSetByField(osTable, tidField, (Condition)condition, create);
        if (!osSet.containsAll(rqSet)) {
            String msg = String.format("[Invalid Data] Unmatched tid between %s and %s", rqSet.toString(), osSet.toString());
            LOG.error(msg);
            LOG.error(create.select(new SelectField[0]).from(rqTable).fetch().toString());
            LOG.error(create.select(new SelectField[0]).from(osTable).where(new Condition[]{condition}).fetch().toString());
            throw new RuntimeException(msg);
        }
    }

    public static void emitWorkloadMetrics(DSLContext create, MetricsDB db, ShardRequestMetricsSnapshot rqMetricsSnap) throws Exception {
        long mCurrT = System.currentTimeMillis();
        Result<Record> res = rqMetricsSnap.fetchLatencyByOp();
        db.createMetric(new Metric<Double>(AllMetrics.CommonMetric.LATENCY.toString(), 0.0), LATENCY_TABLE_DIMENSIONS);
        BatchBindStep handle = db.startBatchPut(new Metric<Double>(AllMetrics.CommonMetric.LATENCY.toString(), 0.0), LATENCY_TABLE_DIMENSIONS);
        ArrayList<String> shardDims = new ArrayList<String>(){
            {
                this.add(ShardRequestMetricsSnapshot.Fields.OPERATION.toString());
                this.add(ShardRequestMetricsSnapshot.Fields.SHARD_ID.toString());
                this.add(ShardRequestMetricsSnapshot.Fields.INDEX_NAME.toString());
                this.add(ShardRequestMetricsSnapshot.Fields.SHARD_ROLE.toString());
            }
        };
        db.createMetric(new Metric<Double>(AllMetrics.ShardOperationMetric.SHARD_OP_COUNT.toString(), 0.0), (List<String>)shardDims);
        BatchBindStep countHandle = db.startBatchPut(new Metric<Double>(AllMetrics.ShardOperationMetric.SHARD_OP_COUNT.toString(), 0.0), (List<String>)shardDims);
        db.createMetric(new Metric<Double>(AllMetrics.ShardBulkMetric.DOC_COUNT.toString(), 0.0), (List<String>)shardDims);
        BatchBindStep bulkDocHandle = db.startBatchPut(new Metric<Double>(AllMetrics.ShardBulkMetric.DOC_COUNT.toString(), 0.0), (List<String>)shardDims);
        for (Record r : res) {
            Double sumLatency = Double.parseDouble(r.get(DBUtils.getAggFieldName(ShardRequestMetricsSnapshot.Fields.LAT.toString(), "sum")).toString());
            Double avgLatency = Double.parseDouble(r.get(DBUtils.getAggFieldName(ShardRequestMetricsSnapshot.Fields.LAT.toString(), "avg")).toString());
            Double minLatency = Double.parseDouble(r.get(DBUtils.getAggFieldName(ShardRequestMetricsSnapshot.Fields.LAT.toString(), "min")).toString());
            Double maxLatency = Double.parseDouble(r.get(DBUtils.getAggFieldName(ShardRequestMetricsSnapshot.Fields.LAT.toString(), "max")).toString());
            handle.bind(new Object[]{r.get(ShardRequestMetricsSnapshot.Fields.OPERATION.toString()).toString(), null, null, null, r.get(ShardRequestMetricsSnapshot.Fields.SHARD_ID.toString()).toString(), r.get(ShardRequestMetricsSnapshot.Fields.INDEX_NAME.toString()).toString(), r.get(ShardRequestMetricsSnapshot.Fields.SHARD_ROLE.toString()).toString(), sumLatency, avgLatency, minLatency, maxLatency});
            Double count = Double.parseDouble(r.get(AllMetrics.ShardOperationMetric.SHARD_OP_COUNT.toString()).toString());
            countHandle.bind(new Object[]{r.get(ShardRequestMetricsSnapshot.Fields.OPERATION.toString()).toString(), r.get(ShardRequestMetricsSnapshot.Fields.SHARD_ID.toString()).toString(), r.get(ShardRequestMetricsSnapshot.Fields.INDEX_NAME.toString()).toString(), r.get(ShardRequestMetricsSnapshot.Fields.SHARD_ROLE.toString()).toString(), count, count, count, count});
            Object bulkDocCountObj = r.get(AllMetrics.ShardBulkMetric.DOC_COUNT.toString());
            if (bulkDocCountObj == null) continue;
            Double bulkDocCount = Double.parseDouble(bulkDocCountObj.toString());
            bulkDocHandle.bind(new Object[]{r.get(ShardRequestMetricsSnapshot.Fields.OPERATION.toString()).toString(), r.get(ShardRequestMetricsSnapshot.Fields.SHARD_ID.toString()).toString(), r.get(ShardRequestMetricsSnapshot.Fields.INDEX_NAME.toString()).toString(), r.get(ShardRequestMetricsSnapshot.Fields.SHARD_ROLE.toString()).toString(), bulkDocCount, bulkDocCount, bulkDocCount, bulkDocCount});
        }
        if (handle.size() > 0) {
            handle.execute();
        }
        if (countHandle.size() > 0) {
            countHandle.execute();
        }
        if (bulkDocHandle.size() > 0) {
            bulkDocHandle.execute();
        }
        long mFinalT = System.currentTimeMillis();
        LOG.debug("Total time taken for writing workload metrics metricsdb: {}", (Object)(mFinalT - mCurrT));
    }

    public static void emitThreadNameMetrics(DSLContext create, MetricsDB db, OSMetricsSnapshot osMetricsSnap) throws Exception {
        long mCurrT = System.currentTimeMillis();
        Result<Record> res = osMetricsSnap.getOSMetrics();
        Set<String> metricColumns = osMetricsSnap.getMetricColumns();
        for (Record r : res) {
            Dimensions dimensions = new Dimensions();
            Object threadName = r.get(OSMetricsSnapshot.Fields.tName.toString());
            if (threadName == null) {
                LOG.debug("Could not find tName: {}", (Object)r);
                continue;
            }
            String operation = MetricsEmitter.categorizeThreadName(threadName.toString(), dimensions);
            if (operation == null) continue;
            dimensions.put(ShardRequestMetricsSnapshot.Fields.OPERATION.toString(), operation);
            for (String metricColumn : metricColumns) {
                if (r.get(metricColumn) == null) continue;
                Double metric = Double.parseDouble(r.get(metricColumn).toString());
                if (operation.equals("merge") && metricColumn.equals("cpu")) {
                    LOG.debug("Putting merge metric {}", (Object)metric);
                }
                db.putMetric(new Metric<Double>(metricColumn, metric), dimensions, 0L);
            }
        }
        long mFinalT = System.currentTimeMillis();
        LOG.debug("Total time taken for writing threadName metrics metricsdb: {}", (Object)(mFinalT - mCurrT));
    }

    public static String categorizeThreadName(String threadName, Dimensions dimensions) {
        if (SEARCH_PATTERN.matcher(threadName).matches()) {
            return "search";
        }
        if (BULK_PATTERN.matcher(threadName).matches() || WRITE_PATTERN.matcher(threadName).matches()) {
            return "write";
        }
        if (GC_PATTERN.matcher(threadName).matches()) {
            return "GC";
        }
        if (REFRESH_PATTERN.matcher(threadName).matches()) {
            return "refresh";
        }
        if (MANAGEMENT_PATTERN.matcher(threadName).matches()) {
            return "management";
        }
        if (HTTP_SERVER_PATTERN.matcher(threadName).matches()) {
            return "httpServer";
        }
        if (TRANS_WORKER_PATTERN.matcher(threadName).matches()) {
            return "transportWorker";
        }
        if (GENERIC_PATTERN.matcher(threadName).matches()) {
            return "generic";
        }
        if (FLUSH_PATTERN.matcher(threadName).matches()) {
            return "flush";
        }
        if (SNAPSHOT_PATTERN.matcher(threadName).matches()) {
            return "snapshot";
        }
        if (GET_PATTERN.matcher(threadName).matches()) {
            return "get";
        }
        Matcher mergeMatcher = MERGE_PATTERN.matcher(threadName);
        if (mergeMatcher.matches()) {
            dimensions.put(ShardRequestMetricsSnapshot.Fields.INDEX_NAME.toString(), mergeMatcher.group(1));
            dimensions.put(ShardRequestMetricsSnapshot.Fields.SHARD_ID.toString(), mergeMatcher.group(2));
            return "merge";
        }
        return "other";
    }

    public static void emitHttpMetrics(DSLContext create, MetricsDB db, HttpRequestMetricsSnapshot rqMetricsSnap) throws Exception {
        long mCurrT = System.currentTimeMillis();
        Dimensions dimensions = new Dimensions();
        Result<Record> res = rqMetricsSnap.fetchLatencyByOp();
        ArrayList<String> dims = new ArrayList<String>(){
            {
                this.add(HttpRequestMetricsSnapshot.Fields.OPERATION.toString());
                this.add(HttpRequestMetricsSnapshot.Fields.EXCEPTION.toString());
                this.add(HttpRequestMetricsSnapshot.Fields.INDICES.toString());
                this.add(HttpRequestMetricsSnapshot.Fields.HTTP_RESP_CODE.toString());
            }
        };
        db.createMetric(new Metric<Double>(AllMetrics.CommonMetric.LATENCY.toString(), 0.0), LATENCY_TABLE_DIMENSIONS);
        db.createMetric(new Metric<Double>(AllMetrics.HttpMetric.HTTP_TOTAL_REQUESTS.toString(), 0.0), (List<String>)dims);
        db.createMetric(new Metric<Double>(AllMetrics.HttpMetric.HTTP_REQUEST_DOCS.toString(), 0.0), (List<String>)dims);
        for (Record r : res) {
            dimensions.put(HttpRequestMetricsSnapshot.Fields.OPERATION.toString(), r.get(HttpRequestMetricsSnapshot.Fields.OPERATION.toString()).toString());
            dimensions.put(HttpRequestMetricsSnapshot.Fields.HTTP_RESP_CODE.toString(), r.get(HttpRequestMetricsSnapshot.Fields.HTTP_RESP_CODE.toString()).toString());
            dimensions.put(HttpRequestMetricsSnapshot.Fields.INDICES.toString(), r.get(HttpRequestMetricsSnapshot.Fields.INDICES.toString()).toString());
            dimensions.put(HttpRequestMetricsSnapshot.Fields.EXCEPTION.toString(), r.get(HttpRequestMetricsSnapshot.Fields.EXCEPTION.toString()).toString());
            Double sumLatency = Double.parseDouble(r.get(DBUtils.getAggFieldName(HttpRequestMetricsSnapshot.Fields.LAT.toString(), "sum")).toString());
            Double avgLatency = Double.parseDouble(r.get(DBUtils.getAggFieldName(HttpRequestMetricsSnapshot.Fields.LAT.toString(), "avg")).toString());
            Double minLatency = Double.parseDouble(r.get(DBUtils.getAggFieldName(HttpRequestMetricsSnapshot.Fields.LAT.toString(), "min")).toString());
            Double maxLatency = Double.parseDouble(r.get(DBUtils.getAggFieldName(HttpRequestMetricsSnapshot.Fields.LAT.toString(), "max")).toString());
            Double count = Double.parseDouble(r.get(HttpRequestMetricsSnapshot.Fields.HTTP_TOTAL_REQUESTS.toString()).toString());
            Double sumItemCount = Double.parseDouble(r.get(DBUtils.getAggFieldName(HttpRequestMetricsSnapshot.Fields.HTTP_REQUEST_DOCS.toString(), "sum")).toString());
            Double avgItemCount = Double.parseDouble(r.get(DBUtils.getAggFieldName(HttpRequestMetricsSnapshot.Fields.HTTP_REQUEST_DOCS.toString(), "avg")).toString());
            Double minItemCount = Double.parseDouble(r.get(DBUtils.getAggFieldName(HttpRequestMetricsSnapshot.Fields.HTTP_REQUEST_DOCS.toString(), "min")).toString());
            Double maxItemCount = Double.parseDouble(r.get(DBUtils.getAggFieldName(HttpRequestMetricsSnapshot.Fields.HTTP_REQUEST_DOCS.toString(), "max")).toString());
            db.putMetric(new Metric<Double>(AllMetrics.CommonMetric.LATENCY.toString(), sumLatency, avgLatency, minLatency, maxLatency), dimensions, 0L);
            db.putMetric(new Metric<Double>(AllMetrics.HttpMetric.HTTP_TOTAL_REQUESTS.toString(), count), dimensions, 0L);
            db.putMetric(new Metric<Double>(AllMetrics.HttpMetric.HTTP_REQUEST_DOCS.toString(), sumItemCount, avgItemCount, minItemCount, maxItemCount), dimensions, 0L);
        }
        long mFinalT = System.currentTimeMillis();
        LOG.debug("Total time taken for writing http metrics metricsdb: {}", (Object)(mFinalT - mCurrT));
    }

    public static void emitGarbageCollectionInfo(MetricsDB metricsDB, GarbageCollectorInfoSnapshot garbageCollectorInfoSnapshot) {
        long mCurrT = System.currentTimeMillis();
        Result<Record> gcTypeRecords = garbageCollectorInfoSnapshot.fetchAll();
        ArrayList<String> dims = new ArrayList<String>(){
            {
                this.add(AllMetrics.GCInfoDimension.MEMORY_POOL.toString());
                this.add(AllMetrics.GCInfoDimension.COLLECTOR_NAME.toString());
            }
        };
        metricsDB.createMetric(new Metric<Double>(AllMetrics.GCInfoValue.GARBAGE_COLLECTOR_TYPE.toString(), 0.0), (List<String>)dims);
        BatchBindStep handle = metricsDB.startBatchPut(new Metric<Double>(AllMetrics.GCInfoValue.GARBAGE_COLLECTOR_TYPE.toString(), 0.0), (List<String>)dims);
        for (Record record : gcTypeRecords) {
            Optional<Object> memPoolObj = Optional.ofNullable(record.get(AllMetrics.GCInfoDimension.MEMORY_POOL.toString()));
            Optional<Object> collectorObj = Optional.ofNullable(record.get(AllMetrics.GCInfoDimension.COLLECTOR_NAME.toString()));
            handle.bind(new Object[]{memPoolObj.orElseGet(Object::new).toString(), collectorObj.orElseGet(Object::new).toString(), null, null, null, null});
        }
        handle.execute();
        long mFinalT = System.currentTimeMillis();
        LOG.debug("Total time taken for writing garbage collection info into metricsDB: {}", (Object)(mFinalT - mCurrT));
    }

    public static void emitAdmissionControlMetrics(MetricsDB metricsDB, AdmissionControlSnapshot snapshot) {
        long startTime = System.currentTimeMillis();
        Result<Record> records = snapshot.fetchAll();
        ArrayList<String> dims = new ArrayList<String>(){
            {
                this.add(AllMetrics.AdmissionControlDimension.CONTROLLER_NAME.toString());
            }
        };
        metricsDB.createMetric(new Metric<Double>(AllMetrics.AdmissionControlValue.REJECTION_COUNT.toString(), 0.0), (List<String>)dims);
        BatchBindStep handle = metricsDB.startBatchPut(new Metric<Double>(AllMetrics.AdmissionControlValue.REJECTION_COUNT.toString(), 0.0), (List<String>)dims);
        for (Record record : records) {
            Optional<Object> controllerObj = Optional.ofNullable(record.get(AllMetrics.AdmissionControlDimension.CONTROLLER_NAME.toString()));
            Optional<Object> rejectionCountObj = Optional.ofNullable(record.get(AllMetrics.AdmissionControlValue.REJECTION_COUNT.toString()));
            if (!controllerObj.isPresent() || !rejectionCountObj.isPresent()) continue;
            handle.bind(new Object[]{controllerObj.orElseGet(Object::new).toString(), rejectionCountObj.map(o -> Long.parseLong(o.toString())).orElse(0L), rejectionCountObj.map(o -> Long.parseLong(o.toString())).orElse(0L), rejectionCountObj.map(o -> Long.parseLong(o.toString())).orElse(0L), rejectionCountObj.map(o -> Long.parseLong(o.toString())).orElse(0L), rejectionCountObj.map(o -> Long.parseLong(o.toString())).orElse(0L)});
        }
        handle.execute();
        long endTime = System.currentTimeMillis();
        LOG.debug("Total time taken for writing AdmissionControl into metricsDB: {}", (Object)(endTime - startTime));
    }

    public static void emitMasterEventMetrics(MetricsDB metricsDB, MasterEventMetricsSnapshot masterEventMetricsSnapshot) {
        long mCurrT = System.currentTimeMillis();
        Result<Record> queueAndRunTimeResult = masterEventMetricsSnapshot.fetchQueueAndRunTime();
        ArrayList<String> dims = new ArrayList<String>(){
            {
                this.add(AllMetrics.MasterMetricDimensions.MASTER_TASK_INSERT_ORDER.toString());
                this.add(AllMetrics.MasterMetricDimensions.MASTER_TASK_PRIORITY.toString());
                this.add(AllMetrics.MasterMetricDimensions.MASTER_TASK_TYPE.toString());
                this.add(AllMetrics.MasterMetricDimensions.MASTER_TASK_METADATA.toString());
            }
        };
        MetricsEmitter.emitQueueTimeMetric(metricsDB, queueAndRunTimeResult, (List<String>)dims);
        MetricsEmitter.emitRuntimeMetric(metricsDB, queueAndRunTimeResult, (List<String>)dims);
        long mFinalT = System.currentTimeMillis();
        LOG.debug("Total time taken for writing master event queue metrics metricsdb: {}", (Object)(mFinalT - mCurrT));
    }

    private static void emitRuntimeMetric(MetricsDB metricsDB, Result<Record> res, List<String> dims) {
        metricsDB.createMetric(new Metric<Double>(AllMetrics.MasterMetricValues.MASTER_TASK_RUN_TIME.toString(), 0.0), dims);
        BatchBindStep handle = metricsDB.startBatchPut(new Metric<Double>(AllMetrics.MasterMetricValues.MASTER_TASK_RUN_TIME.toString(), 0.0), dims);
        for (Record r : res) {
            Double sumQueueTime = Double.parseDouble(r.get(DBUtils.getAggFieldName(AllMetrics.MasterMetricDimensions.MASTER_TASK_RUN_TIME.toString(), "sum")).toString());
            Double avgQueueTime = Double.parseDouble(r.get(DBUtils.getAggFieldName(AllMetrics.MasterMetricDimensions.MASTER_TASK_RUN_TIME.toString(), "avg")).toString());
            Double minQueueTime = Double.parseDouble(r.get(DBUtils.getAggFieldName(AllMetrics.MasterMetricDimensions.MASTER_TASK_RUN_TIME.toString(), "min")).toString());
            Double maxQueueTime = Double.parseDouble(r.get(DBUtils.getAggFieldName(AllMetrics.MasterMetricDimensions.MASTER_TASK_RUN_TIME.toString(), "max")).toString());
            handle.bind(new Object[]{r.get(AllMetrics.MasterMetricDimensions.MASTER_TASK_INSERT_ORDER.toString()).toString(), r.get(AllMetrics.MasterMetricDimensions.MASTER_TASK_PRIORITY.toString()).toString(), r.get(AllMetrics.MasterMetricDimensions.MASTER_TASK_TYPE.toString()).toString(), r.get(AllMetrics.MasterMetricDimensions.MASTER_TASK_METADATA.toString()).toString(), sumQueueTime, avgQueueTime, minQueueTime, maxQueueTime});
        }
        handle.execute();
    }

    private static void emitQueueTimeMetric(MetricsDB metricsDB, Result<Record> res, List<String> dims) {
        metricsDB.createMetric(new Metric<Double>(AllMetrics.MasterMetricValues.MASTER_TASK_QUEUE_TIME.toString(), 0.0), dims);
        BatchBindStep handle = metricsDB.startBatchPut(new Metric<Double>(AllMetrics.MasterMetricValues.MASTER_TASK_QUEUE_TIME.toString(), 0.0), dims);
        for (Record r : res) {
            Double sumQueueTime = Double.parseDouble(r.get(DBUtils.getAggFieldName(AllMetrics.MasterMetricDimensions.MASTER_TASK_QUEUE_TIME.toString(), "sum")).toString());
            Double avgQueueTime = Double.parseDouble(r.get(DBUtils.getAggFieldName(AllMetrics.MasterMetricDimensions.MASTER_TASK_QUEUE_TIME.toString(), "avg")).toString());
            Double minQueueTime = Double.parseDouble(r.get(DBUtils.getAggFieldName(AllMetrics.MasterMetricDimensions.MASTER_TASK_QUEUE_TIME.toString(), "min")).toString());
            Double maxQueueTime = Double.parseDouble(r.get(DBUtils.getAggFieldName(AllMetrics.MasterMetricDimensions.MASTER_TASK_QUEUE_TIME.toString(), "max")).toString());
            handle.bind(new Object[]{r.get(AllMetrics.MasterMetricDimensions.MASTER_TASK_INSERT_ORDER.toString()).toString(), r.get(AllMetrics.MasterMetricDimensions.MASTER_TASK_PRIORITY.toString()).toString(), r.get(AllMetrics.MasterMetricDimensions.MASTER_TASK_TYPE.toString()).toString(), r.get(AllMetrics.MasterMetricDimensions.MASTER_TASK_METADATA.toString()).toString(), sumQueueTime, avgQueueTime, minQueueTime, maxQueueTime});
        }
        handle.execute();
    }

    public static void emitNodeMetrics(DSLContext create, MetricsDB db, MemoryDBSnapshot snap) throws Exception {
        Map<String, SelectHavingStep<Record>> metadataTable = snap.selectMetadataSource();
        Map<String, List<Field<?>>> selectField = snap.getTableSelectFieldsMap();
        List<String> dimensionNames = snap.getDimensionNames();
        for (Map.Entry<String, SelectHavingStep<Record>> entry : metadataTable.entrySet()) {
            long mCurrT = System.currentTimeMillis();
            String tableName = entry.getKey();
            Result fetchedData = entry.getValue().fetch();
            long mFinalT = System.currentTimeMillis();
            LOG.debug("Total time taken for aggregating {} : {}", (Object)tableName, (Object)(mFinalT - mCurrT));
            if (fetchedData == null || fetchedData.size() == 0) {
                LOG.debug("No data to emit: {}", (Object)tableName);
                continue;
            }
            mCurrT = System.currentTimeMillis();
            List<Field<?>> selectFields = selectField.get(tableName);
            db.createMetric(new Metric<Double>(tableName, 0.0), dimensionNames);
            BatchBindStep handle = db.startBatchPut(tableName, selectFields.size());
            for (Record r : fetchedData) {
                int columnNum = selectFields.size();
                Object[] bindValues = new Object[columnNum];
                for (int i = 0; i < columnNum; ++i) {
                    bindValues[i] = r.get(selectFields.get(i).getName());
                }
                handle.bind(bindValues);
            }
            handle.execute();
            mFinalT = System.currentTimeMillis();
            LOG.debug("Total time taken for writing {} metrics metricsdb: {}", (Object)tableName, (Object)(mFinalT - mCurrT));
        }
    }

    public static void emitFaultDetectionMetrics(MetricsDB db, FaultDetectionMetricsSnapshot faultDetectionSnapshot) {
        long mCurrT = System.currentTimeMillis();
        Dimensions dimensions = new Dimensions();
        Result<Record> res = faultDetectionSnapshot.fetchAggregatedTable();
        db.createMetric(new Metric<Double>(AllMetrics.FaultDetectionMetric.FOLLOWER_CHECK_LATENCY.toString(), 0.0), FAULT_DETECTION_TABLE_DIMENSIONS);
        db.createMetric(new Metric<Double>(AllMetrics.FaultDetectionMetric.LEADER_CHECK_LATENCY.toString(), 0.0), FAULT_DETECTION_TABLE_DIMENSIONS);
        db.createMetric(new Metric<Double>(AllMetrics.FaultDetectionMetric.FOLLOWER_CHECK_FAILURE.toString(), 0.0), FAULT_DETECTION_TABLE_DIMENSIONS);
        db.createMetric(new Metric<Double>(AllMetrics.FaultDetectionMetric.LEADER_CHECK_FAILURE.toString(), 0.0), FAULT_DETECTION_TABLE_DIMENSIONS);
        for (Record r : res) {
            dimensions.put(AllMetrics.FaultDetectionDimension.SOURCE_NODE_ID.toString(), r.get(AllMetrics.FaultDetectionDimension.SOURCE_NODE_ID.toString()).toString());
            dimensions.put(AllMetrics.FaultDetectionDimension.TARGET_NODE_ID.toString(), r.get(AllMetrics.FaultDetectionDimension.TARGET_NODE_ID.toString()).toString());
            Double sumLatency = Double.parseDouble(r.get(DBUtils.getAggFieldName(FaultDetectionMetricsSnapshot.Fields.LAT.toString(), "sum")).toString());
            Double avgLatency = Double.parseDouble(r.get(DBUtils.getAggFieldName(FaultDetectionMetricsSnapshot.Fields.LAT.toString(), "avg")).toString());
            Double minLatency = Double.parseDouble(r.get(DBUtils.getAggFieldName(FaultDetectionMetricsSnapshot.Fields.LAT.toString(), "min")).toString());
            Double maxLatency = Double.parseDouble(r.get(DBUtils.getAggFieldName(FaultDetectionMetricsSnapshot.Fields.LAT.toString(), "max")).toString());
            Double sumFault = Double.parseDouble(r.get(DBUtils.getAggFieldName(FaultDetectionMetricsSnapshot.Fields.FAULT.toString(), "sum")).toString());
            Double avgFault = Double.parseDouble(r.get(DBUtils.getAggFieldName(FaultDetectionMetricsSnapshot.Fields.FAULT.toString(), "avg")).toString());
            Double minFault = Double.parseDouble(r.get(DBUtils.getAggFieldName(FaultDetectionMetricsSnapshot.Fields.FAULT.toString(), "min")).toString());
            Double maxFault = Double.parseDouble(r.get(DBUtils.getAggFieldName(FaultDetectionMetricsSnapshot.Fields.FAULT.toString(), "max")).toString());
            if (r.get(FaultDetectionMetricsSnapshot.Fields.FAULT_DETECTION_TYPE.toString()).toString().equals("follower_check")) {
                db.putMetric(new Metric<Double>(AllMetrics.FaultDetectionMetric.FOLLOWER_CHECK_LATENCY.toString(), sumLatency, avgLatency, minLatency, maxLatency), dimensions, 0L);
                db.putMetric(new Metric<Double>(AllMetrics.FaultDetectionMetric.FOLLOWER_CHECK_FAILURE.toString(), sumFault, avgFault, minFault, maxFault), dimensions, 0L);
                continue;
            }
            if (!r.get(FaultDetectionMetricsSnapshot.Fields.FAULT_DETECTION_TYPE.toString()).toString().equals("leader_check")) continue;
            db.putMetric(new Metric<Double>(AllMetrics.FaultDetectionMetric.LEADER_CHECK_LATENCY.toString(), sumLatency, avgLatency, minLatency, maxLatency), dimensions, 0L);
            db.putMetric(new Metric<Double>(AllMetrics.FaultDetectionMetric.LEADER_CHECK_FAILURE.toString(), sumFault, avgFault, minFault, maxFault), dimensions, 0L);
        }
        long mFinalT = System.currentTimeMillis();
        PerformanceAnalyzerApp.READER_METRICS_AGGREGATOR.updateStat(ReaderMetrics.FAULT_DETECTION_METRICS_EMITTER_EXECUTION_TIME, "", mFinalT - mCurrT);
        LOG.debug("Total time taken for writing fault detection metrics to metricsdb: {}", (Object)(mFinalT - mCurrT));
    }

    public static void emitMasterThrottledTaskMetric(MetricsDB metricsDB, MasterThrottlingMetricsSnapshot masterThrottlingMetricsSnapshot) {
        long mCurrT = System.currentTimeMillis();
        Result<Record> masterThrottlingMetrics = masterThrottlingMetricsSnapshot.fetchAggregatedMetrics();
        ArrayList<String> dims = new ArrayList<String>();
        MetricsEmitter.emitMasterThrottlingCount(metricsDB, masterThrottlingMetrics, dims);
        MetricsEmitter.emitDataThrottlingRetryingCount(metricsDB, masterThrottlingMetrics, dims);
        long mFinalT = System.currentTimeMillis();
        LOG.debug("Total time taken for writing master throttling metrics metricsdb: {}", (Object)(mFinalT - mCurrT));
        PerformanceAnalyzerApp.READER_METRICS_AGGREGATOR.updateStat(ReaderMetrics.MASTER_THROTTLING_EMITTER_EXECUTION_TIME, "", mFinalT - mCurrT);
    }

    public static void emitMasterThrottlingCount(MetricsDB metricsDB, Result<Record> res, List<String> dims) {
        metricsDB.createMetric(new Metric<Double>(AllMetrics.MasterThrottlingValue.MASTER_THROTTLED_PENDING_TASK_COUNT.toString(), 0.0), dims);
        BatchBindStep handle = metricsDB.startBatchPut(new Metric<Double>(AllMetrics.MasterThrottlingValue.MASTER_THROTTLED_PENDING_TASK_COUNT.toString(), 0.0), dims);
        for (Record r : res) {
            Double sumMasterThrottledTask = Double.parseDouble(r.get(DBUtils.getAggFieldName(AllMetrics.MasterThrottlingValue.MASTER_THROTTLED_PENDING_TASK_COUNT.toString(), "sum")).toString());
            Double avgMasterThrottledTask = Double.parseDouble(r.get(DBUtils.getAggFieldName(AllMetrics.MasterThrottlingValue.MASTER_THROTTLED_PENDING_TASK_COUNT.toString(), "avg")).toString());
            Double minMasterThrottledTask = Double.parseDouble(r.get(DBUtils.getAggFieldName(AllMetrics.MasterThrottlingValue.MASTER_THROTTLED_PENDING_TASK_COUNT.toString(), "min")).toString());
            Double maxMasterThrottledTask = Double.parseDouble(r.get(DBUtils.getAggFieldName(AllMetrics.MasterThrottlingValue.MASTER_THROTTLED_PENDING_TASK_COUNT.toString(), "max")).toString());
            handle.bind(new Object[]{sumMasterThrottledTask, avgMasterThrottledTask, minMasterThrottledTask, maxMasterThrottledTask});
        }
        handle.execute();
    }

    public static void emitDataThrottlingRetryingCount(MetricsDB metricsDB, Result<Record> res, List<String> dims) {
        metricsDB.createMetric(new Metric<Double>(AllMetrics.MasterThrottlingValue.DATA_RETRYING_TASK_COUNT.toString(), 0.0), dims);
        BatchBindStep handle = metricsDB.startBatchPut(new Metric<Double>(AllMetrics.MasterThrottlingValue.DATA_RETRYING_TASK_COUNT.toString(), 0.0), dims);
        for (Record r : res) {
            Double sumDataRetryingTask = Double.parseDouble(r.get(DBUtils.getAggFieldName(AllMetrics.MasterThrottlingValue.DATA_RETRYING_TASK_COUNT.toString(), "sum")).toString());
            Double avgDataRetryingTask = Double.parseDouble(r.get(DBUtils.getAggFieldName(AllMetrics.MasterThrottlingValue.DATA_RETRYING_TASK_COUNT.toString(), "avg")).toString());
            Double minDataRetryingTask = Double.parseDouble(r.get(DBUtils.getAggFieldName(AllMetrics.MasterThrottlingValue.DATA_RETRYING_TASK_COUNT.toString(), "min")).toString());
            Double maxDataRetryingTask = Double.parseDouble(r.get(DBUtils.getAggFieldName(AllMetrics.MasterThrottlingValue.DATA_RETRYING_TASK_COUNT.toString(), "max")).toString());
            handle.bind(new Object[]{sumDataRetryingTask, avgDataRetryingTask, minDataRetryingTask, maxDataRetryingTask});
        }
        handle.execute();
    }

    public static void emitShardStateMetric(MetricsDB metricsDB, ShardStateMetricsSnapshot shardStateMetricsSnapshot) {
        long mCurrT = System.currentTimeMillis();
        Result<Record> shardStateMetrics = shardStateMetricsSnapshot.fetchAll();
        metricsDB.createMetric(new Metric<Double>(AllMetrics.ShardStateValue.SHARD_STATE.toString(), 0.0), SHARD_STATE_TABLE_DIMENSIONS);
        BatchBindStep handle = metricsDB.startBatchPut(new Metric<Double>(AllMetrics.ShardStateValue.SHARD_STATE.toString(), 0.0), SHARD_STATE_TABLE_DIMENSIONS);
        for (Record r : shardStateMetrics) {
            handle.bind(new Object[]{r.get(AllMetrics.ShardStateDimension.INDEX_NAME.toString()).toString(), r.get(AllMetrics.ShardStateDimension.SHARD_ID.toString()).toString(), r.get(AllMetrics.ShardStateDimension.SHARD_TYPE.toString()).toString(), r.get(AllMetrics.ShardStateDimension.NODE_NAME.toString()).toString(), r.get(AllMetrics.ShardStateDimension.SHARD_STATE.toString()).toString(), 1.0, 1.0, 1.0, 1.0});
        }
        handle.execute();
        long mFinalT = System.currentTimeMillis();
        LOG.debug("Total time taken for writing shard state event queue metrics metricsdb: {}", (Object)(mFinalT - mCurrT));
        PerformanceAnalyzerApp.READER_METRICS_AGGREGATOR.updateStat(ReaderMetrics.SHARD_STATE_EMITTER_EXECUTION_TIME, "", mFinalT - mCurrT);
    }
}

