/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import java.io.File;
import java.sql.Connection;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.reader.EventProcessor;
import org.opensearch.performanceanalyzer.reader.MasterEventMetricsSnapshot;
import org.opensearch.performanceanalyzer.reader.ReaderMetricsProcessor;
import org.opensearch.performanceanalyzer.reader_writer_shared.Event;

public class MasterMetricsEventProcessor
implements EventProcessor {
    private static final Logger LOG = LogManager.getLogger(MasterMetricsEventProcessor.class);
    private MasterEventMetricsSnapshot masterSnap;
    private BatchBindStep handle;
    private long startTime;
    private long endTime;

    private MasterMetricsEventProcessor(MasterEventMetricsSnapshot masterSnap) {
        this.masterSnap = masterSnap;
    }

    static MasterMetricsEventProcessor buildMasterMetricEventsProcessor(long currWindowStartTime, Connection conn, NavigableMap<Long, MasterEventMetricsSnapshot> masterEventMetricsMap) {
        MasterEventMetricsSnapshot masterSnap = (MasterEventMetricsSnapshot)masterEventMetricsMap.get(currWindowStartTime);
        if (masterSnap == null) {
            masterSnap = new MasterEventMetricsSnapshot(conn, currWindowStartTime);
            Map.Entry<Long, MasterEventMetricsSnapshot> entry = masterEventMetricsMap.lastEntry();
            if (entry != null) {
                masterSnap.rolloverInflightRequests(entry.getValue());
            }
            masterEventMetricsMap.put(currWindowStartTime, masterSnap);
        }
        return new MasterMetricsEventProcessor(masterSnap);
    }

    @Override
    public void initializeProcessing(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.handle = this.masterSnap.startBatchPut();
    }

    @Override
    public void finalizeProcessing() {
        if (this.handle.size() > 0) {
            this.handle.execute();
        }
        LOG.debug("Final masterEvents request metrics {}", this.masterSnap.fetchAll());
    }

    @Override
    public void processEvent(Event event) {
        String[] keyElements = event.key.split(File.separatorChar == '\\' ? "\\\\" : File.separator);
        String threadId = keyElements[1];
        String insertOrder = keyElements[3];
        String startOrFinish = keyElements[4];
        if (startOrFinish.equals("start")) {
            this.emitStartMasterEventMetric(event, insertOrder, threadId);
        } else if (startOrFinish.equals("finish")) {
            this.emitEndMasterEventMetric(event, insertOrder, threadId);
        }
    }

    @Override
    public boolean shouldProcessEvent(Event event) {
        return event.key.contains("master_task");
    }

    @Override
    public void commitBatchIfRequired() {
        if (this.handle.size() > 500) {
            this.handle.execute();
            this.handle = this.masterSnap.startBatchPut();
        }
    }

    private void emitStartMasterEventMetric(Event entry, String insertOrder, String threadId) {
        Map<String, String> keyValueMap = ReaderMetricsProcessor.extractEntryData(entry.value);
        String priority = keyValueMap.get(AllMetrics.MasterMetricDimensions.MASTER_TASK_PRIORITY.toString());
        long st = Long.parseLong(keyValueMap.get(AllMetrics.CommonMetric.START_TIME.toString()));
        String taskType = keyValueMap.get(AllMetrics.MasterMetricDimensions.MASTER_TASK_TYPE.toString());
        String taskMetadata = keyValueMap.get(AllMetrics.MasterMetricDimensions.MASTER_TASK_METADATA.toString());
        long queueTime = Long.parseLong(keyValueMap.get(AllMetrics.MasterMetricDimensions.MASTER_TASK_QUEUE_TIME.toString()));
        this.handle.bind(new Object[]{threadId, insertOrder, priority, taskType, taskMetadata, queueTime, st, null});
    }

    private void emitEndMasterEventMetric(Event entry, String insertOrder, String threadId) {
        Map<String, String> keyValueMap = ReaderMetricsProcessor.extractEntryData(entry.value);
        long finishTime = Long.parseLong(keyValueMap.get(AllMetrics.CommonMetric.FINISH_TIME.toString()));
        this.handle.bind(new Object[]{threadId, insertOrder, null, null, null, null, null, finishTime});
    }
}

