/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.rca.hotshard;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.grpc.Resource;
import org.opensearch.performanceanalyzer.rca.configs.HotShardClusterRcaConfig;
import org.opensearch.performanceanalyzer.rca.framework.api.Rca;
import org.opensearch.performanceanalyzer.rca.framework.api.Resources;
import org.opensearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotClusterSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotShardSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.ResourceUtil;
import org.opensearch.performanceanalyzer.rca.framework.core.GenericSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;
import org.opensearch.performanceanalyzer.rca.store.rca.hotshard.NodeShardKey;

public class HotShardClusterRca
extends Rca<ResourceFlowUnit<HotClusterSummary>> {
    public static final String RCA_TABLE_NAME = HotShardClusterRca.class.getSimpleName();
    private static final Logger LOG = LogManager.getLogger(HotShardClusterRca.class);
    private static final int SLIDING_WINDOW_IN_SECONDS = 60;
    private double cpuUtilizationClusterThreshold;
    private double ioTotThroughputClusterThreshold;
    private double ioTotSysCallRateClusterThreshold;
    private final Rca<ResourceFlowUnit<HotNodeSummary>> hotShardRca;
    private int rcaPeriod;
    private int counter;
    private Set<String> unhealthyNodes;
    private Table<String, NodeShardKey, Double> cpuUtilizationInfoTable;
    private Table<String, NodeShardKey, Double> IOThroughputInfoTable;
    private Table<String, NodeShardKey, Double> IOSysCallRateInfoTable;

    public <R extends Rca<ResourceFlowUnit<HotNodeSummary>>> HotShardClusterRca(int rcaPeriod, R hotShardRca) {
        super(5L);
        this.hotShardRca = hotShardRca;
        this.rcaPeriod = rcaPeriod;
        this.counter = 0;
        this.unhealthyNodes = new HashSet<String>();
        this.cpuUtilizationInfoTable = HashBasedTable.create();
        this.IOThroughputInfoTable = HashBasedTable.create();
        this.IOSysCallRateInfoTable = HashBasedTable.create();
        this.cpuUtilizationClusterThreshold = 0.3;
        this.ioTotThroughputClusterThreshold = 0.3;
        this.ioTotSysCallRateClusterThreshold = 0.3;
    }

    private void populateResourceInfoTable(String indexName, NodeShardKey nodeShardKey, double metricValue, Table<String, NodeShardKey, Double> metricMap) {
        if (null == metricMap.get((Object)indexName, (Object)nodeShardKey)) {
            metricMap.put((Object)indexName, (Object)nodeShardKey, (Object)metricValue);
        } else {
            double existingOccurence = (Double)metricMap.get((Object)indexName, (Object)nodeShardKey);
            metricMap.put((Object)indexName, (Object)nodeShardKey, (Object)(existingOccurence + metricValue));
        }
    }

    private void consumeFlowUnit(ResourceFlowUnit<HotNodeSummary> resourceFlowUnit) {
        HotNodeSummary hotNodeSummary = resourceFlowUnit.getSummary();
        String nodeId = hotNodeSummary.getNodeID().toString();
        for (GenericSummary summary : hotNodeSummary.getNestedSummaryList()) {
            if (!(summary instanceof HotShardSummary)) continue;
            HotShardSummary hotShardSummary = (HotShardSummary)summary;
            String indexName = hotShardSummary.getIndexName();
            NodeShardKey nodeShardKey = new NodeShardKey(nodeId, hotShardSummary.getShardId());
            this.populateResourceInfoTable(indexName, nodeShardKey, hotShardSummary.getCpuUtilization(), this.cpuUtilizationInfoTable);
            this.populateResourceInfoTable(indexName, nodeShardKey, hotShardSummary.getIOThroughput(), this.IOThroughputInfoTable);
            this.populateResourceInfoTable(indexName, nodeShardKey, hotShardSummary.getIOSysCallrate(), this.IOSysCallRateInfoTable);
        }
    }

    private double getThresholdValue(Map<NodeShardKey, Double> perIndexShardInfo, double thresholdInPercentage) {
        double[] perIndexShardUsage = perIndexShardInfo.values().stream().mapToDouble(usage -> usage).toArray();
        Arrays.sort(perIndexShardUsage);
        int length = perIndexShardUsage.length;
        double median = length % 2 != 0 ? perIndexShardUsage[length / 2] : (perIndexShardUsage[(length - 1) / 2] + perIndexShardUsage[length / 2]) / 2.0;
        return median * (1.0 + thresholdInPercentage);
    }

    private void findHotShardAndCreateSummary(Table<String, NodeShardKey, Double> resourceInfoTable, double thresholdInPercentage, List<HotResourceSummary> hotResourceSummaryList, Resource resource) {
        for (String indexName : resourceInfoTable.rowKeySet()) {
            Map perIndexShardInfo = resourceInfoTable.row((Object)indexName);
            double thresholdValue = this.getThresholdValue(perIndexShardInfo, thresholdInPercentage);
            for (Map.Entry shardInfo : perIndexShardInfo.entrySet()) {
                if (!((Double)shardInfo.getValue() > thresholdValue)) continue;
                String shardIdentifier = String.join((CharSequence)" ", ((NodeShardKey)shardInfo.getKey()).getNodeId(), indexName, ((NodeShardKey)shardInfo.getKey()).getShardId());
                hotResourceSummaryList.add(new HotResourceSummary(resource, thresholdValue, (Double)shardInfo.getValue(), 60, shardIdentifier));
            }
        }
    }

    @Override
    public ResourceFlowUnit<HotClusterSummary> operate() {
        ++this.counter;
        List resourceFlowUnits = this.hotShardRca.getFlowUnits();
        for (ResourceFlowUnit resourceFlowUnit : resourceFlowUnits) {
            if (resourceFlowUnit.isEmpty() || !resourceFlowUnit.getResourceContext().isUnhealthy()) continue;
            this.unhealthyNodes.add(((HotNodeSummary)resourceFlowUnit.getSummary()).getNodeID().toString());
            this.consumeFlowUnit(resourceFlowUnit);
        }
        if (this.counter >= this.rcaPeriod) {
            ResourceContext context;
            ArrayList<HotResourceSummary> hotShardSummaryList = new ArrayList<HotResourceSummary>();
            HotClusterSummary summary = new HotClusterSummary(this.getAllClusterInstances().size(), this.unhealthyNodes.size());
            this.findHotShardAndCreateSummary(this.cpuUtilizationInfoTable, this.cpuUtilizationClusterThreshold, hotShardSummaryList, ResourceUtil.CPU_USAGE);
            this.findHotShardAndCreateSummary(this.IOThroughputInfoTable, this.ioTotThroughputClusterThreshold, hotShardSummaryList, ResourceUtil.IO_TOTAL_THROUGHPUT);
            this.findHotShardAndCreateSummary(this.IOSysCallRateInfoTable, this.ioTotSysCallRateClusterThreshold, hotShardSummaryList, ResourceUtil.IO_TOTAL_SYS_CALLRATE);
            if (hotShardSummaryList.isEmpty()) {
                context = new ResourceContext(Resources.State.HEALTHY);
            } else {
                context = new ResourceContext(Resources.State.UNHEALTHY);
                InstanceDetails instanceDetails = this.getInstanceDetails();
                HotNodeSummary nodeSummary = new HotNodeSummary(instanceDetails.getInstanceId(), instanceDetails.getInstanceIp());
                for (HotResourceSummary hotResourceSummary : hotShardSummaryList) {
                    nodeSummary.appendNestedSummary(hotResourceSummary);
                }
                summary.appendNestedSummary(nodeSummary);
                LOG.debug("rca: Hot Shards Identified: {}", hotShardSummaryList);
            }
            this.counter = 0;
            this.unhealthyNodes.clear();
            this.cpuUtilizationInfoTable.clear();
            this.IOThroughputInfoTable.clear();
            this.IOSysCallRateInfoTable.clear();
            LOG.debug("Hot Shard Cluster RCA Context :  " + context.toString());
            return new ResourceFlowUnit<HotClusterSummary>(System.currentTimeMillis(), context, summary, true);
        }
        LOG.debug("Empty FlowUnit returned for Hot Shard CLuster RCA");
        return new ResourceFlowUnit<HotClusterSummary>(System.currentTimeMillis());
    }

    @Override
    public void readRcaConf(RcaConf conf) {
        HotShardClusterRcaConfig configObj = conf.getHotShardClusterRcaConfig();
        this.cpuUtilizationClusterThreshold = configObj.getCpuUtilizationClusterThreshold();
        this.ioTotThroughputClusterThreshold = configObj.getIoTotThroughputClusterThreshold();
        this.ioTotSysCallRateClusterThreshold = configObj.getIoTotSysCallRateClusterThreshold();
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        throw new IllegalArgumentException(this.name() + "'s generateFlowUnitListFromWire() should not be required.");
    }
}

