/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.AdmissionControlDecider;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.CacheHealthDecider;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.Publisher;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.QueueHealthDecider;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.collator.Collator;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.jvm.HeapHealthDecider;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.plugins.PluginController;
import org.opensearch.performanceanalyzer.plugins.PluginControllerConfig;
import org.opensearch.performanceanalyzer.rca.framework.api.AnalysisGraph;
import org.opensearch.performanceanalyzer.rca.framework.api.Metric;
import org.opensearch.performanceanalyzer.rca.framework.api.Rca;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.Bitset_Memory;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.CPU_Utilization;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.Cache_FieldData_Eviction;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.Cache_FieldData_Size;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.Cache_Max_Size;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.Cache_Query_Size;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.Cache_Request_Eviction;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.Cache_Request_Hit;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.Cache_Request_Size;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.GC_Collection_Event;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.GC_Collection_Time;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.GC_Type;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.Heap_Max;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.Heap_Used;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.IO_TotThroughput;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.IO_TotalSyscallRate;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.IndexWriter_Memory;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.ThreadPool_QueueCapacity;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.ThreadPool_RejectedReqs;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.VersionMap_Memory;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.ShardStore;
import org.opensearch.performanceanalyzer.rca.framework.util.RcaConsts;
import org.opensearch.performanceanalyzer.rca.store.collector.NodeConfigClusterCollector;
import org.opensearch.performanceanalyzer.rca.store.collector.NodeConfigCollector;
import org.opensearch.performanceanalyzer.rca.store.metric.AggregateMetric;
import org.opensearch.performanceanalyzer.rca.store.metric.temperature.byShard.AvgCpuUtilByShardsMetricBasedTemperatureCalculator;
import org.opensearch.performanceanalyzer.rca.store.metric.temperature.byShard.CpuUtilByShardsMetricBasedTemperatureCalculator;
import org.opensearch.performanceanalyzer.rca.store.metric.temperature.byShard.HeapAllocRateByShardAvgTemperatureCalculator;
import org.opensearch.performanceanalyzer.rca.store.metric.temperature.byShard.HeapAllocRateByShardTemperatureCalculator;
import org.opensearch.performanceanalyzer.rca.store.metric.temperature.byShard.ShardSizeAvgTemperatureCalculator;
import org.opensearch.performanceanalyzer.rca.store.metric.temperature.byShard.ShardSizeMetricBasedTemperatureCalculator;
import org.opensearch.performanceanalyzer.rca.store.metric.temperature.capacity.HeapAllocRateTotalTemperatureCalculator;
import org.opensearch.performanceanalyzer.rca.store.metric.temperature.capacity.ShardTotalDiskUsageTemperatureCalculator;
import org.opensearch.performanceanalyzer.rca.store.metric.temperature.capacity.TotalCpuUtilForTotalNodeMetric;
import org.opensearch.performanceanalyzer.rca.store.metric.temperature.shardIndependent.HeapAllocRateShardIndependentTemperatureCalculator;
import org.opensearch.performanceanalyzer.rca.store.metric.temperature.shardIndependent.ShardIndependentTemperatureCalculatorCpuUtilMetric;
import org.opensearch.performanceanalyzer.rca.store.rca.HighHeapUsageClusterRca;
import org.opensearch.performanceanalyzer.rca.store.rca.HotNodeClusterRca;
import org.opensearch.performanceanalyzer.rca.store.rca.HotNodeRca;
import org.opensearch.performanceanalyzer.rca.store.rca.admissioncontrol.AdmissionControlClusterRca;
import org.opensearch.performanceanalyzer.rca.store.rca.admissioncontrol.AdmissionControlRca;
import org.opensearch.performanceanalyzer.rca.store.rca.cache.FieldDataCacheRca;
import org.opensearch.performanceanalyzer.rca.store.rca.cache.ShardRequestCacheRca;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.FieldDataCacheClusterRca;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.QueueRejectionClusterRca;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.ShardRequestCacheClusterRca;
import org.opensearch.performanceanalyzer.rca.store.rca.hot_node.HighCpuRca;
import org.opensearch.performanceanalyzer.rca.store.rca.hotheap.HighHeapUsageOldGenRca;
import org.opensearch.performanceanalyzer.rca.store.rca.hotheap.HighHeapUsageYoungGenRca;
import org.opensearch.performanceanalyzer.rca.store.rca.hotshard.HotShardClusterRca;
import org.opensearch.performanceanalyzer.rca.store.rca.hotshard.HotShardRca;
import org.opensearch.performanceanalyzer.rca.store.rca.jvmsizing.HighOldGenOccupancyRca;
import org.opensearch.performanceanalyzer.rca.store.rca.jvmsizing.LargeHeapClusterRca;
import org.opensearch.performanceanalyzer.rca.store.rca.jvmsizing.OldGenContendedRca;
import org.opensearch.performanceanalyzer.rca.store.rca.jvmsizing.OldGenReclamationRca;
import org.opensearch.performanceanalyzer.rca.store.rca.temperature.NodeTemperatureRca;
import org.opensearch.performanceanalyzer.rca.store.rca.temperature.dimension.CpuUtilDimensionTemperatureRca;
import org.opensearch.performanceanalyzer.rca.store.rca.temperature.dimension.HeapAllocRateTemperatureRca;
import org.opensearch.performanceanalyzer.rca.store.rca.temperature.dimension.ShardSizeDimensionTemperatureRca;
import org.opensearch.performanceanalyzer.rca.store.rca.threadpool.QueueRejectionRca;

public class OpenSearchAnalysisGraph
extends AnalysisGraph {
    private static final Logger LOG = LogManager.getLogger(OpenSearchAnalysisGraph.class);
    private static final int EVALUATION_INTERVAL_SECONDS = 5;
    private static final int SECONDS_IN_MIN = 60;
    private static final int RCA_PERIOD = 12;

    @Override
    public void construct() {
        Heap_Used heapUsed = new Heap_Used(5L);
        GC_Collection_Event gcEvent = new GC_Collection_Event(5L);
        Heap_Max heapMax = new Heap_Max(5L);
        GC_Collection_Time gc_Collection_Time = new GC_Collection_Time(5L);
        GC_Type gcType = new GC_Type(5L);
        AggregateMetric cpuUtilizationGroupByOperation = new AggregateMetric(1L, CPU_Utilization.NAME, AggregateMetric.AggregateFunction.SUM, "avg", AllMetrics.CommonDimension.OPERATION.toString());
        heapUsed.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        gcEvent.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        gcType.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        heapMax.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        gc_Collection_Time.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        cpuUtilizationGroupByOperation.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        this.addLeaf(heapUsed);
        this.addLeaf(gcEvent);
        this.addLeaf(gcType);
        this.addLeaf(heapMax);
        this.addLeaf(gc_Collection_Time);
        this.addLeaf(cpuUtilizationGroupByOperation);
        List<Metric> nodeStatsMetrics = this.constructNodeStatsMetrics();
        HighHeapUsageOldGenRca highHeapUsageOldGenRca = new HighHeapUsageOldGenRca(12, heapUsed, gcEvent, heapMax, nodeStatsMetrics);
        highHeapUsageOldGenRca.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        ArrayList upstream = new ArrayList(Arrays.asList(heapUsed, gcEvent, heapMax));
        upstream.addAll(nodeStatsMetrics);
        highHeapUsageOldGenRca.addAllUpstreams(upstream);
        HighHeapUsageYoungGenRca highHeapUsageYoungGenRca = new HighHeapUsageYoungGenRca(12, heapUsed, gc_Collection_Time, gcEvent, gcType);
        highHeapUsageYoungGenRca.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        highHeapUsageYoungGenRca.addAllUpstreams(Arrays.asList(heapUsed, gc_Collection_Time, gcEvent, gcType));
        HighCpuRca highCpuRca = new HighCpuRca(12, cpuUtilizationGroupByOperation);
        highCpuRca.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        highCpuRca.addAllUpstreams(Collections.singletonList(cpuUtilizationGroupByOperation));
        HotNodeRca hotJVMNodeRca = new HotNodeRca(12, new Rca[]{highHeapUsageOldGenRca, highHeapUsageYoungGenRca, highCpuRca});
        hotJVMNodeRca.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        hotJVMNodeRca.addAllUpstreams(Arrays.asList(highHeapUsageOldGenRca, highHeapUsageYoungGenRca, highCpuRca));
        HighHeapUsageClusterRca highHeapUsageClusterRca = new HighHeapUsageClusterRca(12, hotJVMNodeRca);
        highHeapUsageClusterRca.addTag("locus", "master-node");
        highHeapUsageClusterRca.addAllUpstreams(Collections.singletonList(hotJVMNodeRca));
        highHeapUsageClusterRca.addTag("aggregate-upstream", "data-node");
        HotNodeClusterRca hotNodeClusterRca = new HotNodeClusterRca(12, hotJVMNodeRca);
        hotNodeClusterRca.addTag("locus", "master-node");
        hotNodeClusterRca.addAllUpstreams(Collections.singletonList(hotJVMNodeRca));
        HighOldGenOccupancyRca oldGenOccupancyRca = new HighOldGenOccupancyRca(heapMax, heapUsed, gcType);
        oldGenOccupancyRca.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        oldGenOccupancyRca.addAllUpstreams(Arrays.asList(heapMax, heapUsed, gcType));
        OldGenReclamationRca oldGenReclamationRca = new OldGenReclamationRca(heapUsed, heapMax, gcEvent, gcType);
        oldGenReclamationRca.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        oldGenReclamationRca.addAllUpstreams(Arrays.asList(heapUsed, heapMax, gcEvent, gcType));
        OldGenContendedRca oldGenContendedRca = new OldGenContendedRca(oldGenOccupancyRca, oldGenReclamationRca);
        oldGenContendedRca.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        oldGenContendedRca.addAllUpstreams(Arrays.asList(oldGenOccupancyRca, oldGenReclamationRca));
        LargeHeapClusterRca largeHeapClusterRca = new LargeHeapClusterRca(oldGenContendedRca);
        largeHeapClusterRca.addTag("locus", "master-node");
        largeHeapClusterRca.addAllUpstreams(Collections.singletonList(oldGenContendedRca));
        largeHeapClusterRca.addTag("aggregate-upstream", "data-node");
        HeapHealthDecider heapHealthDecider = new HeapHealthDecider(12, highHeapUsageClusterRca, largeHeapClusterRca);
        heapHealthDecider.addTag("locus", "master-node");
        heapHealthDecider.addAllUpstreams(Arrays.asList(highHeapUsageClusterRca, largeHeapClusterRca));
        ThreadPool_RejectedReqs threadpool_RejectedReqs = new ThreadPool_RejectedReqs(5L);
        threadpool_RejectedReqs.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        this.addLeaf(threadpool_RejectedReqs);
        QueueRejectionRca queueRejectionNodeRca = new QueueRejectionRca(12, threadpool_RejectedReqs);
        queueRejectionNodeRca.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        queueRejectionNodeRca.addAllUpstreams(Collections.singletonList(threadpool_RejectedReqs));
        QueueRejectionClusterRca queueRejectionClusterRca = new QueueRejectionClusterRca(12, queueRejectionNodeRca);
        queueRejectionClusterRca.addTag("locus", "master-node");
        queueRejectionClusterRca.addAllUpstreams(Collections.singletonList(queueRejectionNodeRca));
        queueRejectionClusterRca.addTag("aggregate-upstream", "data-node");
        QueueHealthDecider queueHealthDecider = new QueueHealthDecider(5L, 12, queueRejectionClusterRca, highHeapUsageClusterRca);
        queueHealthDecider.addTag("locus", "master-node");
        queueHealthDecider.addAllUpstreams(Arrays.asList(queueRejectionClusterRca, highHeapUsageClusterRca));
        ThreadPool_QueueCapacity queueCapacity = new ThreadPool_QueueCapacity();
        queueCapacity.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        this.addLeaf(queueCapacity);
        Cache_Max_Size cacheMaxSize = new Cache_Max_Size(5L);
        cacheMaxSize.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        this.addLeaf(cacheMaxSize);
        NodeConfigCollector nodeConfigCollector = new NodeConfigCollector(12, queueCapacity, cacheMaxSize, heapMax);
        nodeConfigCollector.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        nodeConfigCollector.addAllUpstreams(Arrays.asList(queueCapacity, cacheMaxSize, heapMax));
        NodeConfigClusterCollector nodeConfigClusterCollector = new NodeConfigClusterCollector(nodeConfigCollector);
        nodeConfigClusterCollector.addTag("locus", "master-node");
        nodeConfigClusterCollector.addAllUpstreams(Collections.singletonList(nodeConfigCollector));
        nodeConfigClusterCollector.addTag("aggregate-upstream", "data-node");
        Cache_FieldData_Eviction fieldDataCacheEvictions = new Cache_FieldData_Eviction(5L);
        fieldDataCacheEvictions.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        this.addLeaf(fieldDataCacheEvictions);
        AggregateMetric fieldDataCacheSizeGroupByOperation = new AggregateMetric(5L, Cache_FieldData_Size.NAME, AggregateMetric.AggregateFunction.SUM, "max", AllMetrics.ShardStatsDerivedDimension.INDEX_NAME.toString());
        fieldDataCacheSizeGroupByOperation.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        this.addLeaf(fieldDataCacheSizeGroupByOperation);
        FieldDataCacheRca fieldDataCacheNodeRca = new FieldDataCacheRca(12, fieldDataCacheEvictions, fieldDataCacheSizeGroupByOperation);
        fieldDataCacheNodeRca.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        fieldDataCacheNodeRca.addAllUpstreams(Arrays.asList(fieldDataCacheEvictions, fieldDataCacheSizeGroupByOperation));
        FieldDataCacheClusterRca fieldDataCacheClusterRca = new FieldDataCacheClusterRca(12, fieldDataCacheNodeRca);
        fieldDataCacheClusterRca.addTag("locus", "master-node");
        fieldDataCacheClusterRca.addAllUpstreams(Collections.singletonList(fieldDataCacheNodeRca));
        fieldDataCacheClusterRca.addTag("aggregate-upstream", "data-node");
        Cache_Request_Eviction shardRequestCacheEvictions = new Cache_Request_Eviction(5L);
        shardRequestCacheEvictions.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        this.addLeaf(shardRequestCacheEvictions);
        Cache_Request_Hit shardRequestHits = new Cache_Request_Hit(5L);
        shardRequestHits.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        this.addLeaf(shardRequestHits);
        AggregateMetric shardRequestCacheSizeGroupByOperation = new AggregateMetric(5L, Cache_Request_Size.NAME, AggregateMetric.AggregateFunction.SUM, "max", AllMetrics.ShardStatsDerivedDimension.INDEX_NAME.toString());
        shardRequestCacheSizeGroupByOperation.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        this.addLeaf(shardRequestCacheSizeGroupByOperation);
        ShardRequestCacheRca shardRequestCacheNodeRca = new ShardRequestCacheRca(12, shardRequestCacheEvictions, shardRequestHits, shardRequestCacheSizeGroupByOperation);
        shardRequestCacheNodeRca.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        shardRequestCacheNodeRca.addAllUpstreams(Arrays.asList(shardRequestCacheEvictions, shardRequestHits, shardRequestCacheSizeGroupByOperation));
        ShardRequestCacheClusterRca shardRequestCacheClusterRca = new ShardRequestCacheClusterRca(12, shardRequestCacheNodeRca);
        shardRequestCacheClusterRca.addTag("locus", "master-node");
        shardRequestCacheClusterRca.addAllUpstreams(Collections.singletonList(shardRequestCacheNodeRca));
        shardRequestCacheClusterRca.addTag("aggregate-upstream", "data-node");
        CacheHealthDecider cacheHealthDecider = new CacheHealthDecider(5L, 12, fieldDataCacheClusterRca, shardRequestCacheClusterRca, highHeapUsageClusterRca);
        cacheHealthDecider.addTag("locus", "master-node");
        cacheHealthDecider.addAllUpstreams(Arrays.asList(fieldDataCacheClusterRca, shardRequestCacheClusterRca, highHeapUsageClusterRca));
        AdmissionControlDecider admissionControlDecider = this.buildAdmissionControlDecider(heapUsed, heapMax);
        this.constructShardResourceUsageGraph();
        this.constructResourceHeatMapGraph();
        Collator collator = new Collator(queueHealthDecider, cacheHealthDecider, heapHealthDecider, admissionControlDecider);
        collator.addTag("locus", "master-node");
        collator.addAllUpstreams(Arrays.asList(queueHealthDecider, cacheHealthDecider, heapHealthDecider, admissionControlDecider));
        Publisher publisher = new Publisher(5, collator);
        publisher.addTag("locus", "master-node");
        publisher.addAllUpstreams(Collections.singletonList(collator));
        PluginControllerConfig pluginControllerConfig = new PluginControllerConfig();
        PluginController pluginController = new PluginController(pluginControllerConfig, publisher);
        pluginController.initPlugins();
    }

    private AdmissionControlDecider buildAdmissionControlDecider(Metric heapUsed, Metric heapMax) {
        AdmissionControlRca admissionControlRca = new AdmissionControlRca(12, heapUsed, heapMax);
        admissionControlRca.addTag("locus", "data-node");
        admissionControlRca.addAllUpstreams(Arrays.asList(heapUsed, heapMax));
        AdmissionControlClusterRca admissionControlClusterRca = new AdmissionControlClusterRca(12, admissionControlRca);
        admissionControlClusterRca.addTag("locus", "master-node");
        admissionControlClusterRca.addAllUpstreams(Collections.singletonList(admissionControlRca));
        admissionControlClusterRca.addTag("aggregate-upstream", "data-node");
        AdmissionControlDecider admissionControlDecider = new AdmissionControlDecider(5L, 12, admissionControlClusterRca);
        admissionControlDecider.addTag("locus", "master-node");
        admissionControlDecider.addAllUpstreams(Collections.singletonList(admissionControlClusterRca));
        return admissionControlDecider;
    }

    private void constructShardResourceUsageGraph() {
        CPU_Utilization cpuUtilization = new CPU_Utilization(5L);
        IO_TotThroughput ioTotThroughput = new IO_TotThroughput(5L);
        IO_TotalSyscallRate ioTotSyscallRate = new IO_TotalSyscallRate(5L);
        cpuUtilization.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        ioTotThroughput.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        ioTotSyscallRate.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        this.addLeaf(cpuUtilization);
        this.addLeaf(ioTotThroughput);
        this.addLeaf(ioTotSyscallRate);
        HotShardRca hotShardRca = new HotShardRca(5L, 12, cpuUtilization, ioTotThroughput, ioTotSyscallRate);
        hotShardRca.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        hotShardRca.addAllUpstreams(Arrays.asList(cpuUtilization, ioTotThroughput, ioTotSyscallRate));
        HotShardClusterRca hotShardClusterRca = new HotShardClusterRca(12, hotShardRca);
        hotShardClusterRca.addTag("locus", "master-node");
        hotShardClusterRca.addAllUpstreams(Collections.singletonList(hotShardRca));
        hotShardClusterRca.addTag("aggregate-upstream", "data-node");
    }

    private List<Metric> constructNodeStatsMetrics() {
        ArrayList<Metric> nodeStatsMetrics = new ArrayList<Metric>(){
            {
                this.add(new Cache_FieldData_Size(5L));
                this.add(new Cache_Request_Size(5L));
                this.add(new Cache_Query_Size(5L));
                this.add(new IndexWriter_Memory(5L));
                this.add(new Bitset_Memory(5L));
                this.add(new VersionMap_Memory(5L));
            }
        };
        for (Metric metric : nodeStatsMetrics) {
            metric.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
            this.addLeaf(metric);
        }
        return nodeStatsMetrics;
    }

    protected void constructResourceHeatMapGraph() {
        LOG.info("Constructing temperature profile RCA components");
        ShardStore shardStore = new ShardStore();
        HeapAllocRateByShardTemperatureCalculator heapAllocByShard = new HeapAllocRateByShardTemperatureCalculator();
        HeapAllocRateByShardAvgTemperatureCalculator heapAllocRateByShardAvg = new HeapAllocRateByShardAvgTemperatureCalculator();
        HeapAllocRateShardIndependentTemperatureCalculator shardIndependentHeapAllocRate = new HeapAllocRateShardIndependentTemperatureCalculator();
        HeapAllocRateTotalTemperatureCalculator heapAllocRateTotal = new HeapAllocRateTotalTemperatureCalculator();
        CpuUtilByShardsMetricBasedTemperatureCalculator cpuUtilByShard = new CpuUtilByShardsMetricBasedTemperatureCalculator();
        AvgCpuUtilByShardsMetricBasedTemperatureCalculator avgCpuUtilByShards = new AvgCpuUtilByShardsMetricBasedTemperatureCalculator();
        ShardIndependentTemperatureCalculatorCpuUtilMetric shardIndependentCpuUtilMetric = new ShardIndependentTemperatureCalculatorCpuUtilMetric();
        TotalCpuUtilForTotalNodeMetric cpuUtilPeakUsage = new TotalCpuUtilForTotalNodeMetric();
        ShardSizeMetricBasedTemperatureCalculator shardSizeByShard = new ShardSizeMetricBasedTemperatureCalculator();
        ShardSizeAvgTemperatureCalculator shardSizeAvg = new ShardSizeAvgTemperatureCalculator();
        ShardTotalDiskUsageTemperatureCalculator shardTotalDiskUsage = new ShardTotalDiskUsageTemperatureCalculator();
        cpuUtilByShard.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        avgCpuUtilByShards.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        shardIndependentCpuUtilMetric.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        cpuUtilPeakUsage.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        heapAllocByShard.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        heapAllocRateByShardAvg.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        shardIndependentHeapAllocRate.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        heapAllocRateTotal.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        shardSizeByShard.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        shardSizeAvg.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        shardTotalDiskUsage.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        this.addLeaf(cpuUtilByShard);
        this.addLeaf(avgCpuUtilByShards);
        this.addLeaf(shardIndependentCpuUtilMetric);
        this.addLeaf(cpuUtilPeakUsage);
        this.addLeaf(heapAllocByShard);
        this.addLeaf(heapAllocRateByShardAvg);
        this.addLeaf(shardIndependentHeapAllocRate);
        this.addLeaf(heapAllocRateTotal);
        this.addLeaf(shardSizeByShard);
        this.addLeaf(shardSizeAvg);
        this.addLeaf(shardTotalDiskUsage);
        CpuUtilDimensionTemperatureRca cpuUtilHeat = new CpuUtilDimensionTemperatureRca(5L, shardStore, cpuUtilByShard, avgCpuUtilByShards, shardIndependentCpuUtilMetric, cpuUtilPeakUsage);
        cpuUtilHeat.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        cpuUtilHeat.addAllUpstreams(Arrays.asList(cpuUtilByShard, avgCpuUtilByShards, shardIndependentCpuUtilMetric, cpuUtilPeakUsage));
        HeapAllocRateTemperatureRca heapAllocRateHeat = new HeapAllocRateTemperatureRca(5L, shardStore, heapAllocByShard, heapAllocRateByShardAvg, shardIndependentHeapAllocRate, heapAllocRateTotal);
        heapAllocRateHeat.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        heapAllocRateHeat.addAllUpstreams(Arrays.asList(heapAllocByShard, heapAllocRateByShardAvg, shardIndependentHeapAllocRate, heapAllocRateTotal));
        ShardSizeDimensionTemperatureRca shardSizeHeat = new ShardSizeDimensionTemperatureRca(5L, shardStore, shardSizeByShard, shardSizeAvg, shardTotalDiskUsage);
        shardSizeHeat.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        shardSizeHeat.addAllUpstreams(Arrays.asList(shardSizeByShard, shardSizeAvg, shardTotalDiskUsage));
        NodeTemperatureRca nodeTemperatureRca = new NodeTemperatureRca(cpuUtilHeat, heapAllocRateHeat, shardSizeHeat);
        nodeTemperatureRca.addTag("locus", RcaConsts.RcaTagConstants.LOCUS_DATA_MASTER_NODE);
        nodeTemperatureRca.addAllUpstreams(Arrays.asList(cpuUtilHeat, heapAllocRateHeat, shardSizeHeat));
    }
}

