/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.common.utils;

import com.google.common.base.Strings;
import java.util.Locale;

public class StringUtils {
    public static String unquote(String text, String mark) {
        if (StringUtils.isQuoted(text, mark)) {
            return text.substring(mark.length(), text.length() - mark.length());
        }
        return text;
    }

    public static String unquoteText(String text) {
        if (StringUtils.isQuoted(text, "\"") || StringUtils.isQuoted(text, "'") || StringUtils.isQuoted(text, "`")) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    public static String unquoteIdentifier(String identifier) {
        if (StringUtils.isQuoted(identifier, "`")) {
            return identifier.substring(1, identifier.length() - 1);
        }
        return identifier;
    }

    public static String format(String format, Object ... args) {
        return String.format(Locale.ROOT, format, args);
    }

    private static boolean isQuoted(String text, String mark) {
        return !Strings.isNullOrEmpty((String)text) && text.startsWith(mark) && text.endsWith(mark);
    }
}

