/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.common.setting;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class Settings {
    public abstract <T> T getSettingValue(Key var1);

    public abstract List<?> getSettings();

    public static enum Key {
        SQL_ENABLED("plugins.sql.enabled"),
        SQL_SLOWLOG("plugins.sql.slowlog"),
        SQL_CURSOR_KEEP_ALIVE("plugins.sql.cursor.keep_alive"),
        SQL_DELETE_ENABLED("plugins.sql.delete.enabled"),
        PPL_ENABLED("plugins.ppl.enabled"),
        QUERY_MEMORY_LIMIT("plugins.query.memory_limit"),
        QUERY_SIZE_LIMIT("plugins.query.size_limit"),
        METRICS_ROLLING_WINDOW("plugins.query.metrics.rolling_window"),
        METRICS_ROLLING_INTERVAL("plugins.query.metrics.rolling_interval");

        private final String keyValue;
        private static final Map<String, Key> ALL_KEYS;

        public static Optional<Key> of(String keyValue) {
            String key = Strings.isNullOrEmpty((String)keyValue) ? "" : keyValue.toLowerCase();
            return Optional.ofNullable(ALL_KEYS.getOrDefault(key, null));
        }

        private Key(String keyValue) {
            this.keyValue = keyValue;
        }

        public String getKeyValue() {
            return this.keyValue;
        }

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Key key : Key.values()) {
                builder.put((Object)key.getKeyValue(), (Object)key);
            }
            ALL_KEYS = builder.build();
        }
    }
}

