/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.action.stop;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.admin.indices.open.OpenIndexRequest;
import org.opensearch.action.admin.indices.open.OpenIndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.action.support.master.TransportMasterNodeAction;
import org.opensearch.client.Client;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.client.Requests;
import org.opensearch.cluster.AckedClusterStateUpdateTask;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.RestoreInProgress;
import org.opensearch.cluster.ack.AckedRequest;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.block.ClusterBlocks;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.settings.Settings;
import org.opensearch.replication.ReplicationPlugin;
import org.opensearch.replication.action.index.block.IndexBlockUpdateType;
import org.opensearch.replication.action.index.block.UpdateIndexBlockAction;
import org.opensearch.replication.action.index.block.UpdateIndexBlockRequest;
import org.opensearch.replication.action.stop.StopIndexReplicationRequest;
import org.opensearch.replication.metadata.ReplicationMetadataManager;
import org.opensearch.replication.metadata.ReplicationOverallState;
import org.opensearch.replication.metadata.UpdateIndexBlockTaskKt;
import org.opensearch.replication.metadata.UpdateMetadataAction;
import org.opensearch.replication.metadata.UpdateMetadataRequest;
import org.opensearch.replication.metadata.state.ReplicationStateMetadataKt;
import org.opensearch.replication.metadata.store.ReplicationMetadata;
import org.opensearch.replication.seqno.RemoteClusterRetentionLeaseHelper;
import org.opensearch.replication.util.CoroutinesKt;
import org.opensearch.replication.util.ExtensionsKt;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

@kotlin.Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 +2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0002+,B?\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\"H\u0014J&\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030&H\u0014J\u0010\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)H\u0014J\u0010\u0010*\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u0002H\u0002R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006-"}, d2={"Lorg/opensearch/replication/action/stop/TransportStopIndexReplicationAction;", "Lorg/opensearch/action/support/master/TransportMasterNodeAction;", "Lorg/opensearch/replication/action/stop/StopIndexReplicationRequest;", "Lorg/opensearch/action/support/master/AcknowledgedResponse;", "Lkotlinx/coroutines/CoroutineScope;", "transportService", "Lorg/opensearch/transport/TransportService;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "client", "Lorg/opensearch/client/Client;", "replicationMetadataManager", "Lorg/opensearch/replication/metadata/ReplicationMetadataManager;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;Lorg/opensearch/client/Client;Lorg/opensearch/replication/metadata/ReplicationMetadataManager;)V", "getClient", "()Lorg/opensearch/client/Client;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "getReplicationMetadataManager", "()Lorg/opensearch/replication/metadata/ReplicationMetadataManager;", "checkBlock", "Lorg/opensearch/cluster/block/ClusterBlockException;", "request", "state", "Lorg/opensearch/cluster/ClusterState;", "executor", "", "masterOperation", "", "listener", "Lorg/opensearch/action/ActionListener;", "read", "inp", "Lorg/opensearch/common/io/stream/StreamInput;", "validateStopReplicationRequest", "Companion", "StopReplicationTask", "opensearch-cross-cluster-replication"})
public final class TransportStopIndexReplicationAction
extends TransportMasterNodeAction<StopIndexReplicationRequest, AcknowledgedResponse>
implements CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Client client;
    @NotNull
    private final ReplicationMetadataManager replicationMetadataManager;
    private final /* synthetic */ GlobalScope $$delegate_0;
    private static final Logger log = LogManager.getLogger(TransportStopIndexReplicationAction.class);

    @Inject
    public TransportStopIndexReplicationAction(@NotNull TransportService transportService, @NotNull ClusterService clusterService, @NotNull ThreadPool threadPool, @NotNull ActionFilters actionFilters, @NotNull IndexNameExpressionResolver indexNameExpressionResolver, @NotNull Client client, @NotNull ReplicationMetadataManager replicationMetadataManager) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)replicationMetadataManager, (String)"replicationMetadataManager");
        super("indices:admin/plugins/replication/index/stop", transportService, clusterService, threadPool, actionFilters, StopIndexReplicationRequest::new, indexNameExpressionResolver);
        this.client = client;
        this.replicationMetadataManager = replicationMetadataManager;
        this.$$delegate_0 = GlobalScope.INSTANCE;
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ReplicationMetadataManager getReplicationMetadataManager() {
        return this.replicationMetadataManager;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.$$delegate_0.getCoroutineContext();
    }

    @Nullable
    protected ClusterBlockException checkBlock(@NotNull StopIndexReplicationRequest request, @NotNull ClusterState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(@NotNull StopIndexReplicationRequest request, @NotNull ClusterState state, @NotNull ActionListener<AcknowledgedResponse> listener2) throws Exception {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        CoroutineScope coroutineScope = this;
        CoroutineDispatcher coroutineDispatcher = Dispatchers.getUnconfined();
        ThreadPool threadPool = this.threadPool;
        Intrinsics.checkNotNullExpressionValue((Object)threadPool, (String)"threadPool");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineDispatcher.plus(CoroutinesKt.coroutineContext(threadPool)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(request, this, state, listener2, null){
            int I$0;
            int label;
            final /* synthetic */ StopIndexReplicationRequest $request;
            final /* synthetic */ TransportStopIndexReplicationAction this$0;
            final /* synthetic */ ClusterState $state;
            final /* synthetic */ ActionListener<AcknowledgedResponse> $listener;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                this.$state = $state;
                this.$listener = $listener;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var18_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        TransportStopIndexReplicationAction.access$getLog$cp().info(Intrinsics.stringPlus((String)"Stopping index replication on index:", (Object)this.$request.getIndexName()));
                        updateIndexBlockRequest = new UpdateIndexBlockRequest(this.$request.getIndexName(), IndexBlockUpdateType.REMOVE_BLOCK);
                        this.label = 1;
                        v0 = CoroutinesKt.suspendExecute$default((OpenSearchClient)this.this$0.getClient(), UpdateIndexBlockAction.Companion.getINSTANCE(), (ActionRequest)updateIndexBlockRequest, true, false, (Continuation)this, 8, null);
                        ** if (v0 != var18_2) goto lbl13
lbl12:
                        // 1 sources

                        return var18_2;
lbl13:
                        // 1 sources

                        ** GOTO lbl19
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl19:
                        // 2 sources

                        if (!(updateIndexBlockResponse = (AcknowledgedResponse)v0).isAcknowledged()) {
                            throw new OpenSearchException(Intrinsics.stringPlus((String)"Failed to remove index block on ", (Object)this.$request.getIndexName()), new Object[0]);
                        }
                        TransportStopIndexReplicationAction.access$validateStopReplicationRequest(this.this$0, this.$request);
                        var5_6 /* !! */  = TransportStopIndexReplicationAction.access$getClusterService$p$s533819131(this.this$0).state().custom("restore", (ClusterState.Custom)RestoreInProgress.EMPTY);
                        Intrinsics.checkNotNullExpressionValue((Object)var5_6 /* !! */ , (String)"clusterService.state().c\u2026 RestoreInProgress.EMPTY)");
                        var5_6 /* !! */  = (Iterable)var5_6 /* !! */ ;
                        var6_7 = this.$request;
                        $i$f$any = false;
                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl30
                        v1 = 0;
                        ** GOTO lbl52
lbl30:
                        // 2 sources

                        for (E element$iv : $this$any$iv) {
                            entry = (RestoreInProgress.Entry)element$iv;
                            $i$a$-any-TransportStopIndexReplicationAction$masterOperation$1$restoring$1 = false;
                            var12_16 = entry.indices();
                            Intrinsics.checkNotNullExpressionValue((Object)var12_16, (String)"entry.indices()");
                            $this$any$iv = var12_16;
                            $i$f$any = false;
                            if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl40
                            v2 = false;
                            ** GOTO lbl48
lbl40:
                            // 2 sources

                            for (T element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                $i$a$-any-TransportStopIndexReplicationAction$masterOperation$1$restoring$1$1 = false;
                                if (!Intrinsics.areEqual((Object)it, (Object)var6_7.getIndexName())) continue;
                                v2 = true;
                                ** GOTO lbl48
                            }
                            v2 = false;
lbl48:
                            // 3 sources

                            if (!v2) continue;
                            v1 = 1;
                            ** GOTO lbl52
                        }
                        v1 = restoring = 0;
lbl52:
                        // 3 sources

                        if (restoring != 0) {
                            TransportStopIndexReplicationAction.access$getLog$cp().info("Index[" + this.$request.getIndexName() + "] is in restoring stage");
                        }
                        if (restoring != 0 || !this.$state.getRoutingTable().hasIndex(this.$request.getIndexName())) ** GOTO lbl73
                        v3 = this.$request.getIndexName();
                        var6_7 = Requests.closeIndexRequest((String)this.$request.getIndexName());
                        Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"closeIndexRequest(request.indexName)");
                        updateRequest = new UpdateMetadataRequest(v3, UpdateMetadataRequest.Type.CLOSE, var6_7);
                        this.I$0 = restoring;
                        this.label = 2;
                        v4 = CoroutinesKt.suspendExecute$default((OpenSearchClient)this.this$0.getClient(), UpdateMetadataAction.Companion.getINSTANCE(), (ActionRequest)updateRequest, true, false, (Continuation)this, 8, null);
                        ** if (v4 != var18_2) goto lbl64
lbl63:
                        // 1 sources

                        return var18_2;
lbl64:
                        // 1 sources

                        ** GOTO lbl71
                    }
                    case 2: {
                        restoring = this.I$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl71:
                        // 2 sources

                        if (!(closeResponse = (AcknowledgedResponse)v4).isAcknowledged()) {
                            throw new OpenSearchException(Intrinsics.stringPlus((String)"Unable to close index: ", (Object)this.$request.getIndexName()), new Object[0]);
                        }
lbl73:
                        // 3 sources

                        this.I$0 = restoring;
                        this.label = 3;
                        v5 = ReplicationMetadataManager.getIndexReplicationMetadata$default(this.this$0.getReplicationMetadataManager(), this.$request.getIndexName(), false, (Continuation)this, 2, null);
                        ** if (v5 != var18_2) goto lbl78
lbl77:
                        // 1 sources

                        return var18_2;
lbl78:
                        // 1 sources

                        ** GOTO lbl85
                    }
                    case 3: {
                        restoring = this.I$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl85:
                        // 2 sources

                        replMetadata = (ReplicationMetadata)v5;
                        remoteClient = this.this$0.getClient().getRemoteClusterClient(replMetadata.getConnectionName());
                        var8_12 = TransportStopIndexReplicationAction.access$getClusterService$p$s533819131(this.this$0).getClusterName().value();
                        Intrinsics.checkNotNullExpressionValue((Object)var8_12, (String)"clusterService.clusterName.value()");
                        Intrinsics.checkNotNullExpressionValue((Object)remoteClient, (String)"remoteClient");
                        retentionLeaseHelper = new RemoteClusterRetentionLeaseHelper((String)var8_12, remoteClient);
                        var8_12 = TransportStopIndexReplicationAction.access$getClusterService$p$s533819131(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)var8_12, (String)"clusterService");
                        this.I$0 = restoring;
                        this.label = 4;
                        v6 = retentionLeaseHelper.attemptRemoveRetentionLease((ClusterService)var8_12, replMetadata, this.$request.getIndexName(), (Continuation<? super Unit>)((Continuation)this));
                        ** if (v6 != var18_2) goto lbl100
lbl99:
                        // 1 sources

                        return var18_2;
lbl100:
                        // 1 sources

                        ** GOTO lbl111
                    }
                    case 4: {
                        restoring = this.I$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
                        {
                            catch (Exception e) {
                                TransportStopIndexReplicationAction.access$getLog$cp().error("Failed to remove retention lease from the leader cluster", (Throwable)e);
                            }
                        }
lbl111:
                        // 3 sources

                        retentionLeaseHelper = TransportStopIndexReplicationAction.access$getClusterService$p$s533819131(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)retentionLeaseHelper, (String)"clusterService");
                        this.I$0 = restoring;
                        this.label = 5;
                        v7 = CoroutinesKt.waitForClusterStateUpdate(retentionLeaseHelper, "stop_replication", (Function1)new Function1<ActionListener<AcknowledgedResponse>, AckedClusterStateUpdateTask<AcknowledgedResponse>>(this.$request){
                            final /* synthetic */ StopIndexReplicationRequest $request;
                            {
                                this.$request = $request;
                                super(1);
                            }

                            @NotNull
                            public final AckedClusterStateUpdateTask<AcknowledgedResponse> invoke(@NotNull ActionListener<AcknowledgedResponse> l) {
                                Intrinsics.checkNotNullParameter(l, (String)"l");
                                return new StopReplicationTask(this.$request, l);
                            }
                        }, (Continuation)this);
                        ** if (v7 != var18_2) goto lbl118
lbl117:
                        // 1 sources

                        return var18_2;
lbl118:
                        // 1 sources

                        ** GOTO lbl125
                    }
                    case 5: {
                        restoring = this.I$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl125:
                        // 2 sources

                        if (!(clusterStateUpdateResponse = (AcknowledgedResponse)v7).isAcknowledged()) {
                            throw new OpenSearchException("Failed to update cluster state", new Object[0]);
                        }
                        if (restoring != 0 || !this.$state.getRoutingTable().hasIndex(this.$request.getIndexName())) ** GOTO lbl154
                        v8 = this.this$0.getClient();
                        var8_12 = this.this$0.getClient().admin().indices();
                        Intrinsics.checkNotNullExpressionValue((Object)var8_12, (String)"client.admin().indices()");
                        this.label = 6;
                        v9 = CoroutinesKt.suspending$default(v8, (Function2)new Function2<OpenIndexRequest, ActionListener<OpenIndexResponse>, Unit>(var8_12){

                            public final void invoke(OpenIndexRequest p0, ActionListener<OpenIndexResponse> p1) {
                                ((IndicesAdminClient)this.receiver).open(p0, p1);
                            }
                        }, true, false, (Continuation)this, 4, null);
                        ** if (v9 != var18_2) goto lbl135
lbl134:
                        // 1 sources

                        return var18_2;
lbl135:
                        // 1 sources

                        ** GOTO lbl141
                    }
                    case 6: {
                        ResultKt.throwOnFailure((Object)$result);
                        v9 = $result;
lbl141:
                        // 2 sources

                        var8_12 = new String[]{this.$request.getIndexName()};
                        this.label = 7;
                        v10 = ((Function2)v9).invoke((Object)new OpenIndexRequest((String[])var8_12), (Object)this);
                        ** if (v10 != var18_2) goto lbl146
lbl145:
                        // 1 sources

                        return var18_2;
lbl146:
                        // 1 sources

                        ** GOTO lbl152
                    }
                    case 7: {
                        ResultKt.throwOnFailure((Object)$result);
                        v10 = $result;
lbl152:
                        // 2 sources

                        if (!(reopenResponse = (OpenIndexResponse)v10).isAcknowledged()) {
                            throw new OpenSearchException(Intrinsics.stringPlus((String)"Failed to reopen index: ", (Object)this.$request.getIndexName()), new Object[0]);
                        }
lbl154:
                        // 3 sources

                        this.label = 8;
                        v11 = this.this$0.getReplicationMetadataManager().deleteIndexReplicationMetadata(this.$request.getIndexName(), (Continuation<? super Unit>)((Continuation)this));
                        ** if (v11 != var18_2) goto lbl158
lbl157:
                        // 1 sources

                        return var18_2;
lbl158:
                        // 1 sources

                        ** GOTO lbl164
                    }
                    case 8: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v11 = $result;
lbl164:
                            // 2 sources

                            this.$listener.onResponse((Object)new AcknowledgedResponse(true));
                        }
                        catch (Exception e) {
                            TransportStopIndexReplicationAction.access$getLog$cp().error("Stop replication failed for index[" + this.$request.getIndexName() + "] with error " + ExtensionsKt.stackTraceToString(e));
                            this.$listener.onFailure(e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void validateStopReplicationRequest(StopIndexReplicationRequest request) {
        ClusterService clusterService = this.clusterService;
        Intrinsics.checkNotNullExpressionValue((Object)clusterService, (String)"clusterService");
        Map<String, String> map = ReplicationStateMetadataKt.getReplicationStateParamsForIndex(clusterService, request.getIndexName());
        if (map == null) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"No replication in progress for index:", (Object)request.getIndexName()));
        }
        Map<String, String> replicationStateParams = map;
        String replicationOverallState = replicationStateParams.get("REPLICATION_LAST_KNOWN_OVERALL_STATE");
        if (Intrinsics.areEqual((Object)replicationOverallState, (Object)ReplicationOverallState.RUNNING.name()) || Intrinsics.areEqual((Object)replicationOverallState, (Object)ReplicationOverallState.STOPPED.name()) || Intrinsics.areEqual((Object)replicationOverallState, (Object)ReplicationOverallState.FAILED.name()) || Intrinsics.areEqual((Object)replicationOverallState, (Object)ReplicationOverallState.PAUSED.name())) {
            return;
        }
        throw new IllegalStateException(Intrinsics.stringPlus((String)"Unknown value of replication state:", (Object)replicationOverallState));
    }

    @NotNull
    protected String executor() {
        return "same";
    }

    @NotNull
    protected AcknowledgedResponse read(@NotNull StreamInput inp) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        return new AcknowledgedResponse(inp);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ void access$validateStopReplicationRequest(TransportStopIndexReplicationAction $this, StopIndexReplicationRequest request) {
        $this.validateStopReplicationRequest(request);
    }

    public static final /* synthetic */ ClusterService access$getClusterService$p$s533819131(TransportStopIndexReplicationAction $this) {
        return $this.clusterService;
    }

    @kotlin.Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/opensearch/replication/action/stop/TransportStopIndexReplicationAction$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @kotlin.Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/opensearch/replication/action/stop/TransportStopIndexReplicationAction$StopReplicationTask;", "Lorg/opensearch/cluster/AckedClusterStateUpdateTask;", "Lorg/opensearch/action/support/master/AcknowledgedResponse;", "request", "Lorg/opensearch/replication/action/stop/StopIndexReplicationRequest;", "listener", "Lorg/opensearch/action/ActionListener;", "(Lorg/opensearch/replication/action/stop/StopIndexReplicationRequest;Lorg/opensearch/action/ActionListener;)V", "getRequest", "()Lorg/opensearch/replication/action/stop/StopIndexReplicationRequest;", "execute", "Lorg/opensearch/cluster/ClusterState;", "currentState", "newResponse", "acknowledged", "", "opensearch-cross-cluster-replication"})
    public static final class StopReplicationTask
    extends AckedClusterStateUpdateTask<AcknowledgedResponse> {
        @NotNull
        private final StopIndexReplicationRequest request;

        public StopReplicationTask(@NotNull StopIndexReplicationRequest request, @NotNull ActionListener<AcknowledgedResponse> listener2) {
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            Intrinsics.checkNotNullParameter(listener2, (String)"listener");
            super((AckedRequest)request, listener2);
            this.request = request;
        }

        @NotNull
        public final StopIndexReplicationRequest getRequest() {
            return this.request;
        }

        @NotNull
        public ClusterState execute(@NotNull ClusterState currentState) {
            Intrinsics.checkNotNullParameter((Object)currentState, (String)"currentState");
            ClusterState.Builder newState2 = ClusterState.builder((ClusterState)currentState);
            if (currentState.getBlocks().hasIndexBlock(this.request.getIndexName(), UpdateIndexBlockTaskKt.getINDEX_REPLICATION_BLOCK())) {
                ClusterBlocks.Builder newBlocks = ClusterBlocks.builder().blocks(currentState.getBlocks()).removeIndexBlock(this.request.getIndexName(), UpdateIndexBlockTaskKt.getINDEX_REPLICATION_BLOCK());
                newState2.blocks(newBlocks);
            }
            Metadata.Builder mdBuilder = Metadata.builder((Metadata)currentState.getMetadata());
            IndexMetadata currentIndexMetadata = currentState.getMetadata().index(this.request.getIndexName());
            if (currentIndexMetadata != null) {
                IndexMetadata.Builder newIndexMetadata = IndexMetadata.builder((IndexMetadata)currentIndexMetadata).settings(Settings.builder().put(currentIndexMetadata.getSettings()).putNull(ReplicationPlugin.Companion.getREPLICATED_INDEX_SETTING().getKey())).settingsVersion(1L + currentIndexMetadata.getSettingsVersion());
                mdBuilder.put(newIndexMetadata);
            }
            newState2.metadata(mdBuilder);
            ClusterState clusterState = newState2.build();
            Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"newState.build()");
            return clusterState;
        }

        @NotNull
        protected AcknowledgedResponse newResponse(boolean acknowledged) {
            return new AcknowledgedResponse(acknowledged);
        }
    }
}

