/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import java.io.IOException;
import java.util.Map;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;

public class KNNStatsNodeResponse
extends BaseNodeResponse
implements ToXContentFragment {
    private Map<String, Object> statsMap;

    public KNNStatsNodeResponse(StreamInput in) throws IOException {
        super(in);
        this.statsMap = in.readMap(StreamInput::readString, StreamInput::readGenericValue);
    }

    public KNNStatsNodeResponse(DiscoveryNode node, Map<String, Object> statsToValues) {
        super(node);
        this.statsMap = statsToValues;
    }

    public static KNNStatsNodeResponse readStats(StreamInput in) throws IOException {
        KNNStatsNodeResponse knnStats = new KNNStatsNodeResponse(in);
        return knnStats;
    }

    public Map<String, Object> getStatsMap() {
        return this.statsMap;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.statsMap, StreamOutput::writeString, StreamOutput::writeGenericValue);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (String stat : this.statsMap.keySet()) {
            builder.field(stat, this.statsMap.get(stat));
        }
        return builder;
    }
}

