/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.jni;

import java.util.Map;
import org.opensearch.knn.index.KNNQueryResult;
import org.opensearch.knn.index.util.KNNEngine;
import org.opensearch.knn.jni.FaissService;
import org.opensearch.knn.jni.NmslibService;

public class JNIService {
    public static void createIndex(int[] ids, float[][] data, String indexPath, Map<String, Object> parameters, String engineName) {
        if (KNNEngine.NMSLIB.getName().equals(engineName)) {
            NmslibService.createIndex(ids, data, indexPath, parameters);
            return;
        }
        if (KNNEngine.FAISS.getName().equals(engineName)) {
            FaissService.createIndex(ids, data, indexPath, parameters);
            return;
        }
        throw new IllegalArgumentException("CreateIndex not supported for provided engine");
    }

    public static void createIndexFromTemplate(int[] ids, float[][] data, String indexPath, byte[] templateIndex, Map<String, Object> parameters, String engineName) {
        if (KNNEngine.FAISS.getName().equals(engineName)) {
            FaissService.createIndexFromTemplate(ids, data, indexPath, templateIndex, parameters);
            return;
        }
        throw new IllegalArgumentException("CreateIndexFromTemplate not supported for provided engine");
    }

    public static long loadIndex(String indexPath, Map<String, Object> parameters, String engineName) {
        if (KNNEngine.NMSLIB.getName().equals(engineName)) {
            return NmslibService.loadIndex(indexPath, parameters);
        }
        if (KNNEngine.FAISS.getName().equals(engineName)) {
            return FaissService.loadIndex(indexPath);
        }
        throw new IllegalArgumentException("LoadIndex not supported for provided engine");
    }

    public static KNNQueryResult[] queryIndex(long indexPointer, float[] queryVector, int k, String engineName) {
        if (KNNEngine.NMSLIB.getName().equals(engineName)) {
            return NmslibService.queryIndex(indexPointer, queryVector, k);
        }
        if (KNNEngine.FAISS.getName().equals(engineName)) {
            return FaissService.queryIndex(indexPointer, queryVector, k);
        }
        throw new IllegalArgumentException("QueryIndex not supported for provided engine");
    }

    public static void free(long indexPointer, String engineName) {
        if (KNNEngine.NMSLIB.getName().equals(engineName)) {
            NmslibService.free(indexPointer);
            return;
        }
        if (KNNEngine.FAISS.getName().equals(engineName)) {
            FaissService.free(indexPointer);
            return;
        }
        throw new IllegalArgumentException("Free not supported for provided engine");
    }

    public static byte[] trainIndex(Map<String, Object> indexParameters, int dimension, long trainVectorsPointer, String engineName) {
        if (KNNEngine.FAISS.getName().equals(engineName)) {
            return FaissService.trainIndex(indexParameters, dimension, trainVectorsPointer);
        }
        throw new IllegalArgumentException("TrainIndex not supported for provided engine");
    }

    public static long transferVectors(long vectorsPointer, float[][] trainingData) {
        return FaissService.transferVectors(vectorsPointer, trainingData);
    }

    public static void freeVectors(long vectorsPointer) {
        FaissService.freeVectors(vectorsPointer);
    }
}

